/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.boot.BootLoader;

public class AntClassLoader
extends URLClassLoader {
    protected ClassLoader[] pluginLoaders;
    private static final String ANT_PACKAGES_PREFIX = "org.apache.tools.ant";
    private static final String[] ECLIPSE_ANT_PACKAGES_PREFIXES = new String[4];
    private static final boolean devMode = BootLoader.inDevelopmentMode();

    static {
        if (devMode) {
            AntClassLoader.ECLIPSE_ANT_PACKAGES_PREFIXES[0] = "org.eclipse.ant.internal.core.ant";
            AntClassLoader.ECLIPSE_ANT_PACKAGES_PREFIXES[1] = "org.eclipse.ui.externaltools.internal.ant.logger";
            AntClassLoader.ECLIPSE_ANT_PACKAGES_PREFIXES[2] = "org.eclipse.ui.externaltools.internal.ant.inputhandler";
            AntClassLoader.ECLIPSE_ANT_PACKAGES_PREFIXES[3] = "org.eclipse.ant.tests.core.support";
        }
    }

    public AntClassLoader(URL[] urls, ClassLoader[] pluginLoaders) {
        super(urls, ClassLoader.getSystemClassLoader());
        this.pluginLoaders = pluginLoaders;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class result = null;
        if (!name.startsWith(ANT_PACKAGES_PREFIX)) {
            if (devMode) {
                if (this.shouldPluginsLoad(name)) {
                    result = this.loadClassPlugins(name);
                }
            } else {
                result = this.loadClassPlugins(name);
            }
        }
        if (result == null) {
            result = this.loadClassURLs(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private boolean shouldPluginsLoad(String name) {
        int i = 0;
        while (i < ECLIPSE_ANT_PACKAGES_PREFIXES.length) {
            String prefix = ECLIPSE_ANT_PACKAGES_PREFIXES[i];
            if (name.startsWith(prefix)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Class loadClassURLs(String name) {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected Class loadClassPlugins(String name) {
        Class<?> result = null;
        if (this.pluginLoaders != null) {
            int i = 0;
            while (i < this.pluginLoaders.length && result == null) {
                try {
                    result = this.pluginLoaders[i].loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                ++i;
            }
        }
        return result;
    }
}

