/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.transport;

import com.sap.engine.frame.cluster.transport.TransportFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;

public class ClientPortsManager {
    Hashtable propertyData = new Hashtable();

    public ClientPortsManager() {
        this.propertyData.put("httptunneling", "com.sap.engine.services.httptunneling.HttpTunnelingTransportFactory");
        this.propertyData.put("ssl", "com.sap.engine.services.ssl.factory.SSLTransportFactory");
        this.propertyData.put("https", "com.sap.engine.services.ssl.factory.SSLHttpTransportFactory");
        this.propertyData.put("SAPRouter", "com.sap.engine.services.rmi_p4.SAPTransportFactory");
        this.propertyData.put("saprouter", "com.sap.engine.services.rmi_p4.SAPTransportFactory");
    }

    private String getFactoryClassName(String queue) {
        String factoryClassName = (String)this.propertyData.get(queue);
        if (factoryClassName == null) {
            factoryClassName = (String)this.propertyData.get(queue.toLowerCase());
        }
        if (factoryClassName == null) {
            throw new RuntimeException("Can't find transport factory for key " + queue);
        }
        return factoryClassName;
    }

    private TransportFactory getFactory(String queue) throws Exception {
        if (queue.endsWith("/")) {
            queue = queue.substring(0, queue.length() - 1);
        }
        queue.trim();
        if (queue.length() > 0) {
            int lastIndex = queue.lastIndexOf(47);
            String current = null;
            if (lastIndex == -1) {
                current = queue;
                queue = "";
            } else {
                current = queue.substring(lastIndex + 1);
                queue = queue.substring(0, lastIndex);
            }
            Class<?> cl = Class.forName(this.getFactoryClassName(current));
            TransportFactory result = (TransportFactory)cl.newInstance();
            result.setFactory(this.getFactory(queue));
            return result;
        }
        Class<?> cl = Class.forName("com.sap.engine.transport.DefaultTransportFactory");
        TransportFactory result = (TransportFactory)cl.newInstance();
        return result;
    }

    public ServerSocket getRealServerSocket(int port, String queue) throws IOException {
        try {
            return this.getFactory(queue).getServerSocket(port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get ServerSocket");
        }
    }

    public ServerSocket getServerSocket(int port, String queue, String type) throws IOException {
        try {
            Class<?> cl = Class.forName(this.getFactoryClassName(type));
            TransportFactory factory = (TransportFactory)cl.newInstance();
            factory.setFactory(this.getFactory(queue));
            return factory.getServerSocket(port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get ServerSocket");
        }
    }

    public ServerSocket getRealServerSocket(int port, int acceptSize, String queue) throws IOException {
        try {
            return this.getFactory(queue).getServerSocket(port, acceptSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get ServerSocket");
        }
    }

    public ServerSocket getServerSocket(int port, int acceptSize, String queue, String type) throws IOException {
        try {
            Class<?> cl = Class.forName(this.getFactoryClassName(type));
            TransportFactory factory = (TransportFactory)cl.newInstance();
            factory.setFactory(this.getFactory(queue));
            return factory.getServerSocket(port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get ServerSocket");
        }
    }

    public Socket getRealSocket(String host, int port, String queue) throws IOException {
        try {
            return this.getFactory(queue).getSocket(host, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get Socket");
        }
    }

    public Socket getSocket(String host, int port, String queue, String type) throws IOException {
        try {
            Class<?> cl = Class.forName(this.getFactoryClassName(type));
            TransportFactory factory = (TransportFactory)cl.newInstance();
            factory.setFactory(this.getFactory(queue));
            return factory.getSocket(host, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get Socket");
        }
    }

    public Socket getRealSocket(String host, int port, String queue, Properties props) throws IOException {
        try {
            return this.getFactory(queue).getSocket(host, port, props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get Socket");
        }
    }

    public Socket getSocket(String host, int port, String queue, String type, Properties props) throws IOException {
        try {
            Class<?> cl = Class.forName(this.getFactoryClassName(type));
            TransportFactory factory = (TransportFactory)cl.newInstance();
            factory.setFactory(this.getFactory(queue));
            return factory.getSocket(host, port, props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't get Socket");
        }
    }
}

