/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.utils;

import com.sap.engine.tools.refsviewer.core.container.ComponentFactory;
import com.sap.engine.tools.refsviewer.core.container.PersistancePropertyFactory;
import com.sap.engine.tools.refsviewer.core.container.PersistenceContainerInterface;
import com.sap.engine.tools.refsviewer.core.container.offline.PersistentContainerOffline;
import com.sap.engine.tools.refsviewer.gui.ComponentTreeNode;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class JarsFactory {
    /*
     * Loose catch block
     */
    public static Hashtable listJar(String fullPath) throws Exception {
        Hashtable result;
        block12: {
            result = new Hashtable();
            ZipInputStream jis = null;
            jis = new JarInputStream(new FileInputStream(fullPath));
            JarEntry je = null;
            String strName = null;
            String packageName = null;
            String className = null;
            int index = -1;
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                strName = je.getName();
                if (strName.toLowerCase().endsWith(".class") && (index = strName.lastIndexOf(47)) != -1) {
                    packageName = strName.substring(0, index).replace('/', '.');
                    className = strName.substring(index + 1);
                    if (result.containsKey(packageName)) {
                        ArrayList al = (ArrayList)result.get(packageName);
                        result.remove(packageName);
                        al.add(className);
                        result.put(packageName, al);
                    } else {
                        ArrayList<String> arrListTmp = new ArrayList<String>();
                        arrListTmp.add(className);
                        result.put(packageName, arrListTmp);
                    }
                }
                jis.closeEntry();
            }
            Object var10_10 = null;
            try {
                jis.close();
            }
            catch (IOException _) {
                _.printStackTrace();
            }
            break block12;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var10_11 = null;
                    try {
                        jis.close();
                    }
                    catch (IOException _) {
                        _.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    jis.close();
                }
                catch (IOException _) {
                    _.printStackTrace();
                }
                throw throwable;
            }
        }
        return result;
    }

    public static void dumpHashTable(Hashtable hashTable) {
        Enumeration keys = hashTable.keys();
        String currKey = null;
        while (keys.hasMoreElements()) {
            currKey = (String)keys.nextElement();
            System.out.println("Package : " + currKey);
            ArrayList al = (ArrayList)hashTable.get(currKey);
            int i = 0;
            while (i < al.size()) {
                System.out.println("\tClass : " + al.get(i));
                ++i;
            }
        }
    }

    public static ComponentTreeNode[] generateComponentTreeNodes(Object[] elements) {
        String fullPath = JarsFactory.getFullPath(elements);
        ComponentTreeNode[] ctnArr = null;
        ArrayList<ComponentTreeNode> alNodes = new ArrayList<ComponentTreeNode>();
        Hashtable hashTable = null;
        try {
            hashTable = JarsFactory.listJar(fullPath);
            Enumeration keys = hashTable.keys();
            String currKey = null;
            while (keys.hasMoreElements()) {
                currKey = (String)keys.nextElement();
                ComponentTreeNode ctnPackage = new ComponentTreeNode(currKey);
                ArrayList al = (ArrayList)hashTable.get(currKey);
                int i = 0;
                while (i < al.size()) {
                    ComponentTreeNode ctnClass = new ComponentTreeNode(al.get(i));
                    ctnPackage.add(ctnClass);
                    ++i;
                }
                alNodes.add(ctnPackage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ctnArr = new ComponentTreeNode[alNodes.size()];
        int i = 0;
        while (i < ctnArr.length) {
            ctnArr[i] = (ComponentTreeNode)alNodes.get(i);
            ++i;
        }
        return ctnArr;
    }

    public static String getFullPath(Object[] selectedPath) {
        String result = "";
        result = JarsFactory.getPathToComponent(selectedPath);
        return result;
    }

    public static String getPathToComponent(Object[] selectedPath) {
        String clusterType = selectedPath[1].toString();
        String componentName = selectedPath[2].toString();
        String wrapperName = selectedPath[3].toString();
        String jarName = selectedPath[4].toString();
        boolean fileMode = PersistentContainerOffline.fileMode;
        if (fileMode) {
            if (clusterType.equalsIgnoreCase("Dispatcher")) {
                if (componentName.equalsIgnoreCase("Interfaces")) {
                    return PersistancePropertyFactory.getDispatcherBinDirectoryInterfaces() + "/" + jarName;
                }
                if (componentName.equalsIgnoreCase("Libraries")) {
                    if (wrapperName.equals("core_lib")) {
                        return PersistancePropertyFactory.getBinDispatcherDirectory() + "/" + wrapperName + "/" + jarName;
                    }
                    return PersistancePropertyFactory.getDispatcherBinDirectoryLibraries() + "/" + jarName;
                }
                if (componentName.equalsIgnoreCase("Services")) {
                    return PersistancePropertyFactory.getDispatcherBinDirectoryServices() + "/" + jarName;
                }
                if (componentName.equalsIgnoreCase("Cores")) {
                    return PersistancePropertyFactory.getBinDispatcherDirectory() + "/" + wrapperName + "/" + jarName;
                }
            } else {
                if (componentName.equalsIgnoreCase("Interfaces")) {
                    return PersistancePropertyFactory.getServerBinDirectoryInterfaces() + "/" + jarName;
                }
                if (componentName.equalsIgnoreCase("Libraries")) {
                    if (wrapperName.equals("core_lib")) {
                        return PersistancePropertyFactory.getBinServerDirectory() + "/" + wrapperName + "/" + jarName;
                    }
                    return PersistancePropertyFactory.getServerBinDirectoryLibraries() + "/" + jarName;
                }
                if (componentName.equalsIgnoreCase("Services")) {
                    return PersistancePropertyFactory.getServerBinDirectoryServices() + "/" + jarName;
                }
                if (componentName.equalsIgnoreCase("Cores")) {
                    return PersistancePropertyFactory.getBinServerDirectory() + "/" + wrapperName + "/" + jarName;
                }
            }
        } else {
            PersistenceContainerInterface pci = null;
            pci = clusterType.equalsIgnoreCase("Dispatcher") ? ComponentFactory.persistentContainerDispatcher : ComponentFactory.persistentContainerServer;
            if (componentName.equalsIgnoreCase("Interfaces")) {
                pci.getFileFromDB("cluster_data/" + clusterType.toLowerCase() + "/bin/interfaces/" + wrapperName, jarName, PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/interfaces/" + wrapperName, jarName);
                return PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/interfaces/" + wrapperName + "/" + jarName;
            }
            if (componentName.equalsIgnoreCase("Libraries")) {
                if (wrapperName.equals("core_lib")) {
                    pci.getFileFromDB("cluster_data/" + clusterType.toLowerCase() + "/bin/" + "core_lib", jarName, PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/" + "core_lib", jarName);
                    return PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/" + "core_lib" + "/" + jarName;
                }
                pci.getFileFromDB("cluster_data/" + clusterType.toLowerCase() + "/bin/ext/" + wrapperName, jarName, PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/ext/" + wrapperName, jarName);
                return PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/ext/" + wrapperName + "/" + jarName;
            }
            if (componentName.equalsIgnoreCase("Services")) {
                pci.getFileFromDB("cluster_data/" + clusterType.toLowerCase() + "/bin/services/" + wrapperName, jarName, PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/services/" + wrapperName, jarName);
                return PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/services/" + wrapperName + "/" + jarName;
            }
            if (componentName.equalsIgnoreCase("Cores")) {
                pci.getFileFromDB("cluster_data/" + clusterType.toLowerCase() + "/bin/" + wrapperName.toLowerCase(), jarName, PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/" + wrapperName.toLowerCase(), jarName);
                return PersistancePropertyFactory.tempDirectory + "/" + clusterType + "/" + wrapperName.toLowerCase() + "/" + jarName;
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        JarsFactory.listJar(args[0]);
    }
}

