/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.core.container.ApplicationMode;
import com.sap.engine.tools.refsviewer.core.container.ComponentFactory;
import com.sap.engine.tools.refsviewer.core.container.ComponentWrapper;
import com.sap.engine.tools.refsviewer.gui.ClassloaderMonitorFrame;
import com.sap.engine.tools.refsviewer.gui.ComponentTreeNode;
import com.sap.engine.tools.refsviewer.gui.ComponentTreeRenderer;
import com.sap.engine.tools.refsviewer.utils.Decompiler;
import com.sap.engine.tools.refsviewer.utils.JarsFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ComponentTreePanel
extends JPanel
implements TreeSelectionListener {
    private Hashtable interfacesServerHashtable = null;
    private Hashtable librariesServerHashtable = null;
    private Hashtable servicesServerHashtable = null;
    private Hashtable coresServerHashtable = null;
    private Hashtable applicationsServerHashtable = null;
    private Hashtable interfacesDispatcherHashtable = null;
    private Hashtable librariesDispatcherHashtable = null;
    private Hashtable servicesDispatcherHashtable = null;
    private Hashtable coresDispatcherHashtable = null;
    protected static JTree tree = null;
    protected static DefaultTreeModel model = null;
    private Object[] elements = null;
    private Decompiler decompiler = new Decompiler();

    public ComponentTreePanel(ApplicationMode am) {
        super(new BorderLayout());
        ComponentTreeNode component = new ComponentTreeNode("Cluster");
        try {
            ComponentFactory.initInstance(am);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ComponentTreeNode componentDispatcher = new ComponentTreeNode("Dispatcher");
        component.add(componentDispatcher);
        ComponentTreeNode componentServer = new ComponentTreeNode("Server");
        component.add(componentServer);
        this.interfacesServerHashtable = ComponentFactory.getServerHashInterfaces();
        ComponentWrapper[] serverInterfacesCWArr = ComponentFactory.getComponentWrapperArr(this.interfacesServerHashtable);
        ComponentTreeNode serverInterfaces = new ComponentTreeNode("Interfaces");
        ComponentTreeNode tmpInterface = null;
        ComponentTreeNode tmpJar = null;
        int i = 0;
        while (i < serverInterfacesCWArr.length) {
            tmpInterface = new ComponentTreeNode(serverInterfacesCWArr[i].getComponentName(), serverInterfacesCWArr[i]);
            String[] strArrJars = serverInterfacesCWArr[i].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpInterface.add(tmpJar);
                ++j;
            }
            serverInterfaces.add(tmpInterface);
            ++i;
        }
        componentServer.add(serverInterfaces);
        this.librariesServerHashtable = ComponentFactory.getServerHashLibraries();
        ComponentWrapper[] serverLibrariesCWArr = ComponentFactory.getComponentWrapperArr(this.librariesServerHashtable);
        ComponentTreeNode serverLibraries = new ComponentTreeNode("Libraries");
        ComponentTreeNode tmpLibraries = null;
        int i2 = 0;
        while (i2 < serverLibrariesCWArr.length) {
            tmpLibraries = new ComponentTreeNode(serverLibrariesCWArr[i2].getComponentName(), serverLibrariesCWArr[i2]);
            String[] strArrJars = serverLibrariesCWArr[i2].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpLibraries.add(tmpJar);
                ++j;
            }
            serverLibraries.add(tmpLibraries);
            ++i2;
        }
        componentServer.add(serverLibraries);
        this.servicesServerHashtable = ComponentFactory.getServerHashServices();
        ComponentWrapper[] serverServicesCWArr = ComponentFactory.getComponentWrapperArr(this.servicesServerHashtable);
        ComponentTreeNode serverServices = new ComponentTreeNode("Services");
        ComponentTreeNode tmpServices = null;
        int i3 = 0;
        while (i3 < serverServicesCWArr.length) {
            tmpServices = new ComponentTreeNode(serverServicesCWArr[i3].getComponentName(), serverServicesCWArr[i3]);
            String[] strArrJars = serverServicesCWArr[i3].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpServices.add(tmpJar);
                ++j;
            }
            serverServices.add(tmpServices);
            ++i3;
        }
        componentServer.add(serverServices);
        this.coresServerHashtable = ComponentFactory.getServerHashCores();
        ComponentWrapper[] serverCoresCWArr = ComponentFactory.getComponentWrapperArr(this.coresServerHashtable);
        ComponentTreeNode serverCores = new ComponentTreeNode("Cores");
        ComponentTreeNode tmpCore = null;
        int i4 = 0;
        while (i4 < serverCoresCWArr.length) {
            tmpCore = new ComponentTreeNode(serverCoresCWArr[i4].getComponentName(), serverCoresCWArr[i4]);
            String[] strArrJars = serverCoresCWArr[i4].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpCore.add(tmpJar);
                ++j;
            }
            serverCores.add(tmpCore);
            ++i4;
        }
        componentServer.add(serverCores);
        this.applicationsServerHashtable = ComponentFactory.getServerHashApplications();
        ComponentWrapper[] serverApplicationsCWArr = ComponentFactory.getComponentWrapperArr(this.applicationsServerHashtable);
        ComponentTreeNode serverApplications = new ComponentTreeNode("Applications");
        ComponentTreeNode tmpApplications = null;
        int i5 = 0;
        while (i5 < serverApplicationsCWArr.length) {
            tmpApplications = new ComponentTreeNode(serverApplicationsCWArr[i5].getComponentName(), serverApplicationsCWArr[i5]);
            serverApplications.add(tmpApplications);
            ++i5;
        }
        componentServer.add(serverApplications);
        this.interfacesDispatcherHashtable = ComponentFactory.getDispatcherHashInterfaces();
        ComponentWrapper[] dispInterfacesCWArr = ComponentFactory.getComponentWrapperArr(this.interfacesDispatcherHashtable);
        ComponentTreeNode dispInterfaces = new ComponentTreeNode("Interfaces");
        int i6 = 0;
        while (i6 < dispInterfacesCWArr.length) {
            tmpInterface = new ComponentTreeNode(dispInterfacesCWArr[i6].getComponentName(), dispInterfacesCWArr[i6]);
            String[] strArrJars = dispInterfacesCWArr[i6].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpInterface.add(tmpJar);
                ++j;
            }
            dispInterfaces.add(tmpInterface);
            ++i6;
        }
        componentDispatcher.add(dispInterfaces);
        this.librariesDispatcherHashtable = ComponentFactory.getDispatcherHashLibraries();
        ComponentWrapper[] dispLibrariesCWArr = ComponentFactory.getComponentWrapperArr(this.librariesDispatcherHashtable);
        ComponentTreeNode dispLibraries = new ComponentTreeNode("Libraries");
        int i7 = 0;
        while (i7 < dispLibrariesCWArr.length) {
            tmpLibraries = new ComponentTreeNode(dispLibrariesCWArr[i7].getComponentName(), dispLibrariesCWArr[i7]);
            String[] strArrJars = dispLibrariesCWArr[i7].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpLibraries.add(tmpJar);
                ++j;
            }
            dispLibraries.add(tmpLibraries);
            ++i7;
        }
        componentDispatcher.add(dispLibraries);
        this.servicesDispatcherHashtable = ComponentFactory.getDispatcherHashServices();
        ComponentWrapper[] dispServicesCWArr = ComponentFactory.getComponentWrapperArr(this.servicesDispatcherHashtable);
        ComponentTreeNode dispServices = new ComponentTreeNode("Services");
        int i8 = 0;
        while (i8 < dispServicesCWArr.length) {
            tmpServices = new ComponentTreeNode(dispServicesCWArr[i8].getComponentName(), dispServicesCWArr[i8]);
            String[] strArrJars = dispServicesCWArr[i8].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpServices.add(tmpJar);
                ++j;
            }
            dispServices.add(tmpServices);
            ++i8;
        }
        componentDispatcher.add(dispServices);
        this.coresDispatcherHashtable = ComponentFactory.getDispatcherHashCores();
        ComponentWrapper[] dispCoresCWArr = ComponentFactory.getComponentWrapperArr(this.coresDispatcherHashtable);
        ComponentTreeNode dispCores = new ComponentTreeNode("Cores");
        int i9 = 0;
        while (i9 < dispCoresCWArr.length) {
            tmpCore = new ComponentTreeNode(dispCoresCWArr[i9].getComponentName(), dispCoresCWArr[i9]);
            String[] strArrJars = dispCoresCWArr[i9].getJars();
            int j = 0;
            while (j < strArrJars.length) {
                tmpJar = new ComponentTreeNode(strArrJars[j]);
                tmpCore.add(tmpJar);
                ++j;
            }
            dispCores.add(tmpCore);
            ++i9;
        }
        componentDispatcher.add(dispCores);
        model = new DefaultTreeModel(component);
        tree = new JTree(model);
        tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.addTreeSelectionListener(this);
        tree.setCellRenderer(new ComponentTreeRenderer());
        JScrollPane sp = new JScrollPane(tree);
        this.add((Component)sp, "Center");
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getPath();
        String strSelectedItem = path.getLastPathComponent().toString();
        this.elements = path.getPath();
        int dotIndex = -1;
        dotIndex = strSelectedItem.indexOf(46);
        if (dotIndex != -1 && strSelectedItem.substring(dotIndex).equals(".jar")) {
            DefaultMutableTreeNode dmtnParent = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            if (dmtnParent != null && dmtnParent.getChildCount() == 0) {
                ComponentTreeNode[] childs = JarsFactory.generateComponentTreeNodes(this.elements);
                int loop = 0;
                while (loop < childs.length) {
                    model.insertNodeInto(childs[loop], dmtnParent, loop);
                    ++loop;
                }
            }
            return;
        }
        if (strSelectedItem.endsWith(".class")) {
            return;
        }
        if (this.elements.length == 4) {
            if (this.elements[1].toString().equalsIgnoreCase("Server")) {
                try {
                    if (this.elements[2].toString().equalsIgnoreCase("Interfaces")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getServerComponentWrapperByName(this.elements[3].toString(), "Interfaces"), "Server");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Libraries")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getServerComponentWrapperByName(this.elements[3].toString(), "Libraries"), "Server");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Services")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getServerComponentWrapperByName(this.elements[3].toString(), "Services"), "Server");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Cores")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getServerComponentWrapperByName(this.elements[3].toString(), "Cores"), "Server");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Applications")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getServerComponentWrapperByName(this.elements[3].toString(), "Applications"), "Server");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (this.elements[2].toString().equalsIgnoreCase("Interfaces")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getDispatcherComponentWrapperByName(this.elements[3].toString(), "Interfaces"), "Dispatcher");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Libraries")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getDispatcherComponentWrapperByName(this.elements[3].toString(), "Libraries"), "Dispatcher");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Services")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getDispatcherComponentWrapperByName(this.elements[3].toString(), "Services"), "Dispatcher");
                    } else if (this.elements[2].toString().equalsIgnoreCase("Cores")) {
                        ClassloaderMonitorFrame.centralPanel.initComponents(ComponentFactory.getDispatcherComponentWrapperByName(this.elements[3].toString(), "Cores"), "Dispatcher");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

