/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.core.ClassloaderMonitorFrameManager;
import com.sap.engine.tools.refsviewer.core.container.ApplicationMode;
import com.sap.engine.tools.refsviewer.gui.CFrame;
import com.sap.engine.tools.refsviewer.gui.ClassLoaderPaneLogical;
import com.sap.engine.tools.refsviewer.gui.ClassloaderMonitorConfigurator;
import com.sap.engine.tools.refsviewer.gui.ComponentTreePanel;
import com.sap.engine.tools.refsviewer.gui.MainMenuBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ClassloaderMonitorFrame
extends CFrame {
    protected ClassloaderMonitorFrameManager manager = null;
    protected MainMenuBar menuBar = null;
    protected JScrollPane leftScrollPane = null;
    protected JScrollPane centerScrollPane = null;
    protected JScrollPane rightScrollPane = null;
    protected static ClassLoaderPaneLogical centralPanel = null;
    protected JPanel leftPanel = null;
    protected JPanel rightPanel = new JPanel();
    protected JSplitPane leftSplitPane = null;
    protected JSplitPane rightSplitPane = null;
    protected ClassloaderMonitorConfigurator config = ClassloaderMonitorConfigurator.getInstance();

    public ClassloaderMonitorFrame() {
        super("SAP J2EE Classloader Monitor");
        this.initView();
    }

    private void initView() {
        this.manager = new ClassloaderMonitorFrameManager(this);
        this.menuBar = new MainMenuBar(this.manager);
        this.addWindowListener(this);
        ((Frame)this).setIconImage(this.loadImage("images/sap_logo22x22_new.gif"));
        this.initPosition();
        this.menuBar.add(this.getLookAndFeelMenu());
        this.setJMenuBar(this.menuBar);
    }

    public void drawClassloadersPanel(ApplicationMode am) {
        if (this.leftSplitPane != null) {
            this.getContentPane().remove(this.leftSplitPane);
        }
        this.leftPanel = new ComponentTreePanel(am);
        centralPanel = new ClassLoaderPaneLogical();
        centralPanel.setLayout(new BorderLayout());
        this.leftScrollPane = new JScrollPane(this.leftPanel);
        this.centerScrollPane = new JScrollPane(centralPanel);
        this.rightScrollPane = new JScrollPane(this.rightPanel);
        this.rightSplitPane = new JSplitPane(1, this.centerScrollPane, this.rightScrollPane);
        this.rightSplitPane.setOneTouchExpandable(true);
        this.leftSplitPane = new JSplitPane(1, this.leftPanel, this.centerScrollPane);
        this.leftSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)this.leftSplitPane, "Center");
        this.pack();
        this.setFrameLocation();
        ((Component)this).setVisible(true);
    }

    protected void initPosition() {
        int width = this.config.getInt("INITIAL_WIDTH");
        int height = this.config.getInt("INITIAL_HEIGHT");
        int locateX = this.config.getInt("POS_X");
        int locateY = this.config.getInt("POS_Y");
        ((Component)this).setSize(width, height);
        ((Component)this).setLocation(locateX, locateY);
    }

    public static void main(String[] args) {
        ClassloaderMonitorFrame cmf = new ClassloaderMonitorFrame();
        ((Component)cmf).setVisible(true);
    }

    public void windowClosing(WindowEvent e) {
        this.manager.exitAction();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void stateChanged(int state) {
    }

    public void closePerformed() {
        super.closingPerformed();
        System.exit(0);
    }
}

