/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import com.sap.engine.tools.refsviewer.gui.CLArrowView;
import com.sap.engine.tools.refsviewer.gui.ComponentView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class ClassLoaderPaneView
extends JPanel
implements MouseListener {
    public static final int UP = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int DOWN = 4;
    protected static Color[] arrowColor = new Color[4];
    public static int maxRows = 50;
    private JPanel upPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private GridBagLayout layout = new GridBagLayout();
    public static Color componentColor = Color.black;
    public static Color selectedColor = Color.red;
    public static Color referenceColor = Color.red;
    public static Color errorColor = Color.cyan;
    private ComponentView selComponent = null;
    protected Vector upComponents = new Vector();
    protected Vector leftComponents = new Vector();
    protected Vector rightComponents = new Vector();
    protected Vector centerComponents = new Vector();

    public ClassLoaderPaneView() {
        this.initView();
    }

    protected void initView() {
        this.setBackground(Color.white);
        this.setLayout(this.layout);
        this.centerPanel.setLayout(new GridBagLayout());
        this.centerPanel.setBackground(this.getBackground());
        this.upPanel.setLayout(new GridBagLayout());
        this.upPanel.setBackground(this.getBackground());
        this.addMouseListener(this);
        this.add((Component)this.upPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 20, 15, 20), 0, 0));
        this.add((Component)this.centerPanel, new GridBagConstraints(1, 1, 1, maxRows, 0.0, 0.0, 10, 0, new Insets(15, 20, 15, 20), 0, 0));
        ClassLoaderPaneView.arrowColor[1] = new Color(0, 130, 50);
        ClassLoaderPaneView.arrowColor[0] = new Color(100, 50, 50);
        ClassLoaderPaneView.arrowColor[2] = Color.cyan;
        ClassLoaderPaneView.arrowColor[3] = new Color(0, 0, 150);
        this.add(this.paintLegend(), new GridBagConstraints(2, maxRows, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void removeAll() {
        super.removeAll();
        this.upPanel.removeAll();
        this.centerPanel.removeAll();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.centerPanel.setLayout(new GridBagLayout());
        this.upPanel.setLayout(new GridBagLayout());
        this.add((Component)this.upPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 20, 15, 20), 0, 0));
        this.add((Component)this.centerPanel, new GridBagConstraints(1, 1, 1, maxRows, 0.0, 0.0, 10, 0, new Insets(15, 20, 15, 20), 0, 0));
        this.add(this.paintLegend(), new GridBagConstraints(2, maxRows, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.upComponents.clear();
        this.leftComponents.clear();
        this.rightComponents.clear();
        this.centerComponents.clear();
        this.updateUI();
        this.repaint();
        this.validate();
    }

    public void addComponent(ComponentView comp, int position) {
        if (position == 0) {
            this.upPanel.add((Component)comp, new GridBagConstraints(0, this.upComponents.size(), 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 15, 10, 15), 0, 0));
            this.upComponents.add(comp);
            this.upPanel.updateUI();
        } else if (position == 2) {
            this.add((Component)comp, new GridBagConstraints(0, 1 + this.leftComponents.size(), 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 15, 10, 15), 0, 0));
            this.leftComponents.add(comp);
        } else if (position == 3) {
            this.add((Component)comp, new GridBagConstraints(2, 1 + this.rightComponents.size(), 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 15, 10, 15), 0, 0));
            this.rightComponents.add(comp);
        } else if (position == 1) {
            this.centerPanel.add((Component)comp, new GridBagConstraints(0, this.centerComponents.size(), 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 15, 10, 15), 0, 0));
            this.centerComponents.add(comp);
            this.centerPanel.updateUI();
        }
        comp.setBackground(this.getBackground());
        if (comp.colorNode == null) {
            comp.setForeground(componentColor);
        } else {
            comp.setForeground(comp.colorNode);
        }
        this.setPreferredSize(this.layout.preferredLayoutSize(this));
        this.updateUI();
    }

    public Color getComponentColor() {
        return componentColor;
    }

    public void setComponentColor(Color componentColor) {
        ClassLoaderPaneView.componentColor = componentColor;
    }

    public Color getSelectedColor() {
        return selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        ClassLoaderPaneView.selectedColor = selectedColor;
    }

    public Color getReferenceColor() {
        return referenceColor;
    }

    public void setReferenceColor(Color referenceColor) {
        ClassLoaderPaneView.referenceColor = referenceColor;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(componentColor);
        Rectangle rec = this.centerPanel.getBounds();
        g.drawRoundRect((int)rec.getX(), (int)rec.getY(), (int)rec.getWidth(), (int)rec.getHeight(), 5, 5);
        this.paintArrows(g);
    }

    protected void paintArrows(Graphics g) {
        ComponentView to = null;
        int i = 0;
        while (i < this.upComponents.size() - 1) {
            ComponentView comp = (ComponentView)this.upComponents.elementAt(i);
            to = (ComponentView)this.upComponents.elementAt(i + 1);
            CLArrowView arrow = new CLArrowView(comp.getPoint(this, 4), to.getPoint(this, 0), arrowColor[3]);
            arrow.paint(g);
            ++i;
        }
        if (to != null && to.isPaintParentOfCentral) {
            CLArrowView arrow = new CLArrowView(to.getPoint(this, 4), this.getCentralComponentPoint(0), arrowColor[3]);
            arrow.paint(g);
        }
        Point centerPoint = this.getCentralComponentPoint(2);
        int i2 = 0;
        while (i2 < this.leftComponents.size()) {
            ComponentView comp = (ComponentView)this.leftComponents.elementAt(i2);
            CLArrowView arrow = new CLArrowView(centerPoint, comp.getPoint(this, 3), arrowColor[this.getReferenceType(comp)]);
            arrow.paint(g);
            ++i2;
        }
        centerPoint = this.getCentralComponentPoint(3);
        int i3 = 0;
        while (i3 < this.rightComponents.size()) {
            ComponentView comp = (ComponentView)this.rightComponents.elementAt(i3);
            CLArrowView arrow = new CLArrowView(comp.getPoint(this, 2), centerPoint, arrowColor[this.getReferenceType(comp)]);
            arrow.paint(g);
            ++i3;
        }
    }

    private Point getCentralComponentPoint(int position) {
        Point point = null;
        Rectangle rec = this.centerPanel.getBounds();
        if (position == 0) {
            point = new Point((int)(rec.getX() + rec.getWidth() / 2.0), (int)(rec.getY() - 1.0));
        } else if (position == 2) {
            point = new Point((int)(rec.getX() - 1.0), (int)(rec.getY() + rec.getHeight() / 2.0));
        } else if (position == 3) {
            point = new Point((int)(rec.getX() + rec.getWidth()), (int)(rec.getY() + rec.getHeight() / 2.0));
        } else if (position == 4) {
            point = new Point((int)(rec.getX() + rec.getWidth() / 2.0), (int)(rec.getY() + rec.getHeight()));
        }
        return point;
    }

    public void setSelectedComponent(ComponentView component) {
        if (this.selComponent != null) {
            this.selComponent.setForeground(componentColor);
        }
        component.setForeground(selectedColor);
        this.selComponent = component;
    }

    public void clearSelection() {
        if (this.selComponent != null) {
            this.selComponent.setForeground(componentColor);
            this.selComponent = null;
        }
    }

    protected Component paintLegend() {
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new GridBagLayout());
        legendPanel.setBackground(this.getBackground());
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), "Legend");
        border.setTitleColor(Color.black);
        legendPanel.setBorder(border);
        JLabel hardReference = new JLabel("Hard reference");
        JLabel softReference = new JLabel("Soft reference");
        JLabel notifyReference = new JLabel("Notify reference");
        JLabel parentReference = new JLabel("Parent reference");
        hardReference.setForeground(arrowColor[0]);
        softReference.setForeground(arrowColor[1]);
        notifyReference.setForeground(arrowColor[2]);
        parentReference.setForeground(arrowColor[3]);
        legendPanel.add((Component)hardReference, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 5, 1, 5), 0, 0));
        legendPanel.add((Component)softReference, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 5, 1, 5), 0, 0));
        legendPanel.add((Component)notifyReference, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 5, 1, 5), 0, 0));
        legendPanel.add((Component)parentReference, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 5, 1, 5), 0, 0));
        return legendPanel;
    }

    protected abstract int getReferenceType(ComponentView var1);

    public abstract void mouseExited(MouseEvent var1);

    public abstract void mouseEntered(MouseEvent var1);

    public abstract void mouseReleased(MouseEvent var1);

    public abstract void mousePressed(MouseEvent var1);

    public abstract void mouseClicked(MouseEvent var1);
}

