/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CFrame
extends JFrame
implements ComponentListener,
WindowListener,
ActionListener {
    public static final String LF_PREFIX = "look.and.feel.";
    public static final String LF_DEFAULT = "default.look.and.feel";
    public static final String FRAME_WIDTH = "frame.width";
    public static final String FRAME_HEIGHT = "frame.height";
    public static final String POSITION_X = "position.x";
    public static final String POSITION_Y = "position.y";
    public static int INITIAL_WIDTH = 800;
    public static int INITIAL_HEIGHT = 600;
    public static String propertyFileName = "refsviewer_frameCfg.properties";
    public static String lookAndFeelMenuName = "Look & Feel";
    private JMenu lookAndFeelMenu;
    private Properties config;

    public CFrame() {
        this.initCfg();
    }

    public CFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initCfg();
    }

    public CFrame(String title) {
        super(title);
        this.initCfg();
    }

    public CFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initCfg();
    }

    protected void initCfg() {
        this.addComponentListener(this);
        this.addWindowListener(this);
        this.config = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propertyFileName);
            this.config.load(fis);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            this.loadDefault();
        }
        this.setFrameLocation();
        this.changeLookAndFeel(LF_PREFIX + this.config.getProperty(LF_DEFAULT));
    }

    private void loadDefault() {
        int width = INITIAL_WIDTH;
        int height = INITIAL_HEIGHT;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locatX = screenSize.width / 2 - INITIAL_WIDTH / 2;
        int locatY = screenSize.height / 2 - INITIAL_HEIGHT / 2;
        ((Hashtable)this.config).put(POSITION_X, "" + locatX);
        ((Hashtable)this.config).put(POSITION_Y, "" + locatY);
        ((Hashtable)this.config).put(FRAME_WIDTH, "" + width);
        ((Hashtable)this.config).put(FRAME_HEIGHT, "" + height);
        UIManager.LookAndFeelInfo[] lfInfo = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lfInfo.length) {
            ((Hashtable)this.config).put(LF_PREFIX + lfInfo[i].getName(), lfInfo[i].getClassName());
            ++i;
        }
        ((Hashtable)this.config).put(LF_DEFAULT, LF_PREFIX + UIManager.getLookAndFeel().getName());
        try {
            FileOutputStream fos = new FileOutputStream(propertyFileName);
            this.config.store(fos, "CFrame properties");
            fos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    protected void setFrameLocation() {
        try {
            int width = Integer.parseInt(this.config.getProperty(FRAME_WIDTH));
            int height = Integer.parseInt(this.config.getProperty(FRAME_HEIGHT));
            int locateX = Integer.parseInt(this.config.getProperty(POSITION_X));
            int locateY = Integer.parseInt(this.config.getProperty(POSITION_Y));
            ((Component)this).setSize(width, height);
            ((Component)this).setLocation(locateX, locateY);
        }
        catch (NumberFormatException nfEx) {
            nfEx.printStackTrace();
        }
    }

    private void saveFrameLocation() {
        int locatX = this.getLocation().x;
        int locatY = this.getLocation().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        ((Hashtable)this.config).put(POSITION_X, "" + locatX);
        ((Hashtable)this.config).put(POSITION_Y, "" + locatY);
        ((Hashtable)this.config).put(FRAME_WIDTH, "" + width);
        ((Hashtable)this.config).put(FRAME_HEIGHT, "" + height);
        try {
            FileOutputStream fos = new FileOutputStream(propertyFileName);
            this.config.store(fos, "CFrame properties");
            fos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    protected void closingPerformed() {
        System.exit(0);
    }

    public JMenu getLookAndFeelMenu() {
        if (this.lookAndFeelMenu == null) {
            this.lookAndFeelMenu = new JMenu(lookAndFeelMenuName);
            this.lookAndFeelMenu.setMnemonic('&');
            Enumeration enumeration = ((Hashtable)this.config).keys();
            ButtonGroup group = new ButtonGroup();
            String current = UIManager.getLookAndFeel().getName();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.startsWith(LF_PREFIX)) continue;
                String value = key.substring(LF_PREFIX.length());
                JRadioButtonMenuItem tmpMenu = new JRadioButtonMenuItem(value);
                if (value.equals(current)) {
                    tmpMenu.setSelected(true);
                }
                tmpMenu.setActionCommand(key);
                tmpMenu.addActionListener(this);
                group.add(tmpMenu);
                this.lookAndFeelMenu.add(tmpMenu);
            }
        }
        return this.lookAndFeelMenu;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.startsWith(LF_PREFIX)) {
            this.changeLookAndFeel(cmd);
        }
    }

    private void changeLookAndFeel(String cmd) {
        try {
            String lfClass = this.config.getProperty(cmd);
            UIManager.setLookAndFeel(lfClass);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String current = UIManager.getLookAndFeel().getName();
        JMenu menu = this.getLookAndFeelMenu();
        int i = 0;
        while (i < menu.getItemCount()) {
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)menu.getItem(i);
            if (item.getText().equals(current)) {
                item.setSelected(true);
            }
            ++i;
        }
        ((Hashtable)this.config).put(LF_DEFAULT, current);
        try {
            FileOutputStream fos = new FileOutputStream(propertyFileName);
            this.config.store(fos, "CFrame properties");
            fos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        this.saveFrameLocation();
    }

    public void componentResized(ComponentEvent e) {
        this.saveFrameLocation();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.closingPerformed();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    protected Image loadImage(String name) {
        try {
            URL url = this.getClass().getResource(name);
            return this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void main(String[] args) {
        CFrame frame = new CFrame();
        JMenuBar mainMenuBar = new JMenuBar();
        mainMenuBar.add(frame.getLookAndFeelMenu());
        frame.setJMenuBar(mainMenuBar);
        frame.show();
    }
}

