/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.refsviewer.core.container;

import com.sap.engine.tools.refsviewer.core.container.ContainerConstants;
import com.sap.engine.tools.refsviewer.core.container.Reference;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ComponentWrapper {
    public static final byte STATUS_MISSING = 1;
    public static final byte STATUS_DEPLOYED = 2;
    public static final byte STATUS_RESOLVED = 3;
    public static final byte STATUS_LOADED = 4;
    public static final byte STATUS_ACTIVE = 5;
    public static final byte TYPE_INTERFACE = 100;
    public static final byte TYPE_LIBRARY = 101;
    public static final byte TYPE_SERVICE = 102;
    public static final byte TYPE_CORE = 103;
    public static final byte TYPE_APPLICATION = 104;
    public boolean isWrong = false;
    protected byte currentStatus;
    protected String componentName;
    protected String providerName;
    protected String displayName;
    protected String description;
    protected byte majorVersion;
    protected byte minorVersion;
    protected byte microVersion;
    protected Set referenceSet;
    protected Reference[] references;
    public String[] jars;
    protected Vector referents;
    private Set hardReferers = new HashSet();
    protected int nodeId;

    ComponentWrapper(String componentName, Document provider) {
        this.componentName = componentName;
        this.referents = new Vector();
        if (provider != null) {
            this.init(provider);
        } else {
            this.init();
        }
        this.currentStatus = (byte)2;
        this.references = this.referenceSet != null ? this.referenceSet.toArray(new Reference[this.referenceSet.size()]) : new Reference[]{};
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public byte getMicroVersion() {
        return this.microVersion;
    }

    public Reference[] getReferences() {
        return this.references;
    }

    public String[] getJars() {
        return this.jars;
    }

    public byte getStatus() {
        return this.currentStatus;
    }

    public void setWrong() {
        this.isWrong = true;
    }

    public void setStatus(byte status) {
        this.currentStatus = status;
    }

    void addReferent(ComponentWrapper wrapper) {
        this.referents.add(wrapper);
    }

    Vector getReferents() {
        return this.referents;
    }

    void addHardReferers(ComponentWrapper cw) {
        this.hardReferers.add(cw);
    }

    Set getHardReferers() {
        return this.hardReferers;
    }

    public void setNodeId(int id) {
        this.nodeId = id;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    protected void init() {
        this.majorVersion = (byte)6;
        this.minorVersion = (byte)30;
        this.microVersion = 0;
        this.providerName = "engine.sap.com";
        if (this.componentName.equals("core_lib")) {
            this.displayName = "core_lib";
            this.jars = null;
            this.references = new Reference[0];
        }
    }

    protected void init(Document document) {
        Element baseElement = document.getDocumentElement();
        baseElement.normalize();
        NodeList list = baseElement.getChildNodes();
        Element element = null;
        String tag = null;
        Object value = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("component-name")) {
                    this.componentName = this.getTextValue(element).replace('/', '~');
                } else if (tag.equals("display-name")) {
                    this.displayName = this.getTextValue(element);
                } else if (tag.equals("description")) {
                    this.description = this.getTextValue(element);
                } else if (tag.equals("major-version")) {
                    this.majorVersion = this.getByteValue(this.getTextValue(element));
                } else if (tag.equals("minor-version")) {
                    this.minorVersion = this.getByteValue(this.getTextValue(element));
                } else if (tag.equals("micro-version")) {
                    this.microVersion = this.getByteValue(this.getTextValue(element));
                } else if (tag.equals("provider-name")) {
                    this.providerName = this.getTextValue(element);
                } else if (tag.equals("references")) {
                    this.referenceSet = this.parseReferences(element);
                } else if (tag.equals("jars")) {
                    this.jars = this.parseJars(element);
                }
            }
            ++i;
        }
    }

    protected String getTextValue(Element element) {
        Node node;
        String result = null;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            result = node.getNodeValue();
            result.trim();
            if (result.equals("") || result.equals("null")) {
                result = null;
            }
        }
        return result;
    }

    private byte getByteValue(String number) {
        byte result = 0;
        if (number != null) {
            try {
                result = Byte.parseByte(number);
            }
            catch (NumberFormatException nfException) {
                System.out.println("Error in parsing version field for component " + this.componentName + " number expected! " + number);
            }
        }
        return result;
    }

    private Set parseReferences(Element references) {
        HashSet<Reference> result = new HashSet<Reference>();
        NodeList referenceList = references.getElementsByTagName("reference");
        if (referenceList.getLength() > 0) {
            int i = 0;
            while (i < referenceList.getLength()) {
                Element reference = (Element)referenceList.item(i);
                String name = this.getTextValue(reference);
                String tmp = reference.getAttribute("type");
                byte referentType = tmp.equals("interface") ? (byte)0 : (tmp.equals("library") ? (byte)1 : 2);
                tmp = reference.getAttribute("strength");
                byte type = tmp.equals("notify") ? (byte)2 : (tmp.equals("weak") ? (byte)1 : 0);
                if (name.indexOf(47) == -1) {
                    // empty if block
                }
                result.add(new Reference(name, referentType, type));
                ++i;
            }
        }
        return result;
    }

    private String[] parseJars(Element jars) {
        String[] result = null;
        String defaultJar = jars.getAttribute("default");
        if (defaultJar.equals("true")) {
            result = new String[]{};
        } else {
            NodeList jarList = jars.getElementsByTagName("jar-name");
            result = new String[jarList.getLength()];
            int i = 0;
            while (i < result.length) {
                Element jar = (Element)jarList.item(i);
                result[i] = this.getTextValue(jar);
                ++i;
            }
        }
        return result;
    }

    public abstract String getType();

    public String toString() {
        int i;
        String result = "ComponentName : " + this.componentName + ContainerConstants.NL + "DisplayName : " + this.displayName + ContainerConstants.NL + "Description : " + this.description + ContainerConstants.NL + "ProviderName : " + this.providerName + ContainerConstants.NL;
        if (this.jars != null) {
            result = result + "Jars : " + ContainerConstants.NL;
            i = 0;
            while (i < this.jars.length) {
                result = result + this.jars[i] + ContainerConstants.NL;
                ++i;
            }
        } else {
            result = result + "Jars : is NULL" + ContainerConstants.NL;
        }
        if (this.references != null) {
            result = result + "References :" + ContainerConstants.NL;
            i = 0;
            while (i < this.references.length) {
                result = result + this.references[i] + ContainerConstants.NL;
                ++i;
            }
        } else {
            result = result + "References is NULL" + ContainerConstants.NL;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            ComponentWrapper fromObj = (ComponentWrapper)object;
            if (fromObj.getComponentName().equals(this.getComponentName()) && fromObj.getType().equals(this.getType())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

