/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system.naming.provider;

import com.sap.engine.system.naming.provider.IResolver;
import com.sap.engine.system.naming.provider.InitialContextFactoryBuilderImpl;
import com.sap.engine.system.naming.provider.LogHelper;
import com.sap.engine.system.naming.provider.Manager;
import com.sap.engine.system.naming.provider.ObjectFactoryBuilderImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;

public class ResolverManager
extends Manager {
    private static boolean initialized = false;
    private Hashtable resolvers = new Hashtable();
    private Hashtable icfResolverMapping = new Hashtable();
    private Hashtable ofResolverMapping = new Hashtable();
    private Hashtable sfResolverMapping = new Hashtable();
    private Hashtable urlcfResolverMapping = new Hashtable();
    private LogHelper log = null;

    public static synchronized void init() throws Exception {
        if (!initialized) {
            Manager.instance = new ResolverManager();
            if (!NamingManager.hasInitialContextFactoryBuilder()) {
                NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilderImpl());
                NamingManager.setObjectFactoryBuilder(new ObjectFactoryBuilderImpl());
            }
            initialized = true;
        }
    }

    public void registerResolver(IResolver resolver) throws NamingException {
        if (this.log != null) {
            if (this.log.toLogInfoInLocation()) {
                this.log.logStringInInfo("Resolver: " + resolver + " is going to be registered in the ResolverManager");
            }
            if (this.log.toLogPathInLocation()) {
                this.log.logStringInPath("Before the registration the hashtable of resolvers contains: " + this.resolvers);
            }
        }
        Hashtable hashtable = this.resolvers;
        synchronized (hashtable) {
            if (resolver != null) {
                this.resolvers.put(resolver.getClass().getName(), resolver);
            }
        }
        if (this.log != null && this.log.toLogPathInLocation()) {
            this.log.logStringInPath("After registration the hashtable of resolvers contains: " + this.resolvers);
        }
    }

    public void unregisterResolver(IResolver resolver) throws NamingException {
        if (this.log != null) {
            if (this.log.toLogInfoInLocation()) {
                this.log.logStringInInfo("Resolver: " + resolver + " is going to be unregistered from the ResolverManager");
            }
            if (this.log.toLogPathInLocation()) {
                this.log.logStringInPath("Before the unregistration the hashtable of resolvers contains: " + this.resolvers);
            }
        }
        if (resolver != null) {
            Object r = null;
            Hashtable hashtable = this.resolvers;
            synchronized (hashtable) {
                r = this.resolvers.remove(resolver.getClass().getName());
            }
            if (r != null) {
                Enumeration keys = null;
                Object key = null;
                Object value = null;
                Hashtable hashtable2 = this.icfResolverMapping;
                synchronized (hashtable2) {
                    keys = this.icfResolverMapping.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        value = this.icfResolverMapping.get(key);
                        if (!value.equals(resolver.getClass().getName())) continue;
                        this.icfResolverMapping.remove(key);
                    }
                }
                Hashtable hashtable3 = this.ofResolverMapping;
                synchronized (hashtable3) {
                    keys = this.ofResolverMapping.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        value = this.ofResolverMapping.get(key);
                        if (!value.equals(resolver.getClass().getName())) continue;
                        this.ofResolverMapping.remove(key);
                    }
                }
                Hashtable hashtable4 = this.urlcfResolverMapping;
                synchronized (hashtable4) {
                    keys = this.urlcfResolverMapping.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        value = this.urlcfResolverMapping.get(key);
                        if (!value.equals(resolver.getClass().getName())) continue;
                        this.urlcfResolverMapping.remove(key);
                    }
                }
                Hashtable hashtable5 = this.sfResolverMapping;
                synchronized (hashtable5) {
                    keys = this.sfResolverMapping.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        value = this.sfResolverMapping.get(key);
                        if (!value.equals(resolver.getClass().getName())) continue;
                        this.sfResolverMapping.remove(key);
                    }
                }
            }
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("After unregistration the hashtable of resolvers contains: " + this.resolvers);
            }
        }
    }

    public Object getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        String efs = (String)environment.get("com.sap.engine.services.jndi.provider.state.factories");
        if (efs == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(efs, ":");
        Object result = null;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            StateFactory fac = this.findStateFactory(nextToken);
            if (fac != null && (result = fac.getStateToBind(obj, name, nameCtx, environment)) != null) {
                return result;
            }
            try {
                Class<?> factoryClass = Class.forName(nextToken, true, Thread.currentThread().getContextClassLoader());
                StateFactory loadedFactory = (StateFactory)factoryClass.newInstance();
                if (loadedFactory != null && (result = loadedFactory.getStateToBind(obj, name, nameCtx, environment)) != null) {
                    return result;
                }
                if (this.log != null && this.log.toLogInfoInLocation()) {
                    this.log.logStringInInfo("getStateToBind method of ResolverManager was called, none of the resolvers was able to return a factory with name: " + nextToken + " so a new instance: " + loadedFactory + " was created using the context class loader : " + Thread.currentThread().getContextClassLoader());
                }
                return loadedFactory;
            }
            catch (ClassNotFoundException cnfe) {
                if (this.log == null || !this.log.toLogPathInLocation()) continue;
                this.log.logStringInPath("ResolverManager was not able to return an instance of state factory with name: " + nextToken);
                this.log.logCatching(cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (this.log == null || !this.log.toLogPathInLocation()) continue;
                this.log.logStringInPath("ResolverManager was not able to return an instance of state factory with name: " + nextToken);
                this.log.logCatching(ncdfe);
            }
            catch (Exception e) {
                if (this.log == null || !this.log.toLogPathInLocation()) continue;
                this.log.logStringInPath("ResolverManager was not able to return an instance of state factory with name: " + nextToken);
                this.log.logCatching(e);
            }
        }
        return null;
    }

    public StateFactory findStateFactory(String stateFactoryName) throws NamingException {
        IResolver resolver = null;
        StateFactory stateFactory = null;
        Object resolverClassName = null;
        resolverClassName = this.sfResolverMapping.get(stateFactoryName);
        if (resolverClassName != null) {
            resolver = (IResolver)this.resolvers.get(resolverClassName);
        }
        if (resolver != null) {
            try {
                stateFactory = resolver.getStateFactory(stateFactoryName);
                if (stateFactory != null) {
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Last used resolver: " + resolver + " will return the state factory: " + stateFactory);
                    }
                    return stateFactory;
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to retrieve state factory " + stateFactoryName + ". Exception is: " + e.toString());
                ne.setRootCause(e);
                throw ne;
            }
        }
        Hashtable hashtable = this.resolvers;
        synchronized (hashtable) {
            Enumeration elements = this.resolvers.elements();
            while (elements.hasMoreElements()) {
                resolver = (IResolver)elements.nextElement();
                try {
                    stateFactory = resolver.getStateFactory(stateFactoryName);
                    if (stateFactory == null) continue;
                    this.sfResolverMapping.put(stateFactoryName, resolver.getClass().getName());
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Resolver: " + resolver + " will return the state factory: " + stateFactory);
                    }
                    StateFactory stateFactory2 = stateFactory;
                    return stateFactory2;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Failed to retrieve state factory " + stateFactoryName + ". Exception is: " + e.toString());
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        }
        return stateFactory;
    }

    public ObjectFactory findObjectFactory(String objectFactoryName) throws NamingException, IllegalAccessException, InstantiationException {
        IResolver resolver = null;
        ObjectFactory objectFactory = null;
        Object resolverClassName = null;
        resolverClassName = this.ofResolverMapping.get(objectFactoryName);
        if (resolverClassName != null) {
            resolver = (IResolver)this.resolvers.get(resolverClassName);
        }
        if (resolver != null) {
            try {
                objectFactory = resolver.getObjectFactory(objectFactoryName);
                if (objectFactory != null) {
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Last used resolver: " + resolver + " will return the object factory: " + objectFactory);
                    }
                    return objectFactory;
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to retrieve object factory " + objectFactoryName + ". Exception is: " + e.toString());
                ne.setRootCause(e);
                throw ne;
            }
        }
        Hashtable hashtable = this.resolvers;
        synchronized (hashtable) {
            Enumeration elements = this.resolvers.elements();
            while (elements.hasMoreElements()) {
                resolver = (IResolver)elements.nextElement();
                try {
                    objectFactory = resolver.getObjectFactory(objectFactoryName);
                    if (objectFactory == null) continue;
                    this.ofResolverMapping.put(objectFactoryName, resolver.getClass().getName());
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Resolver: " + resolver + " will return the object factory: " + objectFactory);
                    }
                    ObjectFactory objectFactory2 = objectFactory;
                    return objectFactory2;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Failed to retrieve object factory " + objectFactoryName + ". Exception is: " + e.toString());
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        }
        try {
            Class<?> factoryClass = Class.forName(objectFactoryName, true, Thread.currentThread().getContextClassLoader());
            ObjectFactory loadedFactory = (ObjectFactory)factoryClass.newInstance();
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("findObjectFactory method of ResolverManager was called, none of the resolvers was able to return a factory with name: " + objectFactoryName + " so a new instance: " + loadedFactory + " was created using the context class loader : " + Thread.currentThread().getContextClassLoader());
            }
            return loadedFactory;
        }
        catch (ClassNotFoundException cnfe) {
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("ResolverManager was not able to return an instance of object factory with name: " + objectFactoryName);
                this.log.logCatching(cnfe);
            }
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("ResolverManager was not able to return an instance of object factory with name: " + objectFactoryName);
                this.log.logCatching(ncdfe);
            }
            return null;
        }
    }

    public InitialContextFactory findInitialContextFactory(Hashtable env) throws NamingException {
        IResolver resolver = null;
        InitialContextFactory initCtxFactory = null;
        String factoryName = (String)env.get("java.naming.factory.initial");
        Object resolverClassName = null;
        if (factoryName != null) {
            resolverClassName = this.icfResolverMapping.get(factoryName);
            if (resolverClassName != null) {
                resolver = (IResolver)this.resolvers.get(resolverClassName);
            }
            if (resolver != null) {
                try {
                    initCtxFactory = resolver.getInitialContextFactory(env);
                    if (initCtxFactory != null) {
                        if (this.log != null && this.log.toLogPathInLocation()) {
                            this.log.logStringInPath("Last used resolver: " + resolver + " will return the initial context factory: " + initCtxFactory);
                        }
                        return initCtxFactory;
                    }
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Failed to retrieve initial context factory " + factoryName + ". Exception is: " + e.toString());
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        }
        Hashtable hashtable = this.resolvers;
        synchronized (hashtable) {
            Enumeration elements = this.resolvers.elements();
            while (elements.hasMoreElements()) {
                resolver = (IResolver)elements.nextElement();
                try {
                    initCtxFactory = resolver.getInitialContextFactory(env);
                    if (initCtxFactory == null) continue;
                    if (factoryName != null) {
                        this.icfResolverMapping.put(factoryName, resolver.getClass().getName());
                    }
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Resolver: " + resolver + " will return the initial context factory: " + initCtxFactory);
                    }
                    InitialContextFactory initialContextFactory = initCtxFactory;
                    return initialContextFactory;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Failed to retrieve initial context factory " + env.get("java.naming.factory.initial") + ". Exception is: " + e.toString());
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        }
        try {
            if (factoryName != null) {
                Class<?> factoryClass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
                InitialContextFactory loadedFactory = (InitialContextFactory)factoryClass.newInstance();
                if (this.log != null && this.log.toLogPathInLocation()) {
                    this.log.logStringInPath("findInitialContextFactory method of ResolverManager was called, none of the resolvers was able to return a factory with name: " + factoryName + " so a new instance: " + loadedFactory + " was created using the context class loader : " + Thread.currentThread().getContextClassLoader());
                }
                return loadedFactory;
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("ResolverManager was not able to return an instance of initial context factory with name: " + factoryName);
                this.log.logCatching(cnfe);
            }
            NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + factoryName);
            ne.setRootCause(cnfe);
            throw ne;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("ResolverManager was not able to return an instance of initial context factory with name: " + factoryName);
                this.log.logCatching(ncdfe);
            }
            NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + factoryName);
            ne.setRootCause(ncdfe);
            throw ne;
        }
        catch (Exception e) {
            if (this.log != null && this.log.toLogPathInLocation()) {
                this.log.logStringInPath("ResolverManager was not able to return an instance of initial context factory with name: " + factoryName);
                this.log.logCatching(e);
            }
            NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + factoryName);
            ne.setRootCause(e);
            throw ne;
        }
        return initCtxFactory;
    }

    public ObjectFactory findURLContextFactory(String scheme, Hashtable env) throws NamingException {
        IResolver resolver = null;
        ObjectFactory urlContextFactory = null;
        Object resolverClassName = null;
        resolverClassName = this.urlcfResolverMapping.get(scheme);
        if (resolverClassName != null) {
            resolver = (IResolver)this.resolvers.get(resolverClassName);
        }
        if (resolver != null) {
            try {
                urlContextFactory = resolver.getURLContextFactory(scheme, env);
                if (urlContextFactory != null) {
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Last used resolver: " + resolver + " will return the URL context factory: " + urlContextFactory);
                    }
                    return urlContextFactory;
                }
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to retrieve URL Context Factory for scheme " + scheme + ". Exception is: " + e.toString());
                ne.setRootCause(e);
                throw ne;
            }
        }
        Hashtable hashtable = this.resolvers;
        synchronized (hashtable) {
            Enumeration elements = this.resolvers.elements();
            while (elements.hasMoreElements()) {
                resolver = (IResolver)elements.nextElement();
                try {
                    urlContextFactory = resolver.getURLContextFactory(scheme, env);
                    if (urlContextFactory == null) continue;
                    this.urlcfResolverMapping.put(scheme, resolver.getClass().getName());
                    if (this.log != null && this.log.toLogPathInLocation()) {
                        this.log.logStringInPath("Resolver: " + resolver + " will return the URL context factory: " + urlContextFactory);
                    }
                    ObjectFactory objectFactory = urlContextFactory;
                    return objectFactory;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Failed to retrieve URL Context Factory for scheme : " + scheme + ". Exception is: " + e.toString());
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        }
        return urlContextFactory;
    }

    public void setLogger(LogHelper logger) {
        if (logger != null) {
            this.log = logger;
        }
    }

    public void disableLogging() {
        if (this.log != null) {
            this.log = null;
        }
    }

    static {
        if (!NamingManager.hasInitialContextFactoryBuilder()) {
            try {
                Manager.instance = new ResolverManager();
                NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilderImpl());
                NamingManager.setObjectFactoryBuilder(new ObjectFactoryBuilderImpl());
            }
            catch (NamingException e) {
                System.out.println("[ResolverManager] failed to set InitialContext/Object Factory in javax.naming.spi.NamingManager because of: " + e.toString());
            }
            initialized = true;
        }
    }
}

