/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system.naming.provider;

import com.sap.engine.system.naming.provider.DefaultInitialContext;
import com.sap.engine.system.naming.provider.DefaultObjectFactory;
import com.sap.engine.system.naming.provider.Manager;
import com.sap.engine.system.naming.provider.ResolverManager;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;

public class ObjectFactoryBuilderImpl
implements ObjectFactoryBuilder {
    private ObjectFactory defaultOF = new DefaultObjectFactory();

    public ObjectFactory createObjectFactory(Object refInfo, Hashtable env) throws NamingException {
        String objFacs;
        Reference ref = null;
        if (refInfo instanceof Reference) {
            ref = (Reference)refInfo;
        } else if (refInfo instanceof Referenceable) {
            ref = ((Referenceable)refInfo).getReference();
        }
        ResolverManager mgr = (ResolverManager)Manager.getInstance();
        ObjectFactory fac = null;
        if (ref != null) {
            String f = ref.getFactoryClassName();
            if (f != null) {
                try {
                    fac = mgr.findObjectFactory(f);
                }
                catch (Exception e) {
                    NamingException ne = new NamingException("Exception while trying to load factory with name : " + f);
                    ne.setRootCause(e);
                    throw ne;
                }
                if (fac != null) {
                    return fac;
                }
                return new DefaultObjectFactory(refInfo);
            }
            int i = 0;
            while (i < ref.size()) {
                String url;
                RefAddr addr = ref.get(i);
                if (addr instanceof StringRefAddr && addr.getType().equalsIgnoreCase("URL") && (url = (String)addr.getContent()) != null) {
                    String scheme = DefaultInitialContext._getURLScheme(url);
                    try {
                        fac = mgr.findURLContextFactory(scheme, env);
                        if (fac != null) {
                            return fac;
                        }
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if ((objFacs = (String)env.get("java.naming.factory.object")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(objFacs, ":");
            while (tokenizer.hasMoreTokens()) {
                String objFac = tokenizer.nextToken().trim();
                try {
                    ObjectFactory of = mgr.findObjectFactory(objFac);
                    if (of == null) continue;
                    return of;
                }
                catch (Exception ne) {
                    NamingException e = new NamingException("No Object Factory found for java.naming.factory.object=" + objFacs);
                    e.setRootCause(ne);
                    throw e;
                }
            }
        }
        return this.defaultOF;
    }
}

