/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.exceptions;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.tc.logging.Location;

public class WSLogging {
    public static String WEBSERVICES_LOCATION = "com.sap.engine.services.webservices";
    public static String SERVER_LOCATION = "com.sap.engine.services.webservices.server";
    public static String DEPLOY_LOCATION = "com.sap.engine.services.webservices.server.deploy";
    public static String RUNTIME_LOCATION = "com.sap.engine.services.webservices.server.runtime";
    public static String WS_CLIENTS_RUNTIME_LOCATION = "com.sap.engine.services.webservices.server.runtime.wsclients";
    public static String CONNECTION_LOCATION = "com.sap.engine.services.webservices.server.connection";
    private static String RUNTIME_LOG_DESTINATION = "./log/services/webservices/runtime";
    private static String WS_CLIENTS_RUNTIME_LOG_DESTINATION = "./log/services/webservices/runtime/wsclients";
    private static int DEFAULT_FILE_LIMIT = 10000000;
    private static int DEFAULT_FILE_COUNT = 5;
    private static int DEFAULT_DESTINATION_SEVERITY = 0;
    private static int DEFAULT_CONTROLLER_SEVERITY = 500;
    private static byte DEFAULT_ASSOCIATION_TYPE = 0;
    private static String DEFAULT_LOG_TYPE = "FileLog";

    public static Location getWSLocation(WSIdentifier wsIdentifier) {
        String wsLocationName = WSLogging.getWSLocationName(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName());
        return Location.getLocation((String)wsLocationName);
    }

    public static Location getWSLocation(String applicationName, String serviceName) {
        String wsLocationName = WSLogging.getWSLocationName(applicationName, serviceName);
        return Location.getLocation((String)wsLocationName);
    }

    public static String getWSLocationName(String applicaitionName, String serviceName) {
        return WSLogging.getComponentLocationName(RUNTIME_LOCATION, applicaitionName, serviceName);
    }

    public static String getWSClientLocationName(String applicaitionName, String serviceRefName) {
        return WSLogging.getComponentLocationName(WS_CLIENTS_RUNTIME_LOCATION, applicaitionName, serviceRefName);
    }

    public static void applyWSClientConfiguration(String applicationName, String serviceRefName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSClientFileLogConfiguration(applicationName, serviceRefName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyConfiguration(logConfiguration);
        }
    }

    public static void applyAndStoreWSClientConfiguration(String applicationName, String serviceRefName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSClientFileLogConfiguration(applicationName, serviceRefName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyAndStoreConfiguration(logConfiguration);
        }
    }

    public static void removeWSClientConfiguration(String applicationName, String serviceRefName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSClientFileLogConfiguration(applicationName, serviceRefName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyConfiguration(null, logConfiguration);
        }
    }

    public static void removeAndStoreWSClientConfiguration(String applicationName, String serviceRefName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSClientFileLogConfiguration(applicationName, serviceRefName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyAndStoreConfiguration(null, logConfiguration);
        }
    }

    public static void applyWSConfiguration(String applicationName, String serviceName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSFileLogConfiguration(applicationName, serviceName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyConfiguration(logConfiguration);
        }
    }

    public static void applyAndStoreWSConfiguration(String applicationName, String serviceName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSFileLogConfiguration(applicationName, serviceName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyAndStoreConfiguration(logConfiguration);
        }
    }

    public static void removeWSConfiguration(String applicationName, String serviceName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSFileLogConfiguration(applicationName, serviceName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyConfiguration(null, logConfiguration);
        }
    }

    public static void removeAndStoreWSConfiguration(String applicationName, String serviceName) {
        LogConfiguratorManagementInterface logConfiguratorInterface = WSContainer.getLogConfiguratorInterface();
        LogConfiguration logConfiguration = WSLogging.constructWSFileLogConfiguration(applicationName, serviceName);
        if (logConfiguratorInterface != null) {
            logConfiguratorInterface.applyAndStoreConfiguration(null, logConfiguration);
        }
    }

    private static LogConfiguration constructWSFileLogConfiguration(String applicationName, String serviceName) {
        return WSLogging.constructComponentFileLogConfiguration(RUNTIME_LOCATION, RUNTIME_LOG_DESTINATION, "ws", applicationName, serviceName);
    }

    private static LogConfiguration constructWSClientFileLogConfiguration(String applicationName, String serviceRefName) {
        return WSLogging.constructComponentFileLogConfiguration(WS_CLIENTS_RUNTIME_LOCATION, WS_CLIENTS_RUNTIME_LOG_DESTINATION, "wsclients", applicationName, serviceRefName);
    }

    private static String getComponentLocationName(String rootLocation, String applicationName, String componentName) {
        return WSLogging.getControllerName(rootLocation, applicationName, componentName);
    }

    private static LogConfiguration constructComponentFileLogConfiguration(String rootLocation, String rootDir, String prefix, String applicationName, String componentName) {
        String controllerName = WSLogging.getControllerName(rootLocation, applicationName, componentName);
        String destinationName = WSLogging.getDestinationName(prefix, applicationName, componentName);
        String destionationFilePath = WSLogging.getDestinationFilePath(rootDir, applicationName, componentName);
        return WSLogging.constructFileLogConfiguration(controllerName, destinationName, destionationFilePath);
    }

    private static LogDestinationDescriptor constructFileLogDestinationDescriptor(String destinationName, String destinationFilePath) {
        LogDestinationDescriptor logDestinationDescriptor = new LogDestinationDescriptor();
        logDestinationDescriptor.setName(destinationName);
        logDestinationDescriptor.setPattern(destinationFilePath);
        logDestinationDescriptor.setEffectiveSeverity(DEFAULT_DESTINATION_SEVERITY);
        logDestinationDescriptor.setCount(DEFAULT_FILE_COUNT);
        logDestinationDescriptor.setLimit(DEFAULT_FILE_LIMIT);
        logDestinationDescriptor.setType(DEFAULT_LOG_TYPE);
        return logDestinationDescriptor;
    }

    private static LogControllerDescriptor constructLogControllerDescriptor(String controllerName, LogDestinationDescriptor logDestinationDescriptor) {
        LogControllerDescriptor logControllerDescriptor = new LogControllerDescriptor();
        logControllerDescriptor.setName(controllerName);
        logControllerDescriptor.setMinSeverity(DEFAULT_CONTROLLER_SEVERITY);
        logControllerDescriptor.setMaxSeverity(DEFAULT_CONTROLLER_SEVERITY);
        logControllerDescriptor.addDestination(logDestinationDescriptor, DEFAULT_ASSOCIATION_TYPE);
        return logControllerDescriptor;
    }

    private static LogConfiguration constructFileLogConfiguration(String controllerName, String destinationName, String destinationFilePath) {
        LogConfiguration logConfiguration = new LogConfiguration();
        LogDestinationDescriptor logDestinationDescriptor = WSLogging.constructFileLogDestinationDescriptor(destinationName, destinationFilePath);
        LogControllerDescriptor logControllerDescriptor = WSLogging.constructLogControllerDescriptor(controllerName, logDestinationDescriptor);
        logConfiguration.setLogControllers(new LogControllerDescriptor[]{logControllerDescriptor});
        logConfiguration.setLogDestinations(new LogDestinationDescriptor[]{logDestinationDescriptor});
        return logConfiguration;
    }

    private static String getDestinationName(String prefix, String applicationName, String componentName) {
        return WSUtil.replaceForbiddenChars((String)prefix) + "_" + WSUtil.replaceForbiddenChars((String)applicationName) + "_" + WSUtil.replaceForbiddenChars((String)componentName);
    }

    private static String getControllerName(String rootLocation, String applicationName, String componentName) {
        return rootLocation + "." + WSUtil.replaceForbiddenChars((String)applicationName) + "." + WSUtil.replaceForbiddenChars((String)componentName);
    }

    private static String getDestinationFilePath(String rootDir, String applicationName, String component) {
        return rootDir + "/" + WSUtil.replaceForbiddenChars((String)applicationName) + "/" + WSUtil.replaceForbiddenChars((String)component) + ".trc";
    }
}

