/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.util;

import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;

public class CipherSuitesUtility {
    private static CipherSuite[] cipherSuites;

    public static void stop() {
        cipherSuites = null;
    }

    private static synchronized void init() {
        try {
            cipherSuites = new CipherSuiteList(4).toArray();
        }
        catch (Exception e) {
            SSLResourceAccessor.traceThrowable(400, "Failed initialization of CipherSuitesUtility", null, e);
            cipherSuites = new CipherSuite[0];
        }
    }

    public static CipherSuiteList convertToList(String[] suites) {
        if (suites == null || suites.length == 0) {
            return new CipherSuiteList();
        }
        CipherSuitesUtility.init();
        CipherSuiteList ciphersuitelist = new CipherSuiteList();
        int i = 0;
        while (i < suites.length) {
            int j = 0;
            while (j < cipherSuites.length) {
                if (cipherSuites[j].getName().equals(suites[i])) {
                    ciphersuitelist.add(cipherSuites[j]);
                }
                ++j;
            }
            ++i;
        }
        return ciphersuitelist;
    }

    public static String[] convertToStringArray(CipherSuiteList list) {
        return CipherSuitesUtility.convertToStringArray(list.toArray());
    }

    public static String[] convertToStringArray(CipherSuite[] suites) {
        String[] s = new String[suites.length];
        int i = 0;
        while (i < s.length) {
            s[i] = suites[i].toString();
            ++i;
        }
        return s;
    }

    public static CipherSuite[] getAllCipherSuites() {
        CipherSuitesUtility.init();
        return cipherSuites;
    }
}

