/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory.session;

import com.sap.engine.lib.util.cache.StableCacheObject;
import iaik.security.ssl.SSLTransport;
import iaik.security.ssl.Session;
import iaik.security.ssl.SessionID;
import java.util.Date;

class SSLSessionWrapper
implements StableCacheObject {
    private Session reference = null;
    private String transport = null;
    private long lastAccess;
    private long resumePeriod;

    public SSLSessionWrapper(Session session, SSLTransport transport) {
        this.reference = session;
        this.transport = transport.getRemotePeerId().toString();
        this.resume();
    }

    public final void resume() {
        this.lastAccess = System.currentTimeMillis();
    }

    public void setResumePeriod(long resumePeriod) {
        this.resumePeriod = resumePeriod;
    }

    public Session getSession() {
        return this.reference;
    }

    public String getTransport() {
        return this.transport;
    }

    public byte[] getId() {
        return ((SessionID)this.reference.getID()).getID();
    }

    public boolean isActive() {
        return System.currentTimeMillis() < this.lastAccess + this.resumePeriod * 1000L && this.reference.isValid();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SSL Session with ");
        sb.append(" remote peer ");
        sb.append(this.transport);
        sb.append(", created on ");
        sb.append(new Date(this.reference.getCreationTime()).toString());
        sb.append(", cipher suite : ");
        sb.append(this.reference.getCipherSuite().getName());
        sb.append(", compression method : ");
        sb.append(this.reference.getCompressionMethod().getName());
        sb.append("\r\n");
        sb.append(this.reference.getID().toString());
        sb.append("\r\n");
        return sb.toString();
    }

    public void cacheFinalization() {
        this.reference = null;
        this.transport = null;
    }
}

