/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory.session;

import com.sap.engine.lib.lang.SWMRG;
import com.sap.engine.lib.util.cache.Cache;
import com.sap.engine.services.ssl.factory.SSLSession;
import com.sap.engine.services.ssl.factory.session.KeyWrapper;
import com.sap.engine.services.ssl.factory.session.SSLSessionWrapper;
import com.sap.engine.services.timeout.TimeoutListener;
import iaik.security.ssl.SSLTransport;
import iaik.security.ssl.Session;
import iaik.security.ssl.SessionID;
import iaik.security.ssl.SessionManager;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLSessionContext;

public class JSSELimitedCache
extends SessionManager
implements TimeoutListener,
SSLSessionContext {
    private int cache_size = 1000;
    private int resume_period = 7200;
    private Cache cache = null;
    private SWMRG guard = null;
    private static JSSELimitedCache reference = null;

    private JSSELimitedCache(int cache_size) {
        if (cache_size > 10) {
            this.cache_size = cache_size;
        }
        this.cache = new Cache(10, this.cache_size);
        this.guard = new SWMRG();
    }

    public static JSSELimitedCache initialize(int size, int resume_period) {
        if (reference != null) {
            return reference;
        }
        reference = new JSSELimitedCache(size);
        reference.setSessionTimeout(resume_period);
        return reference;
    }

    public static JSSELimitedCache getInstance() {
        return reference;
    }

    public static void stop() {
        JSSELimitedCache.reference.cache = null;
        reference = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Session getSession(SSLTransport sslTransport, Object o) {
        Session session;
        block7: {
            Session session2;
            block6: {
                Session session3;
                block5: {
                    this.guard.startRead();
                    try {
                        if (o == null) {
                            Session session4 = null;
                            Object var7_5 = null;
                            this.guard.endRead();
                            return session4;
                        }
                        byte[] sessionID = ((SessionID)o).getID();
                        SSLSessionWrapper session5 = (SSLSessionWrapper)this.cache.lookupCache(new KeyWrapper(sessionID));
                        if (session5 == null) {
                            session3 = null;
                            break block5;
                        }
                        if (!session5.getTransport().equals(sslTransport.getRemotePeerId())) {
                            session2 = null;
                            break block6;
                        }
                        session5.resume();
                        session = session5.getSession();
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.guard.endRead();
                        throw throwable;
                    }
                }
                Object var7_6 = null;
                this.guard.endRead();
                return session3;
            }
            Object var7_7 = null;
            this.guard.endRead();
            return session2;
        }
        Object var7_8 = null;
        this.guard.endRead();
        return session;
    }

    protected void cacheSession(SSLTransport sslTransport, Session session) {
        this.guard.startWrite();
        try {
            SSLSessionWrapper wrapper = new SSLSessionWrapper(session, sslTransport);
            wrapper.setResumePeriod(this.resume_period);
            this.cache.addCache(new KeyWrapper(((SessionID)session.getID()).getID()), wrapper);
            Object var5_4 = null;
            this.guard.endWrite();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }

    public Enumeration getIds() {
        this.guard.startRead();
        try {
            Iterator iter = this.cache.keyIterator();
            Vector<byte[]> v = new Vector<byte[]>(10);
            while (iter.hasNext()) {
                v.addElement(((KeyWrapper)iter.next()).getKey());
            }
            Enumeration enumeration = v.elements();
            Object var5_4 = null;
            this.guard.endRead();
            return enumeration;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.guard.endRead();
            throw throwable;
        }
    }

    public javax.net.ssl.SSLSession getSession(byte[] bytes) {
        SSLSession sSLSession;
        this.guard.startRead();
        try {
            SSLSessionWrapper session = (SSLSessionWrapper)this.cache.lookupCache(new KeyWrapper(bytes));
            if (session == null) {
                javax.net.ssl.SSLSession sSLSession2 = null;
                Object var5_5 = null;
                this.guard.endRead();
                return sSLSession2;
            }
            sSLSession = new SSLSession(session.getSession(), this);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.guard.endRead();
            throw throwable;
        }
        Object var5_6 = null;
        this.guard.endRead();
        return sSLSession;
    }

    public int getSessionCacheSize() {
        return this.cache_size;
    }

    public int getSessionTimeout() {
        return this.resume_period;
    }

    public void setSessionCacheSize(int size) throws IllegalArgumentException {
        throw new IllegalStateException();
    }

    public void setSessionTimeout(int sec) throws IllegalArgumentException {
        if (sec < 300) {
            throw new IllegalArgumentException();
        }
        this.resume_period = sec;
    }

    protected void removeSession(byte[] sessionId) {
        this.guard.startWrite();
        try {
            KeyWrapper key = new KeyWrapper(sessionId);
            this.cache.remove(key);
            Object var4_3 = null;
            this.guard.endWrite();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }

    public void timeout() {
        this.clearInvalidSessions();
    }

    public boolean check() {
        return this.cache.stableSize() != 0;
    }

    protected void clearInvalidSessions() {
        this.guard.startWrite();
        try {
            Iterator keys = this.cache.keyIterator();
            Object key = null;
            SSLSessionWrapper value = null;
            Vector keysToRemove = new Vector();
            while (keys.hasNext()) {
                key = keys.next();
                value = (SSLSessionWrapper)this.cache.getByKey(key);
                if (value.isActive()) continue;
                keysToRemove.addElement(key);
            }
            int i = 0;
            while (i < keysToRemove.size()) {
                this.cache.remove(keysToRemove.elementAt(i));
                ++i;
            }
            Object var7_6 = null;
            this.guard.endWrite();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }

    public String toString() {
        this.clearInvalidSessions();
        this.guard.startWrite();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.cache.stableSize() + " sessions kept.\r\n");
            Iterator values = this.cache.valueIterator();
            SSLSessionWrapper session = null;
            int i = 0;
            while (values.hasNext()) {
                session = (SSLSessionWrapper)values.next();
                sb.append(++i + ") ");
                sb.append(session.toString() + "\r\n");
            }
            String string = sb.toString();
            Object var7_6 = null;
            this.guard.endWrite();
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }

    public String toString(byte[] sessionKey) {
        this.guard.startRead();
        try {
            SSLSessionWrapper session = (SSLSessionWrapper)this.cache.getByKey(new KeyWrapper(sessionKey));
            String string = session == null ? null : session.toString();
            Object var5_4 = null;
            this.guard.endRead();
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.guard.endRead();
            throw throwable;
        }
    }

    public void clear() {
        this.guard.startWrite();
        try {
            this.cache = new Cache(10, this.cache_size);
            Object var2_1 = null;
            this.guard.endWrite();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }
}

