/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import com.sap.engine.services.ssl.dispatcher.DispatcherService;
import com.sap.engine.services.ssl.exception.SSLConfigurationException;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.SSLSession;
import com.sap.engine.services.ssl.factory.session.JSSELimitedCache;
import com.sap.engine.services.ssl.util.CipherSuitesUtility;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.jsse.utils.Util;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SessionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

public class SSLSocket
extends javax.net.ssl.SSLSocket {
    private iaik.security.ssl.SSLSocket iaikSocket;
    private Socket innerSocket = null;
    private boolean autoClose = true;
    private Vector listener = new Vector();
    private boolean isSessionCreationEnabled = true;
    private boolean isHandshakeDone = false;
    private SSLContext context;
    private SSLSession session = null;
    private SSLSessionContext sessionManager = null;
    private Certificate[] clientCertificate = null;
    private static final String CLIENT_CERT_NOT_AVAILABLE = "ssl_ssl_socket_client_cert_not_available";
    private static final String GET_SESSION = "ssl_ssl_socket_get_new_session";

    public Certificate[] getClientCertificate() {
        return this.clientCertificate;
    }

    private void notifyListener() {
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.getSession());
        try {
            this.clientCertificate = Util.convert((X509Certificate[])event.getPeerCertificateChain());
        }
        catch (Throwable e) {
            SSLResourceAccessor.log(400, e, CLIENT_CERT_NOT_AVAILABLE);
            SSLResourceAccessor.traceThrowable(400, "getClientCertificate() failed", e);
        }
        int i = 0;
        while (i < this.listener.size()) {
            HandshakeCompletedListener l = (HandshakeCompletedListener)this.listener.elementAt(i);
            l.handshakeCompleted(event);
            ++i;
        }
    }

    protected SSLSocket(InetAddress host, int port, InetAddress clientHost, int clientPort, SSLContext context) throws IOException, UnknownHostException {
        this.iaikSocket = new iaik.security.ssl.SSLSocket(host, port, clientHost, clientPort, context);
        this.context = context;
    }

    protected SSLSocket(InetAddress host, int port, SSLContext context) throws IOException {
        this.iaikSocket = new iaik.security.ssl.SSLSocket(host, port, context);
        this.context = context;
    }

    protected SSLSocket(String host, int port, InetAddress clientHost, int clientPort, SSLContext context) throws IOException {
        this.iaikSocket = new iaik.security.ssl.SSLSocket(host, port, clientHost, clientPort, context);
        this.context = context;
    }

    protected SSLSocket(String host, int port, SSLContext context) throws IOException {
        this.iaikSocket = new iaik.security.ssl.SSLSocket(host, port, context);
        this.context = context;
    }

    protected SSLSocket(Socket proxySocket, String host, int port, boolean autoClose, SSLContext context) throws IOException {
        this.autoClose = autoClose;
        this.context = context;
        this.iaikSocket = new iaik.security.ssl.SSLSocket(proxySocket, context, host, port);
    }

    public void init(Socket s, SSLContext ctx, boolean useClientMode) throws IOException {
        this.innerSocket = s;
        this.iaikSocket.init(s, ctx, useClientMode);
        SessionManager sessionManager = ctx.getSessionManager();
        if (sessionManager instanceof JSSESessionManager) {
            ((JSSESessionManager)sessionManager).setResumePeriod((long)DispatcherService.RESUME_SESSION_PERIOD);
        } else {
            try {
                if (sessionManager instanceof JSSELimitedCache) {
                    ((JSSELimitedCache)sessionManager).setSessionTimeout(DispatcherService.RESUME_SESSION_PERIOD);
                }
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
    }

    public void startHandshake() throws IOException {
        try {
            if (!this.isSessionCreationEnabled) {
                throw new IOException(" Creation of SSL sessions is not allowed.");
            }
            this.iaikSocket.setSoTimeout(DispatcherService.HANDSHAKE_SO_TIMEOUT);
            if (this.innerSocket != null) {
                this.innerSocket.setSoTimeout(DispatcherService.HANDSHAKE_SO_TIMEOUT);
            }
            this.iaikSocket.startHandshake();
            this.iaikSocket.setSoTimeout(DispatcherService.RUNTIME_SO_TIMEOUT);
            if (this.innerSocket != null) {
                this.innerSocket.setSoTimeout(DispatcherService.RUNTIME_SO_TIMEOUT);
            }
            this.isHandshakeDone = true;
            this.notifyListener();
        }
        catch (IOException ioe) {
            SSLResourceAccessor.traceThrowable(300, "Handshake failed", ioe);
            throw ioe;
        }
        catch (Exception e) {
            SSLResourceAccessor.traceThrowable(300, "Handshake failed", e);
            throw new IOException("SSL Handshake failed: " + e);
        }
    }

    public void setUseClientMode(boolean clientMode) throws SSLConfigurationException {
        try {
            this.iaikSocket.setUseClientMode(clientMode);
        }
        catch (IOException e) {
            throw new SSLConfigurationException("ssl_0030", e);
        }
    }

    public boolean getNeedClientAuth() {
        if (!this.iaikSocket.getUseClientMode()) {
            try {
                SSLServerContext ctx = (SSLServerContext)this.iaikSocket.getContext();
                return ctx.getRequestClientCertificate();
            }
            catch (Exception e) {
                SSLResourceAccessor.traceThrowable(400, "getNeedClientAuth() failed:", e);
            }
        }
        return false;
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.context.setEnabledCipherSuiteList(CipherSuitesUtility.convertToList(suites));
        this.context.updateCipherSuites();
    }

    public void setEnableSessionCreation(boolean create) {
        this.isSessionCreationEnabled = create;
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        while (this.listener.removeElement(listener)) {
        }
    }

    public boolean getUseClientMode() {
        return this.iaikSocket.getUseClientMode();
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList list = new CipherSuiteList(3);
        String[] s = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            s[i] = list.elementAt(i).getName();
            ++i;
        }
        return s;
    }

    public javax.net.ssl.SSLSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.session == null) {
                try {
                    this.sessionManager = (SSLSessionContext)this.context.getSessionManager();
                    this.session = new SSLSession(this.iaikSocket.getSession(), this.sessionManager);
                }
                catch (Exception e) {
                    SSLResourceAccessor.log(400, e, GET_SESSION);
                    SSLResourceAccessor.traceThrowable(400, "getSession() ", e);
                    SSLResourceAccessor.trace(400, "sessionManager: " + this.sessionManager + ", session: " + this.session);
                }
            }
            SSLSession sSLSession = this.session;
            return sSLSession;
        }
    }

    public void setNeedClientAuth(boolean needed) {
        if (this.iaikSocket.getUseClientMode()) {
            throw new IllegalArgumentException("Not a server side socket");
        }
        SSLServerContext ctx = (SSLServerContext)this.iaikSocket.getContext();
        ctx.setRequestClientCertificate(needed);
    }

    public String[] getEnabledCipherSuites() {
        return CipherSuitesUtility.convertToStringArray(this.context.getEnabledCipherSuiteList());
    }

    public boolean getEnableSessionCreation() {
        return this.isSessionCreationEnabled;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.listener.addElement(listener);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isHandshakeDone) {
            this.startHandshake();
        }
        return this.iaikSocket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isHandshakeDone) {
            this.startHandshake();
        }
        return this.iaikSocket.getOutputStream();
    }

    public InetAddress getInetAddress() {
        return this.iaikSocket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.iaikSocket.getLocalAddress();
    }

    public int getPort() {
        return this.iaikSocket.getPort();
    }

    public int getLocalPort() {
        return this.iaikSocket.getLocalPort();
    }

    public void setKeepAlive(boolean keepAlive) throws SocketException {
        if (this.innerSocket == null) {
            this.iaikSocket.setKeepAlive(keepAlive);
        } else {
            this.innerSocket.setKeepAlive(keepAlive);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.innerSocket == null) {
            return this.iaikSocket.getKeepAlive();
        }
        return this.innerSocket.getKeepAlive();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.innerSocket == null) {
            this.iaikSocket.setTcpNoDelay(on);
        } else {
            this.innerSocket.setTcpNoDelay(on);
        }
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.innerSocket == null) {
            return this.iaikSocket.getTcpNoDelay();
        }
        return this.innerSocket.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.innerSocket == null) {
            this.iaikSocket.setSoLinger(on, linger);
        } else {
            this.innerSocket.setSoLinger(on, linger);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.innerSocket == null) {
            return this.iaikSocket.getSoLinger();
        }
        return this.innerSocket.getSoLinger();
    }

    public void setSoTimeout(int timeout) throws SocketException {
    }

    public int getSoTimeout() throws SocketException {
        if (this.innerSocket == null) {
            return this.iaikSocket.getSoTimeout();
        }
        return this.innerSocket.getSoTimeout();
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.innerSocket == null) {
            this.iaikSocket.setSendBufferSize(size);
        } else {
            this.innerSocket.setSendBufferSize(size);
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.innerSocket == null) {
            return this.iaikSocket.getSendBufferSize();
        }
        return this.innerSocket.getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.innerSocket == null) {
            this.iaikSocket.setReceiveBufferSize(size);
        } else {
            this.innerSocket.setReceiveBufferSize(size);
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.innerSocket == null) {
            return this.iaikSocket.getReceiveBufferSize();
        }
        return this.innerSocket.getReceiveBufferSize();
    }

    public void close() throws IOException {
        if (this.autoClose) {
            this.iaikSocket.close();
        }
        this.isHandshakeDone = false;
    }

    public String toString() {
        return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
    }

    public static void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        SSLSocket.setSocketImplFactory(fac);
    }

    SSLContext getSSLContext() {
        return this.context;
    }

    void setSSLContext(SSLContext context) {
        this.context = context;
    }

    public String[] getSupportedProtocols() {
        return CipherSuitesUtility.convertToStringArray(CipherSuitesUtility.getAllCipherSuites());
    }

    public String[] getEnabledProtocols() {
        return CipherSuitesUtility.convertToStringArray(this.context.getEnabledCipherSuites());
    }

    public void setEnabledProtocols(String[] protocols) {
        this.context.setEnabledCipherSuiteList(CipherSuitesUtility.convertToList(protocols));
    }

    public void setWantClientAuth(boolean flag) {
    }

    public boolean getWantClientAuth() {
        return false;
    }
}

