/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import iaik.security.jsse.utils.Util;
import iaik.security.ssl.Session;
import iaik.security.ssl.SessionID;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;

public class SSLSession
implements javax.net.ssl.SSLSession {
    private Session iaikSession_;
    private SSLSessionContext sessionContext_;
    private Hashtable bindings_;
    private long lastAccessedTime_;

    public SSLSession(Session iaikSession, SSLSessionContext manager) {
        this.iaikSession_ = iaikSession;
        this.sessionContext_ = manager;
        this.bindings_ = new Hashtable();
        this.lastAccessedTime_ = System.currentTimeMillis();
    }

    public String getCipherSuite() {
        return this.iaikSession_.getCipherSuite().getName();
    }

    public long getCreationTime() {
        return this.iaikSession_.getCreationTime();
    }

    public byte[] getId() {
        SessionID id = (SessionID)this.iaikSession_.getID();
        return id.getID();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime_;
    }

    public javax.security.cert.X509Certificate[] getPeerCertificateChain() {
        X509Certificate[] certificates = this.iaikSession_.getPeerCertificateChain();
        return certificates != null ? Util.convert((X509Certificate[])certificates) : new javax.security.cert.X509Certificate[]{};
    }

    public String getPeerHost() {
        return null;
    }

    public SSLSessionContext getSessionContext() {
        return this.sessionContext_;
    }

    public Object getValue(String name) {
        return this.bindings_.get(name);
    }

    public String[] getValueNames() {
        String[] names = new String[this.bindings_.size()];
        Enumeration e = this.bindings_.keys();
        if (e != null) {
            int i = 0;
            while (e.hasMoreElements()) {
                names[i] = (String)e.nextElement();
                ++i;
            }
        }
        return names;
    }

    public void invalidate() {
        this.iaikSession_.invalidate();
    }

    public void putValue(String name, Object value) {
        this.bindings_.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener ear = (SSLSessionBindingListener)value;
            ear.valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void removeValue(String name) {
        Object value = this.bindings_.remove(name);
        if (value != null && value instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener ear = (SSLSessionBindingListener)value;
            ear.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public boolean equals(Object alien) {
        if (alien instanceof SSLSession) {
            return this.iaikSession_.equals(((SSLSession)alien).getSession());
        }
        return false;
    }

    Session getSession() {
        return this.iaikSession_;
    }

    void setSession(Session session) {
        this.iaikSession_ = session;
    }

    void setLastAccessTime(long time) {
        this.lastAccessedTime_ = time;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.iaikSession_.getPeerCertificateChain();
    }

    public Certificate[] getLocalCertificates() {
        return null;
    }

    public String getProtocol() {
        return null;
    }
}

