/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import com.sap.engine.services.ssl.exception.LoggerPrintStream;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.Credentials;
import com.sap.engine.services.ssl.factory.SSLSocket;
import com.sap.engine.services.ssl.keystore.KeyStoreConnector;
import com.sap.engine.services.ssl.util.CipherSuitesUtility;
import com.sap.engine.services.ssl.util.Utility;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SessionManager;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class ClientSocketFactory
extends SSLSocketFactory
implements RMIClientSocketFactory {
    private SSLServerContext defaultContext;
    private SSLServerContext context;
    private static ClientSocketFactory defaultFactory;
    private static final String NO_INITIAL_CIPHER_SUITES = "ssl_client_socket_factory_no_initial_cipher_suites";
    private static final String NO_AVAILABLE_CIPHER_SUITES = "ssl_client_socket_factory_no_available_cipher_suites";
    private static final String GET_DEFAULT_FACTORY = "ssl_client_socket_factory_no_default_factory";

    public static void stop() {
        defaultFactory = null;
        CipherSuitesUtility.stop();
    }

    public ClientSocketFactory(SSLServerContext ctx) throws IOException {
        this.initializeCredentials();
        this.context = ctx;
        JSSESessionManager manager = null;
        try {
            manager = (SessionManager)Class.forName("com.sap.engine.services.ssl.factory.session.JSSELimitedCache").getDeclaredMethod("getInstance", new Class[0]).invoke(null, null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (manager == null) {
            manager = new JSSESessionManager();
        }
        this.context.setDebugStream((Writer)new LoggerPrintStream());
        this.context.setSessionManager((SessionManager)manager);
        this.context.setChainVerifier(null);
    }

    public void addCredentials(String keystoreAliase) {
        this.addCredentials(new String[]{keystoreAliase});
    }

    public void addCredentials(String[] keystoreAliases) {
        SSLServerContext sSLServerContext = this.context;
        synchronized (sSLServerContext) {
            Credentials[] additional = null;
            additional = KeyStoreConnector.getCredentials(keystoreAliases);
            int i = 0;
            while (i < additional.length) {
                this.context.addServerCredentials((KeyAndCert)additional[i]);
                this.defaultContext.addServerCredentials((KeyAndCert)additional[i]);
                this.context.addClientCredentials((KeyAndCert)additional[i]);
                this.defaultContext.addClientCredentials((KeyAndCert)additional[i]);
                ++i;
            }
            CipherSuite[] suites = CipherSuitesUtility.getAllCipherSuites();
            if (suites.length == 0) {
                SSLResourceAccessor.log(500, "", NO_INITIAL_CIPHER_SUITES);
                return;
            }
            this.context.setEnabledCipherSuites(suites);
            this.defaultContext.setEnabledCipherSuites(suites);
            this.context.updateCipherSuites();
            this.defaultContext.updateCipherSuites();
            if (this.context.getEnabledCipherSuites().length == 0) {
                SSLResourceAccessor.log(500, "", NO_AVAILABLE_CIPHER_SUITES);
            }
        }
    }

    public boolean addTrustedCertificates(String alias, boolean newCnainVerifierNeeded) {
        SSLServerContext sSLServerContext = this.context;
        synchronized (sSLServerContext) {
            if (alias == null || alias.trim().length() == 0) {
                if (newCnainVerifierNeeded) {
                    this.context.setChainVerifier(new ChainVerifier());
                }
                this.context.getChainVerifier().addTrustedCertificate(null);
                boolean bl = true;
                return bl;
            }
            Certificate certificate = KeyStoreConnector.getCertificate(alias);
            if (certificate != null && certificate instanceof X509Certificate) {
                if (newCnainVerifierNeeded) {
                    this.context.setChainVerifier(new ChainVerifier());
                }
                this.context.getChainVerifier().addTrustedCertificate((X509Certificate)certificate);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return new SSLSocket(host, port, (SSLContext)((SSLServerContext)this.context.clone()));
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new SSLSocket(host, port, (SSLContext)((SSLServerContext)this.context.clone()));
    }

    public Socket createSocket(InetAddress host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return new SSLSocket(host, port, clientHost, clientPort, (SSLContext)((SSLServerContext)this.context.clone()));
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return new SSLSocket(host, port, clientHost, clientPort, (SSLContext)((SSLServerContext)this.context.clone()));
    }

    public Socket createSocket(Socket socket, InetAddress host, int port, boolean autoClose) throws IOException {
        return new SSLSocket(socket, host.getHostAddress(), port, autoClose, (SSLContext)((SSLServerContext)this.context.clone()));
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return new SSLSocket(socket, host, port, autoClose, (SSLContext)((SSLServerContext)this.context.clone()));
    }

    public String[] getCredentials() {
        int[] types = this.context.getAllowedCertificateTypes();
        Vector<KeyAndCert> credentials = new Vector<KeyAndCert>(6, 10);
        String[] aliases = null;
        int i = 0;
        while (i < types.length) {
            try {
                credentials.add(this.context.getServerCredentials(types[i]));
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            ++i;
        }
        aliases = new String[credentials.size()];
        int i2 = 0;
        while (i2 < aliases.length) {
            aliases[i2] = ((Credentials)((Object)credentials.elementAt(i2))).getAlias();
            ++i2;
        }
        return aliases;
    }

    public String[] getDefaultCipherSuites() {
        return this.getEnabledCipherSuites();
    }

    public static synchronized SocketFactory getDefault() {
        if (defaultFactory == null) {
            try {
                SSLServerContext serverContext = new SSLServerContext();
                serverContext.setDebugStream((Writer)new LoggerPrintStream());
                defaultFactory = new ClientSocketFactory(serverContext);
            }
            catch (Exception e) {
                SSLResourceAccessor.log(500, e, GET_DEFAULT_FACTORY);
                SSLResourceAccessor.traceThrowable(400, GET_DEFAULT_FACTORY, null, e);
            }
        }
        return defaultFactory;
    }

    public String[] getEnabledCipherSuites() {
        return CipherSuitesUtility.convertToStringArray(this.context.getEnabledCipherSuiteList());
    }

    public String[] getAvailableCertificates() {
        return KeyStoreConnector.getCertificates();
    }

    public boolean getNeedClientAuth() {
        return this.context.getRequestClientCertificate();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuitesUtility.convertToStringArray(this.defaultContext.getEnabledCipherSuiteList());
    }

    private void initializeCredentials() {
        this.defaultContext = new SSLServerContext();
        this.defaultContext.setDebugStream((Writer)new LoggerPrintStream());
    }

    public void removeCredentials(String keystoreAliase) {
        this.removeCredentials(new String[]{keystoreAliase});
    }

    public void removeCredentials(String[] keystoreAliases) {
        this.setCredentials(Utility.remove(keystoreAliases, this.getCredentials()));
    }

    void removeTrustedCertificates(String alias, boolean newCnainVerifierNeeded) {
        this.removeTrustedCertificates(new String[]{alias}, newCnainVerifierNeeded);
    }

    void removeTrustedCertificates(String[] aliases, boolean newCnainVerifierNeeded) {
        Certificate[] certificates = KeyStoreConnector.getCertificates(aliases);
        SSLServerContext sSLServerContext = this.context;
        synchronized (sSLServerContext) {
            int i = 0;
            while (i < aliases.length) {
                if (aliases[i] == null || aliases[i].trim().length() == 0) {
                    this.context.getChainVerifier().removeTrustedCertificate(null);
                }
                ++i;
            }
            if (certificates != null) {
                int i2 = 0;
                while (i2 < certificates.length) {
                    if (certificates[i2] instanceof X509Certificate) {
                        this.context.getChainVerifier().removeTrustedCertificate((X509Certificate)certificates[i2]);
                    }
                    ++i2;
                }
            }
            if (newCnainVerifierNeeded) {
                this.context.setChainVerifier(null);
            }
        }
    }

    public void setCredentials(String[] keystoreAliases) {
        SSLServerContext sSLServerContext = this.defaultContext;
        synchronized (sSLServerContext) {
            this.context.clearServerCredentials();
            this.defaultContext.clearServerCredentials();
            this.addCredentials(keystoreAliases);
        }
    }

    public void setDefaultCipherSuites(String[] suites) {
        this.setEnabledCipherSuites(suites);
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.context.setEnabledCipherSuiteList(CipherSuitesUtility.convertToList(suites));
        this.context.updateCipherSuites();
    }

    public void setNeedClientAuth(boolean flag) {
        this.context.setRequestClientCertificate(flag);
    }
}

