/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.exception;

import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Locale;

public class SSLResourceAccessor
extends ResourceAccessor {
    public static Category category = null;
    public static Location location = null;
    private static final String BUNDLE_NAME = "com.sap.engine.services.ssl.exception.SSLResourceBundle";
    private static final String SUFIX_DESCRIPTION = "_descr";
    private static final String POSTFIX_CONSEQUENCES = "_cnsq";
    private static final String POSTFIX_COUNTERMEASURES = "_cntrmsr";
    private static final String GENERAL_LOG_TEMPLATE = "ssl_general_log";
    private static ResourceAccessor resourceAccessor = null;
    private static Locale currentLocale = Locale.getDefault();

    private SSLResourceAccessor() {
        super(BUNDLE_NAME);
        category = Category.getCategory((String)"/System/Security/SSL");
        location = Location.getLocation((String)"com.sap.engine.services.ssl");
    }

    public static synchronized ResourceAccessor getResourceAccessor() {
        if (resourceAccessor == null) {
            resourceAccessor = new SSLResourceAccessor();
        }
        return resourceAccessor;
    }

    private static final String getDescriptionKey(String key) {
        return key + SUFIX_DESCRIPTION;
    }

    private static final String getConsequencesKey(String key) {
        return key + POSTFIX_CONSEQUENCES;
    }

    private static final String getCountermeasuresKey(String key) {
        return key + POSTFIX_COUNTERMEASURES;
    }

    public static String getMessage(String key) {
        String result = key;
        try {
            result = new LocalizableTextFormatter(resourceAccessor, key, null).format();
        }
        catch (LocalizationException e) {
            result = resourceAccessor.getMessageText(currentLocale, key);
        }
        return result;
    }

    public static LocalizableText getLocalizableMessage(String key, Object[] params) {
        return new LocalizableTextFormatter(resourceAccessor, key, params);
    }

    public static String getMessage(String key, Object[] params) {
        String result = key;
        try {
            result = new LocalizableTextFormatter(resourceAccessor, key, params).format();
        }
        catch (LocalizationException e) {
            result = resourceAccessor.getMessageText(currentLocale, key);
        }
        return result;
    }

    public static String getDescription(String key, Object[] params) {
        String result = key = SSLResourceAccessor.getDescriptionKey(key);
        try {
            result = new LocalizableTextFormatter(resourceAccessor, key, params).format();
        }
        catch (LocalizationException e) {
            result = resourceAccessor.getMessageText(currentLocale, key);
        }
        return result;
    }

    public static String getConsequences(String key, Object[] params) {
        String result = key = SSLResourceAccessor.getConsequencesKey(key);
        try {
            result = new LocalizableTextFormatter(resourceAccessor, key, params).format();
        }
        catch (LocalizationException e) {
            result = resourceAccessor.getMessageText(currentLocale, key);
        }
        return result;
    }

    public static String getCountermeasures(String key, Object[] params) {
        String result = key = SSLResourceAccessor.getCountermeasuresKey(key);
        try {
            result = new LocalizableTextFormatter(resourceAccessor, key, params).format();
        }
        catch (LocalizationException e) {
            result = resourceAccessor.getMessageText(currentLocale, key);
        }
        return result;
    }

    public static void log(int severity, Object source, String messageId) {
        SSLResourceAccessor.log(severity, source, SSLResourceAccessor.getDescription(messageId, null), SSLResourceAccessor.getConsequences(messageId, null), SSLResourceAccessor.getCountermeasures(messageId, null));
    }

    public static void log(int severity, Object source, String messageId, Object[] params) {
        SSLResourceAccessor.log(severity, source, SSLResourceAccessor.getDescription(messageId, params), SSLResourceAccessor.getConsequences(messageId, params), SSLResourceAccessor.getCountermeasures(messageId, params));
    }

    public static void log(int severity, Object source, String description, String consequences, String countermeasures) {
        if (location == null || category == null) {
            return;
        }
        switch (severity) {
            case 300: {
                category.infoT(location, SSLResourceAccessor.getMessage(GENERAL_LOG_TEMPLATE, new Object[]{source, description, consequences, countermeasures}), (Object[])null);
                break;
            }
            case 400: {
                category.warningT(location, SSLResourceAccessor.getMessage(GENERAL_LOG_TEMPLATE, new Object[]{source, description, consequences, countermeasures}), (Object[])null);
                break;
            }
            case 500: {
                category.errorT(location, SSLResourceAccessor.getMessage(GENERAL_LOG_TEMPLATE, new Object[]{source, description, consequences, countermeasures}), (Object[])null);
                break;
            }
            case 600: {
                category.fatalT(location, SSLResourceAccessor.getMessage(GENERAL_LOG_TEMPLATE, new Object[]{source, description, consequences, countermeasures}), (Object[])null);
                break;
            }
        }
    }

    public static void trace(int severity, String msg) {
        if (location == null) {
            return;
        }
        switch (severity) {
            case 200: {
                location.pathT(msg);
                break;
            }
            case 100: {
                location.debugT(msg);
                break;
            }
            case 300: {
                location.infoT(msg);
                break;
            }
            case 400: {
                location.warningT(msg);
                break;
            }
            case 500: {
                location.errorT(msg);
                break;
            }
            case 600: {
                location.fatalT(msg);
                break;
            }
        }
    }

    public static void trace(int severity, String key, Object[] parameters) {
        SSLResourceAccessor.trace(severity, SSLResourceAccessor.getMessage(key, parameters));
    }

    public static void traceThrowable(int severity, String msg, Throwable exc) {
        if (location == null) {
            return;
        }
        if (exc != null) {
            location.traceThrowableT(severity, msg, exc);
        } else {
            SSLResourceAccessor.trace(severity, msg);
        }
    }

    public static void traceThrowable(int severity, String key, Object[] params, Throwable exc) {
        if (location == null) {
            return;
        }
        if (exc != null) {
            location.traceThrowableT(severity, SSLResourceAccessor.getMessage(key, params), exc);
        } else {
            SSLResourceAccessor.trace(severity, key, params);
        }
    }
}

