/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.exception;

import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class LoggerPrintStream
extends PrintWriter {
    private StringBuffer buff = null;
    private static String lineSeparator = null;

    public LoggerPrintStream() {
        super(System.out);
    }

    public void close() {
        super.close();
        this.flush();
    }

    public void flush() {
        this.println();
    }

    public void println() {
        if (this.buff != null) {
            SSLResourceAccessor.trace(100, this.buff.toString());
            this.buff = null;
        }
    }

    public void write(int b) {
        this.write(String.valueOf((char)b));
    }

    public void write(byte[] buf, int off, int len) {
        this.write(new String(buf, off, len));
    }

    public void write(String string, int off, int len) {
        this.write(string.substring(off, len));
    }

    public void write(String string) {
        if (!string.equals(lineSeparator)) {
            if (this.buff == null) {
                this.buff = new StringBuffer();
            }
            this.buff.append(string);
        } else {
            this.println();
        }
    }

    static {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(baos, true);
            writer.println();
            writer.close();
            lineSeparator = new String(baos.toByteArray());
        }
        catch (Exception e) {
            lineSeparator = new String(new byte[]{19, 16});
        }
    }
}

