/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.dispatcher.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.ssl.factory.session.JSSELimitedCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class SessionCommand
implements Command {
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        try {
            if (params.length != 1) {
                output.write(this.getHelpMessage().getBytes());
                return;
            }
            JSSELimitedCache cache = JSSELimitedCache.getInstance();
            if (params[0].equals("-list")) {
                output.write(cache.toString().getBytes());
                return;
            }
            byte[] sessionKey = SessionCommand.hexStringToByteArr(params[0]);
            String toString = cache.toString(sessionKey);
            if (toString == null) {
                output.write(("no ssl session with key " + params[0] + "\r\n").getBytes());
                return;
            }
            output.write(toString.getBytes());
        }
        catch (IOException ioe) {
            try {
                output.write(ioe.getMessage().getBytes());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return "sslsession";
    }

    public String getGroup() {
        return "ssl";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[0];
    }

    public String getHelpMessage() {
        return "Shows the ssl sessions in details.\nUsage: \n" + this.getName() + " -list\n Shows all the valid sessions.\n" + this.getName() + " [sessionID]\n Shows the specified ssl session in details.\n";
    }

    private static byte[] hexStringToByteArr(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ":", false);
        byte[] arr = new byte[tokenizer.countTokens()];
        int i = 0;
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            char c1 = token.charAt(0);
            char c2 = token.charAt(1);
            arr[i++] = (byte)(SessionCommand.hexCharToByte(c1) << 4 | SessionCommand.hexCharToByte(c2));
        }
        return arr;
    }

    private static byte hexCharToByte(char c) {
        byte i = 0;
        while (i < hexDigits.length) {
            if (hexDigits[i] == c) {
                return i;
            }
            i = (byte)(i + 1);
        }
        return 0;
    }
}

