/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.dispatcher.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.ssl.dispatcher.RuntimeInterfaceImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class RemoveTrustedCertificateCommand
implements Command {
    private RuntimeInterfaceImpl runtime = null;

    public RemoveTrustedCertificateCommand(RuntimeInterfaceImpl runtime) {
        this.runtime = runtime;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            if (params.length == 1) {
                this.runtime.removeTrustedCertificates("", 0, params[0]);
            } else if (params.length == 3) {
                this.runtime.removeTrustedCertificates(params[0], Integer.parseInt(params[1]), params[2]);
            } else {
                out.println(this.getHelpMessage());
            }
        }
        catch (Exception e) {
            new PrintWriter(env.getErrorStream(), true).println(this.getHelpMessage());
        }
    }

    public String getGroup() {
        return "ssl";
    }

    public String getHelpMessage() {
        return "Removes trusted certificate from an existing socket or from the configuration that will be used for the new sockets.\nUsage: " + this.getName() + " [<host> <port>] <alias>\nParameters:\n\t" + "[<host> <port>] - The host and port of the SSL socket.\n\t" + "<alias> - the alias of the certificate in 'TrustedCAs' keystore view";
    }

    public String getName() {
        return "REMOVE_TRUSTED_CERTIFICATE";
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }
}

