/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.dispatcher.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.ssl.dispatcher.RuntimeInterfaceImpl;
import com.sap.engine.services.ssl.keystore.KeyStoreConnector;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ListCommand
implements Command {
    private RuntimeInterfaceImpl runtime = null;

    public ListCommand(RuntimeInterfaceImpl runtime) {
        this.runtime = runtime;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        block7: {
            PrintWriter out = new PrintWriter(os, true);
            if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
                out.println(this.getHelpMessage());
                return;
            }
            try {
                out.println(KeyStoreConnector.getInformationForActiveSockets());
                if (params.length == 0) {
                    String[] aliases = this.runtime.getTrustedCertificates("", 0);
                    int i = 0;
                    while (i < aliases.length) {
                        out.println(aliases[i]);
                        ++i;
                    }
                    break block7;
                }
                if (params.length == 2) {
                    String[] aliases = this.runtime.getTrustedCertificates(params[0], Integer.parseInt(params[1]));
                    int i = 0;
                    while (i < aliases.length) {
                        out.println(aliases[i]);
                        ++i;
                    }
                    break block7;
                }
                out.println(this.getHelpMessage());
                return;
            }
            catch (Exception e) {
                new PrintWriter(env.getErrorStream(), true).println(this.getHelpMessage());
            }
        }
    }

    public String getGroup() {
        return "ssl";
    }

    public String getHelpMessage() {
        return "Shows all trusted certificates for a specific socket or for the configuration of the new sockets.\nUsage: " + this.getName() + " [<host> <port>]\nParameters\n\t" + "[<host> <port>] - The host and port of the SSL socket.";
    }

    public String getName() {
        return "LIST_TRUSTED_CERTIFICATES";
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }
}

