/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.dispatcher;

import com.sap.engine.frame.cluster.session.PortNamePair;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.services.ssl.dispatcher.CertificateExpirationTracker;
import com.sap.engine.services.ssl.dispatcher.DispatcherService;
import com.sap.engine.services.ssl.dispatcher.RuntimeInterface;
import com.sap.engine.services.ssl.exception.SSLConfigurationException;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.ServerSocket;
import com.sap.engine.services.ssl.factory.ServerSocketFactory;
import com.sap.engine.services.ssl.keystore.KeyStoreConnector;
import com.sap.engine.services.ssl.util.Utility;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RuntimeInterfaceImpl
implements RuntimeInterface {
    private static final String[] COLUMN_NAMES = new String[]{"type", "host", "port", "owner", "keystore entry", "algorithm", "expires in (days)"};
    private static final String SSL_PORT_NOT_AVAILABLE = "ssl_runtime_interface_port_not_available";
    private static final String GET_PORTS_USAGE = "";

    public void addCredentials(String host, int port, String alias) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).addCredentials(alias);
            } else {
                ServerSocketFactory.getServerSocket(host, port).addCredentials(alias);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void addTrustedCertificates(String host, int port, String alias) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).addTrustedCertificates(alias);
            } else {
                ServerSocketFactory.getServerSocket(host, port).addTrustedCertificates(alias);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void addCredentials(String host, int port, String[] aliases) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).addCredentials(aliases);
            } else {
                ServerSocketFactory.getServerSocket(host, port).addCredentials(aliases);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void addTrustedCertificates(String host, int port, String[] aliases) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).addTrustedCertificates(aliases);
            } else {
                ServerSocketFactory.getServerSocket(host, port).addTrustedCertificates(aliases);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void disableCipherSuite(String host, int port, String suite) throws SSLConfigurationException {
        this.disableCipherSuites(host, port, new String[]{suite});
    }

    public void disableCipherSuites(String host, int port, String[] suites) throws SSLConfigurationException {
        String[] current = this.getEnabledCipherSuites(host, port);
        String[] enable = null;
        enable = Utility.remove(suites, current);
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).setDefaultCipherSuites(enable);
            } else {
                ServerSocketFactory.getServerSocket(host, port).setEnabledCipherSuites(enable);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void enableCipherSuite(String host, int port, String suite) throws SSLConfigurationException {
        this.enableCipherSuites(host, port, new String[]{suite});
    }

    public void enableCipherSuites(String host, int port, String[] suites) throws SSLConfigurationException {
        String[] current = null;
        String[] enable = null;
        try {
            current = this.getEnabledCipherSuites(host, port);
            enable = Utility.add(suites, current);
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).setDefaultCipherSuites(enable);
            } else {
                ServerSocketFactory.getServerSocket(host, port).setEnabledCipherSuites(enable);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public String[][] getActiveServerSockets() throws SSLConfigurationException {
        return ServerSocketFactory.getActiveServerSockets();
    }

    public String[] getCredentials(String host, int port) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                return ((ServerSocketFactory)ServerSocketFactory.getDefault()).getCredentials();
            }
            return ServerSocketFactory.getServerSocket(host, port).getCredentials();
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public String[] getTrustedCertificates(String host, int port) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                return ((ServerSocketFactory)ServerSocketFactory.getDefault()).getTrustedCertificates();
            }
            return ServerSocketFactory.getServerSocket(host, port).getTrustedCertificates();
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public String[] getAvailableCertificates(String host, int port) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                return ((ServerSocketFactory)ServerSocketFactory.getDefault()).getAvailableCertificates();
            }
            return ServerSocketFactory.getServerSocket(host, port).getAvailableCertificates();
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public boolean getNeedClientAuth(String host, int port) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                return ((ServerSocketFactory)ServerSocketFactory.getDefault()).getNeedClientAuth();
            }
            return ServerSocketFactory.getServerSocket(host, port).getNeedClientAuth();
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public String[] getSupportedCredentials(String host, int port) throws SSLConfigurationException {
        try {
            String[] names = null;
            Enumeration<String> aliases = null;
            Vector<String> vector = new Vector<String>();
            KeyStore store = null;
            store = KeyStoreConnector.getCredentialsView();
            aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isKeyEntry(alias)) continue;
                vector.add(alias);
            }
            names = new String[vector.size()];
            int i = 0;
            while (i < names.length) {
                names[i] = (String)vector.elementAt(i);
                ++i;
            }
            return names;
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public String[] getEnabledCipherSuites(String host, int port) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                return ((ServerSocketFactory)ServerSocketFactory.getDefault()).getDefaultCipherSuites();
            }
            return ServerSocketFactory.getServerSocket(host, port).getEnabledCipherSuites();
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public String[] getSupportedCipherSuites(String host, int port) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                return ((ServerSocketFactory)ServerSocketFactory.getDefault()).getSupportedCipherSuites();
            }
            return ServerSocketFactory.getServerSocket(host, port).getSupportedCipherSuites();
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void removeCredentials(String host, int port, String alias) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).removeCredentials(alias);
            } else {
                ServerSocketFactory.getServerSocket(host, port).removeCredentials(alias);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void removeTrustedCertificates(String host, int port, String alias) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).removeTrustedCertificates(alias);
            } else {
                ServerSocketFactory.getServerSocket(host, port).removeTrustedCertificates(alias);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void removeCredentials(String host, int port, String[] aliases) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).removeCredentials(aliases);
            } else {
                ServerSocketFactory.getServerSocket(host, port).removeCredentials(aliases);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void removeTrustedCertificates(String host, int port, String[] aliases) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).removeTrustedCertificates(aliases);
            } else {
                ServerSocketFactory.getServerSocket(host, port).removeTrustedCertificates(aliases);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void setCipherSuitePriority(String host, int port, String suite, int priority) throws SSLConfigurationException {
        String[] suites = this.getEnabledCipherSuites(host, port);
        int position = 0;
        try {
            while (position < suites.length) {
                if (suites[position].equals(suite)) break;
                ++position;
            }
            if (priority < 0) {
                priority = 0;
            } else if (priority >= suites.length) {
                priority = suites.length - 1;
            }
            if (position < suites.length) {
                if (position < priority) {
                    System.arraycopy(suites, position + 1, suites, position, priority - position);
                } else if (position > priority) {
                    System.arraycopy(suites, priority, suites, priority + 1, position - priority);
                }
                suites[priority] = suite;
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
        this.setEnabledCipherSuites(host, port, suites);
    }

    public void setCredentials(String host, int port, String[] aliases) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).setCredentials(aliases);
            } else {
                ServerSocketFactory.getServerSocket(host, port).setCredentials(aliases);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void setCredentialsPriority(String host, int port, String alias, int priority) throws SSLConfigurationException {
        String[] credentials = this.getCredentials(host, port);
        int position = 0;
        while (position < credentials.length) {
            if (credentials[position].equals(alias)) break;
            ++position;
        }
        if (priority < 0) {
            priority = 0;
        } else if (priority >= credentials.length) {
            priority = credentials.length - 1;
        }
        if (position < credentials.length) {
            if (position < priority) {
                System.arraycopy(credentials, position + 1, credentials, position, priority - position);
            } else if (position > priority) {
                System.arraycopy(credentials, priority, credentials, priority + 1, position - priority);
            }
            credentials[priority] = alias;
        }
        this.setCredentials(host, port, credentials);
    }

    public void setEnabledCipherSuites(String host, int port, String[] suites) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).setDefaultCipherSuites(suites);
            } else {
                ServerSocketFactory.getServerSocket(host, port).setEnabledCipherSuites(suites);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void setNeedClientAuth(String host, int port, boolean flag) throws SSLConfigurationException {
        try {
            if (GET_PORTS_USAGE.equals(host)) {
                ((ServerSocketFactory)ServerSocketFactory.getDefault()).setNeedClientAuth(flag);
            } else {
                ServerSocketFactory.getServerSocket(host, port).setNeedClientAuth(flag);
            }
        }
        catch (Exception e) {
            throw SSLConfigurationException.wrapException(e, host, port);
        }
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public String getExpirationState() {
        return CertificateExpirationTracker.getExpirationStatus();
    }

    public String[] getExpirationTableHeaders() {
        return COLUMN_NAMES;
    }

    public String[][] getExpirationTableContents() {
        String[][] result = null;
        String[] aliases = null;
        String[][] sockets = ServerSocketFactory.getActiveServerSockets();
        ServerSocket socket = null;
        Vector<Object[]> collection = new Vector<Object[]>(10, 10);
        Hashtable<Object, String> expiration = new Hashtable<Object, String>();
        Hashtable owners = this.getPortsUsage();
        aliases = ((ServerSocketFactory)ServerSocketFactory.getDefault()).getCredentials();
        int j = 0;
        while (j < aliases.length) {
            collection.add(new Object[]{"server identity", aliases[j], null, "New Sockets", "N/A"});
            ++j;
        }
        aliases = ((ServerSocketFactory)ServerSocketFactory.getDefault()).getTrustedCertificates();
        int j2 = 0;
        while (j2 < aliases.length) {
            if (aliases[j2].trim().length() > 0) {
                collection.add(new Object[]{"trusted certification authority", aliases[j2], null, "New Sockets", "N/A"});
            }
            ++j2;
        }
        int i = 0;
        while (i < sockets.length) {
            block18: {
                try {
                    socket = ServerSocketFactory.getServerSocket(sockets[i][0], Integer.valueOf(sockets[i][1]));
                }
                catch (NumberFormatException e) {
                    SSLResourceAccessor.log(400, e, SSL_PORT_NOT_AVAILABLE, new Object[]{sockets[i][0], sockets[i][1]});
                    break block18;
                }
                aliases = socket.getCredentials();
                int j3 = 0;
                while (j3 < aliases.length) {
                    collection.add(new Object[]{"server identity", aliases[j3], socket, sockets[i][0], sockets[i][1]});
                    ++j3;
                }
                aliases = socket.getTrustedCertificates();
                int j4 = 0;
                while (j4 < aliases.length) {
                    if (aliases[j4].trim().length() > 0) {
                        collection.add(new Object[]{"trusted certification authority", aliases[j4], socket, sockets[i][0], sockets[i][1]});
                    }
                    ++j4;
                }
            }
            ++i;
        }
        result = new String[collection.size()][COLUMN_NAMES.length];
        int i2 = 0;
        while (i2 < result.length) {
            Object[] element = (Object[])collection.elementAt(i2);
            result[i2][0] = (String)element[0];
            result[i2][1] = (String)element[3];
            result[i2][2] = (String)element[4];
            result[i2][3] = (String)owners.get(result[i2][2]);
            result[i2][3] = result[i2][3] != null ? result[i2][3] : GET_PORTS_USAGE;
            result[i2][4] = (String)element[1];
            result[i2][5] = CertificateExpirationTracker.getCertificateAlgorithm(result[i2][4]);
            result[i2][6] = (String)expiration.get(element[1]);
            if (result[i2][6] == null) {
                result[i2][6] = String.valueOf(CertificateExpirationTracker.getDaysToExpirationOfCertificate((String)element[1]));
                expiration.put(element[1], result[i2][6]);
            }
            ++i2;
        }
        String[] swap = new String[COLUMN_NAMES.length];
        int i3 = 0;
        while (i3 < result.length - 1) {
            int bestIndex = i3;
            int bestValue = new Integer(result[i3][6]);
            int j5 = i3 + 1;
            while (j5 < result.length) {
                int candidate = new Integer(result[j5][6]);
                if (candidate < bestValue) {
                    bestIndex = j5;
                    bestValue = candidate;
                }
                ++j5;
            }
            if (bestIndex != i3) {
                int k = 0;
                while (k < swap.length) {
                    swap[k] = result[i3][k];
                    ++k;
                }
                int k2 = 0;
                while (k2 < swap.length) {
                    result[i3][k2] = result[bestIndex][k2];
                    ++k2;
                }
                int k3 = 0;
                while (k3 < swap.length) {
                    result[bestIndex][k3] = swap[k3];
                    ++k3;
                }
            }
            ++i3;
        }
        return result;
    }

    private final Hashtable getPortsUsage() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Object portsManager = DispatcherService.getServiceContext().getCoreContext().getReflectContext().getCoreComponent("PortsManager");
            Method usedPortsMethod = portsManager.getClass().getMethod("getUsedPorts", null);
            PortNamePair[] pairs = (PortNamePair[])usedPortsMethod.invoke(portsManager, null);
            int i = 0;
            while (i < pairs.length) {
                result.put(String.valueOf(pairs[i].getPort()), pairs[i].getName());
                ++i;
            }
        }
        catch (Exception e) {
            SSLResourceAccessor.log(400, e, GET_PORTS_USAGE);
            SSLResourceAccessor.traceThrowable(400, GET_PORTS_USAGE, null, e);
        }
        return result;
    }
}

