/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.dispatcher;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.cluster.CommunicationClusterContext;
import com.sap.engine.frame.cluster.transport.TransportContext;
import com.sap.engine.frame.state.PersistentContainer;
import com.sap.engine.services.ssl.dispatcher.DispatcherContainerEventListener;
import com.sap.engine.services.ssl.dispatcher.KeystoreListenerImpl;
import com.sap.engine.services.ssl.dispatcher.RuntimeInterfaceImpl;
import com.sap.engine.services.ssl.dispatcher.command.CommandsContext;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.SSLTransportFactory;
import com.sap.engine.services.ssl.factory.ServerSocket;
import com.sap.engine.services.ssl.factory.session.JSSELimitedCache;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import java.util.HashSet;
import javax.crypto.Cipher;

public class DispatcherService
implements CommunicationServiceFrame {
    private static CommunicationServiceContext serviceContext = null;
    private CommunicationClusterContext clusterContext = null;
    private TransportContext transportContext = null;
    private RuntimeInterfaceImpl runtimeInterface = null;
    private KeystoreListenerImpl keystoreListener = null;
    private DispatcherContainerEventListener containerEventListener = null;
    private TimeoutManager timeout = null;
    public static int RESUME_SESSION_PERIOD = 7200;
    public static int SESSION_CACHE_SIZE = 1000;
    public static String RESUME_SESSION_PROPERTY = "RESUME_SESSION_PERIOD";
    public static String SESSION_CACHE_PROPERTY = "SESSION_CACHE_SIZE";
    public static int HANDSHAKE_SO_TIMEOUT = 30000;
    public static int RUNTIME_SO_TIMEOUT = 30000;
    public static String HANDSHAKE_SO_TIMEOUT_PROPERTY = "HANDSHAKE_SO_TIMEOUT";
    public static String RUNTIME_SO_TIMEOUT_PROPERTY = "RUNTIME_SO_TIMEOUT";
    private static final String NO_FULL_IAIK_JCE = "ssl_disp_no_full_iaik_jce";
    private static final String NO_KEYSTORE = "ssl_disp_no_running_keystore";
    private static final String UNEXPECTED_SERVICE_EXCEPTION = "ssl_disp_unexpected_service_exception";

    public void start(CommunicationServiceContext sdc) throws ServiceException {
        try {
            SSLResourceAccessor.getResourceAccessor();
            try {
                Cipher.getInstance("RSA");
            }
            catch (Exception e) {
                SSLResourceAccessor.log(600, e, NO_FULL_IAIK_JCE);
                SSLResourceAccessor.traceThrowable(600, SSLResourceAccessor.getDescription(NO_FULL_IAIK_JCE, null), e);
                throw new ServiceException(SSLResourceAccessor.getLocalizableMessage(NO_FULL_IAIK_JCE, null));
            }
            serviceContext = sdc;
            ServerSocket.setInetAddress(sdc.getClusterContext().getClusterMonitor().getCurrentParticipant().getAddress());
            RESUME_SESSION_PERIOD = Integer.parseInt(sdc.getServiceState().getProperty(RESUME_SESSION_PROPERTY, new Integer(7200).toString()));
            SESSION_CACHE_SIZE = Integer.parseInt(sdc.getServiceState().getProperty(SESSION_CACHE_PROPERTY, new Integer(1000).toString()));
            this.timeout = (TimeoutManager)serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("timeout");
            this.timeout.registerTimeoutListener((TimeoutListener)JSSELimitedCache.initialize(SESSION_CACHE_SIZE, RESUME_SESSION_PERIOD), 300000L, 300000L);
            HANDSHAKE_SO_TIMEOUT = Integer.parseInt(sdc.getServiceState().getProperty(HANDSHAKE_SO_TIMEOUT_PROPERTY, new Integer(10000).toString()));
            RUNTIME_SO_TIMEOUT = Integer.parseInt(sdc.getServiceState().getProperty(RUNTIME_SO_TIMEOUT_PROPERTY, new Integer(3000).toString()));
            this.clusterContext = sdc.getClusterContext();
            this.transportContext = this.clusterContext.getTransportContext();
            if (sdc.getContainerContext().getObjectRegistry().getServiceInterface("keystore") == null) {
                SSLResourceAccessor.log(600, "", NO_KEYSTORE);
                throw new ServiceException(SSLResourceAccessor.getLocalizableMessage(NO_KEYSTORE, null));
            }
            this.runtimeInterface = new RuntimeInterfaceImpl();
            this.containerEventListener = new DispatcherContainerEventListener(new CommandsContext(this.runtimeInterface).getAvailableCommands(), sdc.getContainerContext().getObjectRegistry());
            int mask = 192;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            sdc.getServiceState().registerContainerEventListener(mask, names, this.containerEventListener);
            serviceContext.getServiceState().registerManagementInterface(this.runtimeInterface);
            this.keystoreListener = new KeystoreListenerImpl(this.transportContext, sdc.getCoreContext().getThreadSystem());
            this.keystoreListener.keystoreIsAvailable();
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            SSLResourceAccessor.log(600, e, UNEXPECTED_SERVICE_EXCEPTION);
            SSLResourceAccessor.traceThrowable(600, SSLResourceAccessor.getMessage(UNEXPECTED_SERVICE_EXCEPTION), e);
            this.stop();
            throw new ServiceException(UNEXPECTED_SERVICE_EXCEPTION, null, e);
        }
    }

    public void stop() throws ServiceRuntimeException {
        this.timeout.unregisterTimeoutListener((TimeoutListener)JSSELimitedCache.getInstance());
        JSSELimitedCache.stop();
        this.containerEventListener.stop();
        serviceContext.getServiceState().unregisterContainerEventListener();
        SSLTransportFactory.stop();
        this.keystoreListener.stop();
    }

    public static PersistentContainer getPersistentContainer() {
        return serviceContext.getServiceState().getPersistentContainer();
    }

    public static CommunicationServiceContext getServiceContext() {
        return serviceContext;
    }
}

