/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.dispatcher;

import com.sap.engine.services.ssl.dispatcher.SSLPortsConfiguration;
import com.sap.engine.services.ssl.exception.KeyStoreConnectorException;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.Credentials;
import com.sap.engine.services.ssl.keystore.KeyStoreConnector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertificateExpirationTracker {
    private static final String STATE_UNKNOWN = "N/A";
    private static final String STATE_EXPIRES_AFTER_A_YEAR = "No certificates expire in a year time.";
    private static final String STATE_EXPIRES_IN_A_YEAR = "At least one certificate expires in less than 1 year.";
    private static final String STATE_EXPIRES_IN_3_MONTHS = "At least one certificate expires in less than 3 months.";
    private static final String STATE_EXPIRES_IN_1_MONTH = "At least one certificate expires in less than 1 month.";
    private static final String STATE_EXPIRES_IN_1_WEEK = "At least one certificate expires in less than 1 week.";
    private static final String STATE_EXPIRES_IN_5_DAYS = "At least one certificate expires in less than 5 days.";
    private static final String STATE_EXPIRES_IN_4_DAYS = "At least one certificate expires in less than 4 days.";
    private static final String STATE_EXPIRES_IN_3_DAYS = "At least one certificate expires in less than 3 days.";
    private static final String STATE_EXPIRES_IN_2_DAYS = "At least one certificate expires in less than 2 days.";
    private static final String STATE_EXPIRES_IN_1_DAY = "At least one certificate expires in less than 1 day.";
    private static final String STATE_EXPIRED = "At least one certificate has already expired.";
    private static final String STATE_MISSING_CERTIFICATES = "Missing certificates in keystore.";
    private static final String GET_CERTIFICATE_ERROR = "ssl_cert_expiration_tracker_GET_CERTIFICATE_ERROR";
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_MONTH = 2678400000L;
    private static final long ONE_YEAR = 31536000000L;
    private static long lastExpirationCheck = 0L;
    private static String expirationStatus = "N/A";

    public static String getExpirationStatus() {
        CertificateExpirationTracker.checkExpiration();
        return expirationStatus;
    }

    public static int getDaysToExpirationOfCertificate(String alias) {
        try {
            long currentTime = System.currentTimeMillis();
            Certificate certificate = null;
            certificate = CertificateExpirationTracker.getCertificate(alias);
            if (certificate instanceof X509Certificate) {
                X509Certificate x509certificate = (X509Certificate)certificate;
                if (CertificateExpirationTracker.differenceNotBefore(x509certificate.getNotBefore(), currentTime, 0L) == -1L) {
                    return 0;
                }
                return (int)(CertificateExpirationTracker.differenceNotAfter(x509certificate.getNotAfter(), currentTime, Long.MAX_VALUE) / 86400000L);
            }
        }
        catch (KeyStoreConnectorException ksce) {
            SSLResourceAccessor.log(500, ksce, GET_CERTIFICATE_ERROR, new Object[]{alias});
            SSLResourceAccessor.traceThrowable(500, GET_CERTIFICATE_ERROR, new Object[]{alias}, ksce);
            expirationStatus = STATE_MISSING_CERTIFICATES;
        }
        return -1;
    }

    public static final String getCertificateAlgorithm(String alias) {
        Certificate certificate = CertificateExpirationTracker.getCertificate(alias);
        if (certificate != null) {
            return certificate.getPublicKey().getAlgorithm();
        }
        return STATE_UNKNOWN;
    }

    public static void portsConfigurationChanged() {
        lastExpirationCheck = 0L;
    }

    private static final Certificate getCertificate(String alias) {
        Credentials credentials;
        Certificate result = KeyStoreConnector.getCertificate(alias);
        if (result == null && (credentials = KeyStoreConnector.getCredentials(alias)) != null) {
            result = credentials.getCertificateChain()[0];
        }
        return result;
    }

    private static void checkExpiration() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < lastExpirationCheck + 43200000L) {
            return;
        }
        lastExpirationCheck = currentTime;
        long difference = Long.MAX_VALUE;
        String[] aliases = SSLPortsConfiguration.getUsedCredentialAliases();
        Certificate certificate = null;
        int i = 0;
        while (i < aliases.length) {
            try {
                certificate = CertificateExpirationTracker.getCertificate(aliases[i]);
            }
            catch (KeyStoreConnectorException ksce) {
                SSLResourceAccessor.log(500, ksce, GET_CERTIFICATE_ERROR, new Object[]{aliases[i]});
                SSLResourceAccessor.traceThrowable(500, GET_CERTIFICATE_ERROR, new Object[]{aliases[i]}, ksce);
                expirationStatus = STATE_MISSING_CERTIFICATES;
                return;
            }
            if (certificate instanceof X509Certificate) {
                X509Certificate x509certificate = (X509Certificate)certificate;
                difference = CertificateExpirationTracker.differenceNotBefore(x509certificate.getNotBefore(), currentTime, difference);
                difference = CertificateExpirationTracker.differenceNotAfter(x509certificate.getNotAfter(), currentTime, difference);
            }
            ++i;
        }
        expirationStatus = difference < 0L ? STATE_EXPIRED : (difference < 86400000L ? STATE_EXPIRES_IN_1_DAY : (difference < 172800000L ? STATE_EXPIRES_IN_2_DAYS : (difference < 259200000L ? STATE_EXPIRES_IN_3_DAYS : (difference < 345600000L ? STATE_EXPIRES_IN_4_DAYS : (difference < 432000000L ? STATE_EXPIRES_IN_5_DAYS : (difference < 604800000L ? STATE_EXPIRES_IN_1_WEEK : (difference < 2678400000L ? STATE_EXPIRES_IN_1_MONTH : (difference < 8035200000L ? STATE_EXPIRES_IN_3_MONTHS : (difference < 31536000000L ? STATE_EXPIRES_IN_A_YEAR : STATE_EXPIRES_AFTER_A_YEAR)))))))));
    }

    private static final long differenceNotBefore(Date notBefore, long current, long lastBest) {
        return current < notBefore.getTime() ? -1L : lastBest;
    }

    private static final long differenceNotAfter(Date notAfter, long current, long lastBest) {
        long notAfterValue = notAfter.getTime();
        if (current > notAfterValue) {
            return -1L;
        }
        long currentValue = notAfterValue - current;
        return currentValue < lastBest ? currentValue : lastBest;
    }
}

