/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.gui.CListDialog;
import com.sap.engine.services.ssl.admin.DispatcherRuntimeControl;
import com.sap.engine.services.ssl.admin.ExceptionHandler;
import com.sap.engine.services.ssl.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class TrustedCertificates
implements ActionListener {
    private DispatcherRuntimeControl control;
    private String host = "";
    private int port = 0;
    private int needClientAuth = -1;
    private JPanel certificatePane;
    private JList enabledList;
    private JButton enableButton;
    private JButton disableButton;
    private CListDialog supportedCertsDlg;
    private JRadioButton dontRequestCertificate = null;
    private JRadioButton requestCertificate = null;
    private JRadioButton requireCertificate = null;
    private ButtonGroup buttons = null;
    private JPanel cardsPanel = null;

    public TrustedCertificates(DispatcherRuntimeControl control) {
        this.control = control;
        this.supportedCertsDlg = new CListDialog(null, "Available Certificates");
        ((Component)this.supportedCertsDlg).setSize(new Dimension(400, 300));
        this.supportedCertsDlg.setTitle(" Certificates ");
        this.certificatePane = new JPanel(new BorderLayout());
        JPanel checkboxes = new JPanel(new GridLayout(3, 1));
        this.buttons = new ButtonGroup();
        this.dontRequestCertificate = new JRadioButton("Do not request client certificate");
        this.dontRequestCertificate.addActionListener(this);
        this.buttons.add(this.dontRequestCertificate);
        checkboxes.add(this.dontRequestCertificate);
        this.requestCertificate = new JRadioButton("Request client certificate");
        this.requestCertificate.addActionListener(this);
        this.buttons.add(this.requestCertificate);
        checkboxes.add(this.requestCertificate);
        this.requireCertificate = new JRadioButton("Require client certificate");
        this.requireCertificate.addActionListener(this);
        this.buttons.add(this.requireCertificate);
        checkboxes.add(this.requireCertificate);
        this.certificatePane.add((Component)checkboxes, "North");
        this.cardsPanel = new JPanel();
        this.cardsPanel.setLayout(new CardLayout());
        this.cardsPanel.add((Component)new JLabel(""), "no");
        JPanel temp = new JPanel(new BorderLayout());
        this.enabledList = new JList(new Vector());
        JScrollPane enabledListPane = new JScrollPane();
        enabledListPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Trusted Certification Authorities "));
        enabledListPane.getViewport().add(this.enabledList);
        temp.add((Component)enabledListPane, "Center");
        JPanel buttonPane = new JPanel(new GridBagLayout());
        this.enableButton = new JButton("Add");
        this.enableButton.addActionListener(this);
        buttonPane.add((Component)this.enableButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.disableButton = new JButton("Remove");
        this.disableButton.addActionListener(this);
        buttonPane.add((Component)this.disableButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttonPane.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        temp.add((Component)buttonPane, "East");
        this.cardsPanel.add((Component)temp, "trust");
        this.certificatePane.add((Component)this.cardsPanel, "Center");
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, "no");
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        String[] stringValues;
        Object[] values;
        boolean changed = false;
        if (e.getSource() == this.enableButton) {
            if (this.supportedCertsDlg.showDialog()) {
                values = this.supportedCertsDlg.getSelected();
                stringValues = new String[values.length];
                i = 0;
                while (i < values.length) {
                    stringValues[i] = values[i].toString();
                    ++i;
                }
                try {
                    this.control.getRuntime().addTrustedCertificates(this.host, this.port, stringValues);
                    changed = true;
                }
                catch (Exception esc) {
                    ExceptionHandler.error("Unable to add trusted CA.", esc);
                }
            }
            this.changeNeedClientAuthentication();
        }
        if (e.getSource() == this.disableButton) {
            values = this.enabledList.getSelectedValues();
            stringValues = new String[values.length];
            i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].toString();
                ++i;
            }
            try {
                this.control.getRuntime().removeTrustedCertificates(this.host, this.port, stringValues);
                changed = true;
            }
            catch (Exception exc) {
                ExceptionHandler.error("Unable to remove trusted CA.", exc);
            }
            this.changeNeedClientAuthentication();
        }
        if (e.getSource() == this.dontRequestCertificate) {
            this.certificateChoice(0);
        }
        if (e.getSource() == this.requestCertificate) {
            this.certificateChoice(1);
        }
        if (e.getSource() == this.requireCertificate) {
            this.certificateChoice(2);
        }
        if (changed) {
            this.control.onAction(this.host, this.port, 5);
        }
    }

    public void getProperties(String name) {
        JOptionPane.showMessageDialog(this.certificatePane, name, "Properties", -1);
    }

    public JPanel getCertificatePane() {
        return this.certificatePane;
    }

    public void refresh(String host, int port) {
        if (port != this.port) {
            this.setServerSocket(host, port);
        }
        try {
            int type = 2;
            Vector trusted = Utility.stringArrayToVector(this.control.getRuntime().getTrustedCertificates(host, port));
            if (trusted.contains("")) {
                type = 1;
            }
            trusted.remove("");
            if (trusted.size() == 0) {
                trusted.add(" Add trusted certification authorities!");
                trusted.add(" If no certificates are added no client");
                trusted.add(" certificate will be requested! ");
                this.disableButton.setEnabled(false);
                type = 0;
            } else {
                this.disableButton.setEnabled(true);
            }
            this.enabledList.setListData(trusted);
            if (!this.control.getRuntime().getNeedClientAuth(host, port)) {
                type = 0;
            }
            this.supportedCertsDlg.initList(this.control.getRuntime().getAvailableCertificates(host, port));
            this.viewSelection(type);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh list of trusted CAs.", e);
        }
    }

    public void setServerSocket(String host, int port) {
        this.changeNeedClientAuthentication();
        this.needClientAuth = -1;
        this.host = host;
        this.port = port;
    }

    private void certificateChoice(int i) {
        this.needClientAuth = i;
        this.changeNeedClientAuthentication();
        this.refresh(this.host, this.port);
        this.viewSelection(i);
    }

    private void changeNeedClientAuthentication() {
        try {
            Vector trusted = Utility.stringArrayToVector(this.control.getRuntime().getTrustedCertificates(this.host, this.port));
            trusted.remove("");
            if (trusted.size() == 0) {
                this.changeClientAuthOnServer(0);
            } else if (this.needClientAuth >= 0) {
                this.changeClientAuthOnServer(this.needClientAuth);
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh list of trusted CAs.", e);
        }
    }

    private void changeClientAuthOnServer(int i) {
        switch (i) {
            case 0: {
                this.control.getRuntime().setNeedClientAuth(this.host, this.port, false);
                break;
            }
            case 1: {
                this.control.getRuntime().setNeedClientAuth(this.host, this.port, true);
                this.control.getRuntime().addTrustedCertificates(this.host, this.port, "");
                break;
            }
            case 2: {
                this.control.getRuntime().setNeedClientAuth(this.host, this.port, true);
                try {
                    this.control.getRuntime().removeTrustedCertificates(this.host, this.port, "");
                }
                catch (Exception e) {
                    ExceptionHandler.debug("Expected exception:", e);
                }
                break;
            }
        }
    }

    private void viewSelection(int type) {
        switch (type) {
            case 0: {
                ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, "no");
                this.dontRequestCertificate.setSelected(true);
                break;
            }
            case 1: {
                ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, "trust");
                this.requestCertificate.setSelected(true);
                break;
            }
            case 2: {
                ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, "trust");
                this.requireCertificate.setSelected(true);
            }
        }
    }
}

