/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.gui.CListDialog;
import com.sap.engine.services.ssl.admin.DispatcherRuntimeControl;
import com.sap.engine.services.ssl.admin.ExceptionHandler;
import com.sap.engine.services.ssl.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Suites
implements ActionListener {
    private DispatcherRuntimeControl control;
    private String host = "";
    private int port = 0;
    private JPanel suitesPane;
    private JList enabledList;
    private JButton upButton;
    private JButton downButton;
    private JButton enableButton;
    private JButton disableButton;
    private JScrollPane scrollPane;
    private CListDialog supportedSuitesDlg;

    public Suites(DispatcherRuntimeControl control) {
        this.control = control;
        this.supportedSuitesDlg = new CListDialog(null, "Supported Suites");
        ((Component)this.supportedSuitesDlg).setSize(new Dimension(400, 300));
        this.supportedSuitesDlg.setTitle(" Suites ");
        this.suitesPane = new JPanel(new BorderLayout());
        this.suitesPane.setAutoscrolls(true);
        JPanel buttonPane = new JPanel(new GridBagLayout());
        this.upButton = new JButton("Priority Up");
        this.upButton.addActionListener(this);
        buttonPane.add((Component)this.upButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.downButton = new JButton("Priority Down");
        this.downButton.addActionListener(this);
        buttonPane.add((Component)this.downButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.enableButton = new JButton("Add");
        this.enableButton.addActionListener(this);
        buttonPane.add((Component)this.enableButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.disableButton = new JButton("Remove");
        this.disableButton.addActionListener(this);
        buttonPane.add((Component)this.disableButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPane.add((Component)new JPanel(), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.suitesPane.add((Component)buttonPane, "East");
        this.enabledList = new JList(new Vector());
        this.scrollPane = new JScrollPane(this.enabledList);
        this.scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Enabled Suites "));
        this.suitesPane.add((Component)this.scrollPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        String[] stringValues;
        Object[] values;
        int index = 0;
        boolean listDataChanged = false;
        boolean moved = false;
        Object selected = null;
        if (e.getSource() == this.enableButton && this.supportedSuitesDlg.showDialog()) {
            values = this.supportedSuitesDlg.getSelected();
            stringValues = new String[values.length];
            i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].toString();
                ++i;
            }
            try {
                this.control.getRuntime().enableCipherSuites(this.host, this.port, stringValues);
                listDataChanged = true;
            }
            catch (Exception exc) {
                ExceptionHandler.error("Unable to enable cipher suites for the given port.", exc);
            }
        }
        if (e.getSource() == this.disableButton) {
            values = this.enabledList.getSelectedValues();
            stringValues = new String[values.length];
            i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].toString();
                ++i;
            }
            try {
                this.control.getRuntime().disableCipherSuites(this.host, this.port, stringValues);
                listDataChanged = true;
            }
            catch (Exception exc) {
                ExceptionHandler.error("Unable to disable cipher suites for the given port.", exc);
            }
        }
        if (e.getSource() == this.upButton) {
            selected = this.enabledList.getSelectedValue();
            index = this.enabledList.getSelectedIndex();
            if (index > 0) {
                try {
                    this.control.getRuntime().setCipherSuitePriority(this.host, this.port, selected.toString(), index - 1);
                    if (index <= this.enabledList.getFirstVisibleIndex()) {
                        this.scrollPane.getViewport().setViewPosition(this.enabledList.indexToLocation(index - 1));
                    } else if (index >= this.enabledList.getLastVisibleIndex()) {
                        this.scrollPane.getViewport().setViewPosition(this.enabledList.indexToLocation(index - this.enabledList.getVisibleRowCount()));
                    }
                    moved = true;
                }
                catch (Exception exc) {
                    ExceptionHandler.error("Unable to change cipher suites configuration for the given port.", exc);
                }
            }
        }
        if (e.getSource() == this.downButton) {
            selected = this.enabledList.getSelectedValue();
            index = this.enabledList.getSelectedIndex();
            if (index >= 0) {
                try {
                    this.control.getRuntime().setCipherSuitePriority(this.host, this.port, selected.toString(), index + 1);
                }
                catch (Exception exc) {
                    ExceptionHandler.error("Unable to change cipher suites configuration for the give port.", exc);
                    return;
                }
                if (index < this.enabledList.getFirstVisibleIndex()) {
                    this.scrollPane.getViewport().setViewPosition(this.enabledList.indexToLocation(index - 1));
                } else if (index + 1 >= this.enabledList.getLastVisibleIndex()) {
                    this.scrollPane.getViewport().setViewPosition(this.enabledList.indexToLocation(index - this.enabledList.getVisibleRowCount() + 2));
                }
                moved = true;
            }
        }
        if (listDataChanged) {
            this.control.onAction(this.host, this.port, 4);
        }
        if (moved) {
            this.control.onAction(this.host, this.port, 4);
            this.enabledList.setSelectedValue(selected, true);
        }
    }

    public void getCipherProperties(String name) {
        JOptionPane.showMessageDialog(this.suitesPane, name, "Properties", -1);
    }

    public JPanel getSuitesPane() {
        return this.suitesPane;
    }

    public void refresh(String host, int port) {
        try {
            this.enabledList.setListData(Utility.stringArrayToVector(this.control.getRuntime().getEnabledCipherSuites(host, port)));
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh enabled cipher suites.", e);
        }
    }

    public void refreshSupportedList(String host, int port) {
        try {
            this.supportedSuitesDlg.initList(this.control.getRuntime().getSupportedCipherSuites(host, port));
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh supported cipher suites.", e);
        }
    }

    public void setServerSocket(String host, int port) {
        this.host = host;
        this.port = port;
    }
}

