/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.ssl.admin.DispatcherRuntimeControl;
import com.sap.engine.services.ssl.admin.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RuntimeControl
extends JPanel
implements VisualRuntimeControl,
ListSelectionListener {
    Hashtable table = new Hashtable();
    JSplitPane splitPane = null;
    Vector dispatchers = new Vector(10, 10);
    JList dispatchersList = null;
    Frame frame = null;

    public RuntimeControl() {
        this.setLayout(new BorderLayout());
        this.dispatchersList = new JList(this.dispatchers);
        this.dispatchersList.setSelectionMode(0);
        this.dispatchersList.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane();
        listScrollPane.getViewport().add(this.dispatchersList);
        listScrollPane.setMinimumSize(new Dimension(100, 0));
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(listScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)this.splitPane, "Center");
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
        ExceptionHandler.setViewer(environment);
    }

    public void show(ManagementInterface serviceRuntimeInterface) {
        int[] ids = null;
        try {
            ids = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeIds();
            int i = 0;
            while (i < ids.length) {
                if (ClusterTreeGenerator.convenienceAdministrator.getClusterNodeType(ids[i]) == 1 && ClusterTreeGenerator.serviceAdministrator.getDescriptor(ids[i], "ssl").getStatus() == 5) {
                    String name = ClusterTreeGenerator.convenienceAdministrator.getClusterNodeName(ids[i]);
                    this.table.put(name, new Integer(ids[i]));
                    this.dispatchers.add(name);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to retrieve list of communication cluster elements.", e);
        }
        JPanel empty = new JPanel();
        if (this.dispatchers.size() == 0) {
            empty.add(new JLabel("  A communication container with running SSL service not found!   "));
        } else {
            empty.add(new JLabel(" Select a communication container from the list. "));
        }
        this.splitPane.setRightComponent(empty);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        String selectedName = (String)this.dispatchersList.getSelectedValue();
        if (selectedName != null) {
            DispatcherRuntimeControl control = null;
            Object raw = this.table.get(selectedName);
            if (raw instanceof DispatcherRuntimeControl) {
                control = (DispatcherRuntimeControl)raw;
            } else if (raw instanceof Integer) {
                control = new DispatcherRuntimeControl();
                try {
                    int id = (Integer)this.table.get(selectedName);
                    control.setFrame(this.frame);
                    control.show(ClusterTreeGenerator.managementInterfaceProxyFactory.generateManagementInterfaceProxy(id, "ssl"));
                }
                catch (Exception exception) {
                    ExceptionHandler.error("Unable to obtain management interface for the communication cluster elements.", exception);
                }
            }
            if (control != null) {
                this.splitPane.setRightComponent(control);
                control.validate();
                this.splitPane.validate();
                control.validate();
            }
        }
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return null;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        ExceptionHandler.setParentComponent(frame);
    }

    public void freeResources() {
    }

    public void setTaskManager(EditorViewManager manager) {
    }
}

