/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.ssl.admin.ExceptionTask;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public class ExceptionHandler {
    private static Component parentComponent;
    private static EditorViewManager viewer;

    public static void debug(String message, Throwable throwable) {
        if (System.getProperty("debug") != null) {
            if (message != null) {
                System.err.println("[ssl gui] " + message);
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static void error(String message, Throwable throwable) {
        ExceptionHandler.show(0, parentComponent, message, throwable);
    }

    public static void error(Component parentComponent, String message, Throwable throwable) {
        ExceptionHandler.show(0, parentComponent, message, throwable);
    }

    public static void information(String message, Throwable throwable) {
        ExceptionHandler.show(1, parentComponent, message, throwable);
    }

    public static void information(Component parentComponent, String message, Throwable throwable) {
        ExceptionHandler.show(1, parentComponent, message, throwable);
    }

    public static void warning(String message, Throwable throwable) {
        ExceptionHandler.show(2, parentComponent, message, throwable);
    }

    public static void warning(Component parentComponent, String message, Throwable throwable) {
        ExceptionHandler.show(2, parentComponent, message, throwable);
    }

    public static boolean confirmation(String message, String title) {
        return ExceptionHandler.confirm(parentComponent, message, title);
    }

    protected static void setViewer(Object viewer) {
        if (viewer instanceof EditorViewManager) {
            ExceptionHandler.viewer = (EditorViewManager)viewer;
        }
    }

    protected static void setParentComponent(Component parentComponent) {
        ExceptionHandler.parentComponent = parentComponent;
    }

    private static final String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    private static final void show(int type, Component parentComponent, String message, Throwable throwable) {
        String title = message;
        if (parentComponent == null) {
            parentComponent = ExceptionHandler.parentComponent;
        }
        if (viewer != null && throwable != null) {
            viewer.addTask(new ExceptionTask(message, ExceptionHandler.getStackTrace(throwable)));
            message = message + "\n\nDetails are available in status bar.";
        } else {
            ExceptionHandler.debug(message, throwable);
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, type);
    }

    private static final boolean confirm(Component parentComponent, String message, String title) {
        int confirmed;
        if (parentComponent == null) {
            parentComponent = ExceptionHandler.parentComponent;
        }
        return (confirmed = JOptionPane.showConfirmDialog(parentComponent, message, title, 2)) == 0 || confirmed == 0;
    }
}

