/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.ssl.admin.Certificates;
import com.sap.engine.services.ssl.admin.Configuration;
import com.sap.engine.services.ssl.admin.ExceptionHandler;
import com.sap.engine.services.ssl.admin.Suites;
import com.sap.engine.services.ssl.admin.TrustedCertificates;
import com.sap.engine.services.ssl.dispatcher.RuntimeInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DispatcherRuntimeControl
extends JPanel
implements VisualRuntimeControl {
    public static final int CONFIGURATION = 1;
    public static final int CONFIG = 2;
    public static final int CERTIFICATES = 3;
    public static final int SUITES = 4;
    public static final int TRUSTED_CERTIFICATES = 5;
    private RuntimeInterface runtime = null;
    private Configuration configuration;
    private Certificates certificates;
    private TrustedCertificates trustedCertificates;
    private Suites suites;

    public DispatcherRuntimeControl() {
        this.setLayout(new BorderLayout());
        this.configuration = new Configuration(this);
        this.configuration.getSocketPane().setPreferredSize(new Dimension(0, 300));
        this.add((Component)this.configuration.getSocketPane(), "North");
        JTabbedPane pane = new JTabbedPane();
        this.suites = new Suites(this);
        this.certificates = new Certificates(this);
        this.trustedCertificates = new TrustedCertificates(this);
        pane.addTab("Cipher Suite", this.suites.getSuitesPane());
        pane.addTab("Server Identity", this.certificates.getCertificatePane());
        pane.addTab("Client Authentication", this.trustedCertificates.getCertificatePane());
        this.add((Component)pane, "Center");
    }

    Certificates getCertificates() {
        return this.certificates;
    }

    TrustedCertificates getTrustedCertificates() {
        return this.trustedCertificates;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        ExceptionHandler.setViewer(environment);
    }

    public void show(ManagementInterface serviceRuntimeInterface) {
        this.runtime = (RuntimeInterface)serviceRuntimeInterface;
        this.configuration.refresh();
    }

    public void onAction(String host, int port, int source) {
        switch (source) {
            case 2: {
                this.certificates.refreshAvailableList(host, port);
                this.certificates.refresh(host, port);
                this.trustedCertificates.refresh(host, port);
                this.suites.refreshSupportedList(host, port);
                this.suites.refresh(host, port);
                break;
            }
            case 1: {
                this.certificates.refresh(host, port);
                this.trustedCertificates.refresh(host, port);
                this.suites.refreshSupportedList(host, port);
                this.suites.refresh(host, port);
                this.setServerSocket(host, port);
                break;
            }
            case 3: {
                this.certificates.refresh(host, port);
                this.suites.refreshSupportedList(host, port);
                this.suites.refresh(host, port);
                break;
            }
            case 4: {
                this.suites.refresh(host, port);
                break;
            }
            case 5: {
                this.trustedCertificates.refresh(host, port);
                break;
            }
        }
    }

    public RuntimeInterface getRuntime() {
        return this.runtime;
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return new JButton[0];
    }

    public void setFrame(Frame frame) {
        ExceptionHandler.setParentComponent(frame);
    }

    public void freeResources() {
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    private void setServerSocket(String host, int port) {
        this.certificates.setServerSocket(host, port);
        this.trustedCertificates.setServerSocket(host, port);
        this.suites.setServerSocket(host, port);
    }
}

