/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.xml;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.servlets_jsp.descriptor.AuthenticationDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.CookieConfig;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWrongStructureException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AdditionalWebDescrDocument {
    public static final String dtd = "<!DOCTYPE web-j2ee-engine SYSTEM 'web-j2ee-engine.dtd'>";
    private Document mainDocument;
    private boolean hasElements = false;

    public AdditionalWebDescrDocument() {
    }

    public AdditionalWebDescrDocument(WebDeploymentDescriptor descriptor) throws ParserConfigurationException {
        this.loadDocumentFromDescriptor(descriptor);
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document document) {
        this.mainDocument = document;
    }

    public boolean needsLoad() {
        return this.hasElements;
    }

    public Document loadDocumentFromDescriptor(WebDeploymentDescriptor descr) {
        if (descr == null) {
            return null;
        }
        this.mainDocument = StandardDOMParser.createDocument();
        try {
            this.mainDocument.appendChild(this.loadDocumentElement(descr));
        }
        catch (ParserConfigurationException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0254", e);
        }
        return this.mainDocument;
    }

    private Element loadDocumentElement(WebDeploymentDescriptor descr) throws ParserConfigurationException {
        Element docElement = null;
        docElement = this.mainDocument.createElement("web-j2ee-engine");
        this.loadResourceReferences(docElement, descr.getResReferences());
        this.loadResourceEnvReferences(docElement, descr.getResEnvReferences());
        this.loadEJBReferences(docElement, descr.getEjbRefs());
        this.loadEJBLocalReferences(docElement, descr.getEjbLocalRefs());
        this.loadComponentReferences(docElement, descr.getServerComponentRefs());
        this.loadSecurityRoles(docElement, descr.getSecRoles());
        this.loadResponseStatus(docElement, descr.getResponseStatus());
        this.loadFailOverAlert(docElement, descr.getFailOverMessage(), descr.getFailOverMessageTimeout());
        AuthenticationDescriptor auth = descr.getAuthentication();
        if (auth != null) {
            auth.setMainDocument(this.mainDocument);
            docElement.appendChild(auth.loadElementFromDescriptor());
            this.hasElements = true;
        }
        if (descr.getURLSessionTracking()) {
            this.load(docElement, null, "url-session-tracking");
            this.hasElements = true;
        }
        if (descr.getGetRequestURLMode() != null && !descr.getGetRequestURLMode().equalsIgnoreCase("REQUEST-DISPATCHER")) {
            this.load(docElement, descr.getGetRequestURLMode(), "get-request-url-mode");
            this.hasElements = true;
        }
        if (descr.getSecurityPolicyDomain() != null && !descr.getSecurityPolicyDomain().equals("")) {
            this.load(docElement, descr.getSecurityPolicyDomain(), "security-policy-domain");
            this.hasElements = true;
        }
        if (descr.getMaxSessions() > -1) {
            this.load(docElement, String.valueOf(descr.getMaxSessions()), "max-sessions");
            this.hasElements = true;
        }
        if (descr.getCookieConfig() != null) {
            this.loadCookieConfig(docElement, descr.getCookieConfig());
            this.hasElements = true;
        }
        return docElement;
    }

    private void loadResourceReferences(Element docEl, ResourceReference[] resRefs) {
        if (resRefs == null || resRefs.length == 0) {
            return;
        }
        Element tempEl = null;
        int i = 0;
        while (i < resRefs.length) {
            if (resRefs[i] != null) {
                tempEl = this.mainDocument.createElement("resource-ref");
                if (resRefs[i].getResourceName() != null && !resRefs[i].getResourceName().equals("")) {
                    this.load(tempEl, resRefs[i].getResourceName(), "res-ref-name");
                    if (resRefs[i].getResourceLink() != null && !resRefs[i].getResourceLink().equals("")) {
                        this.load(tempEl, resRefs[i].getResourceLink(), "res-link");
                        this.hasElements = true;
                    }
                    if (!resRefs[i].isTransactional()) {
                        this.load(tempEl, null, "non-transactional");
                    }
                    docEl.appendChild(tempEl);
                }
            }
            ++i;
        }
    }

    private void loadResourceEnvReferences(Element docEl, ResourceEnvReference[] resRefs) {
        if (resRefs == null || resRefs.length == 0) {
            return;
        }
        Element tempEl = null;
        int i = 0;
        while (i < resRefs.length) {
            if (resRefs[i] != null && resRefs[i].getJndiName() != null) {
                tempEl = this.mainDocument.createElement("resource-env-ref");
                if (resRefs[i].getName() != null && !resRefs[i].getName().equals("")) {
                    this.load(tempEl, resRefs[i].getName(), "resource-env-ref-name");
                    if (resRefs[i].getJndiName() != null && !resRefs[i].getJndiName().equals("")) {
                        this.load(tempEl, resRefs[i].getJndiName(), "jndi-name");
                        this.hasElements = true;
                    }
                    docEl.appendChild(tempEl);
                }
            }
            ++i;
        }
    }

    private void loadEJBReferences(Element docEl, EJBeanReference[] ejbRefs) {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        Element tempEl = null;
        int i = 0;
        while (i < ejbRefs.length) {
            if (ejbRefs[i] != null && ejbRefs[i].getReferenceJndiLink() != null) {
                tempEl = this.mainDocument.createElement("ejb-ref");
                if (ejbRefs[i].getReferenceName() != null && !ejbRefs[i].getReferenceName().equals("")) {
                    this.load(tempEl, ejbRefs[i].getReferenceName(), "ejb-ref-name");
                    if (ejbRefs[i].getReferenceJndiLink() != null && !ejbRefs[i].getReferenceJndiLink().equals("")) {
                        this.load(tempEl, ejbRefs[i].getReferenceJndiLink(), "jndi-name");
                        this.hasElements = true;
                    }
                    docEl.appendChild(tempEl);
                }
            }
            ++i;
        }
    }

    private void loadEJBLocalReferences(Element docEl, EJBeanLocalReference[] ejbRefs) {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        Element tempEl = null;
        int i = 0;
        while (i < ejbRefs.length) {
            if (ejbRefs[i] != null && ejbRefs[i].getReferenceJndiLink() != null) {
                tempEl = this.mainDocument.createElement("ejb-local-ref");
                if (ejbRefs[i].getReferenceName() != null && !ejbRefs[i].getReferenceName().equals("")) {
                    this.load(tempEl, ejbRefs[i].getReferenceName(), "ejb-ref-name");
                    if (ejbRefs[i].getReferenceJndiLink() != null && !ejbRefs[i].getReferenceJndiLink().equals("")) {
                        this.load(tempEl, ejbRefs[i].getReferenceJndiLink(), "jndi-name");
                        this.hasElements = true;
                    }
                    docEl.appendChild(tempEl);
                }
            }
            ++i;
        }
    }

    private void loadComponentReferences(Element docEl, ComponentReference[] compRefs) {
        if (compRefs == null || compRefs.length == 0) {
            return;
        }
        Element tempEl = null;
        String type = null;
        int i = 0;
        while (i < compRefs.length) {
            if (compRefs[i] != null && compRefs[i].getName() != null && !compRefs[i].getName().equals("")) {
                tempEl = this.mainDocument.createElement("server-component-ref");
                if (compRefs[i].getDescription() != null && !compRefs[i].getDescription().equals("")) {
                    this.load(tempEl, compRefs[i].getDescription(), "description");
                }
                this.load(tempEl, compRefs[i].getName(), "name");
                this.hasElements = true;
                type = "Service";
                if (compRefs[i].getType() == 1) {
                    type = "Interface";
                }
                this.load(tempEl, type, "type");
                if (compRefs[i].getJndiName() != null && !compRefs[i].getJndiName().equals("")) {
                    this.load(tempEl, compRefs[i].getJndiName(), "jndi-name");
                }
                docEl.appendChild(tempEl);
            }
            ++i;
        }
    }

    private void loadSecurityRoles(Element docEl, SecurityRoles[] secRoles) {
        if (secRoles == null || secRoles.length == 0) {
            return;
        }
        Element tempEl = null;
        int i = 0;
        while (i < secRoles.length) {
            if (secRoles[i] != null && (secRoles[i].getServerRoleName() != null && !secRoles[i].getServerRoleName().equals("") || secRoles[i].getUserGroup() != null && secRoles[i].getUserGroup().length != 0 || secRoles[i].getUserNames() != null && secRoles[i].getUserNames().length != 0)) {
                tempEl = this.mainDocument.createElement("security-role-map");
                if (secRoles[i].getRoleName() != null && !secRoles[i].getRoleName().equals("")) {
                    this.load(tempEl, secRoles[i].getRoleName(), "role-name");
                    if (secRoles[i].getServerRoleName() != null && !secRoles[i].getServerRoleName().equals("")) {
                        this.load(tempEl, secRoles[i].getServerRoleName(), "server-role-name");
                        this.hasElements = true;
                    } else {
                        this.loadNames(tempEl, secRoles[i].getUserGroup(), "group-name");
                        this.loadNames(tempEl, secRoles[i].getUserNames(), "user-name");
                    }
                    docEl.appendChild(tempEl);
                }
            }
            ++i;
        }
    }

    private void loadResponseStatus(Element docEl, HashMapIntObject respStatus) {
        if (respStatus == null || respStatus.size() == 0) {
            return;
        }
        Element tempEl = null;
        int[] codes = respStatus.getAllKeys();
        int i = 0;
        while (i < codes.length) {
            tempEl = this.mainDocument.createElement("response-status");
            this.load(tempEl, String.valueOf(codes[i]), "code");
            this.load(tempEl, (String)respStatus.get(codes[i]), "description");
            this.hasElements = true;
            docEl.appendChild(tempEl);
            ++i;
        }
    }

    private void loadFailOverAlert(Element docEl, String message, int timeout) {
        if (message == null && timeout < 0) {
            return;
        }
        Element tempEl = this.mainDocument.createElement("fail-over-alert");
        if (message != null && !message.equals("")) {
            this.load(tempEl, message, "message");
            this.hasElements = true;
        }
        if (timeout > -1) {
            this.load(tempEl, String.valueOf(timeout), "message-timeout");
            this.hasElements = true;
        }
        docEl.appendChild(tempEl);
    }

    private void loadNames(Element secRoleEl, String[] names, String tagName) {
        if (names == null || names.length == 0) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            if (names[i] != null && !names[i].equals("")) {
                this.load(secRoleEl, names[i], tagName);
                this.hasElements = true;
            }
            ++i;
        }
    }

    private void load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    public WebDeploymentDescriptor loadDescriptorFromDocument(Document doc, WebDeploymentDescriptor descr) throws IllegalArgumentException, WrongStructureException {
        Element elm = doc.getDocumentElement();
        return this.loadDescriptorFromElement(elm, descr);
    }

    private WebDeploymentDescriptor loadDescriptorFromElement(Element elem, WebDeploymentDescriptor descr) throws IllegalArgumentException, WrongStructureException {
        NodeList list = elem.getChildNodes();
        Element element = null;
        String tag = null;
        String value = null;
        int number = -1;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("resource-ref")) {
                    this.processResourceRef(element, descr.getResReferences());
                }
                if (tag.equals("resource-env-ref")) {
                    this.processResourceEnvRef(element, descr.getResEnvReferences());
                }
                if (tag.equals("ejb-ref")) {
                    this.processEJBRef(element, descr.getEjbRefs());
                }
                if (tag.equals("ejb-local-ref")) {
                    this.processEJBLocalRef(element, descr.getEjbLocalRefs());
                }
                if (tag.equals("server-component-ref")) {
                    this.processComponentRef(element, descr);
                }
                if (tag.equals("security-role")) {
                    this.processSecurityRole(element, descr.getSecRoles());
                }
                if (tag.equals("security-role-map")) {
                    this.processSecurityRole(element, descr.getSecRoles());
                }
                if (tag.equals("response-status")) {
                    this.processResponseStatus(element, descr);
                }
                if (tag.equals("fail-over-alert")) {
                    this.processFailOverAlert(element, descr);
                }
                if (tag.equals("get-request-url-mode")) {
                    this.processGetRequestUrlMode(element, descr);
                }
                if (tag.equals("login-module-configuration")) {
                    AuthenticationDescriptor auth = descr.getAuthentication();
                    if (auth == null) {
                        auth = new AuthenticationDescriptor();
                    }
                    auth.loadDescriptorFromElement(element);
                    descr.setAuthentication(auth);
                }
                if (tag.equals("url-session-tracking")) {
                    descr.setURLSessionTracking(true);
                }
                if (tag.equals("security-policy-domains")) {
                    descr.setSecurityPolicyDomains(this.processDomains(element));
                }
                if (tag.equals("security-policy-domain") && (value = this.getTextValue(element)) != null && !value.equals("")) {
                    descr.setSecurityPolicyDomain(this.normalizeDomain(value));
                }
                if (tag.equals("max-sessions") && (value = this.getTextValue(element)) != null) {
                    try {
                        number = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nme) {
                        throw new WebIllegalArgumentException("servlet_jsp_0235", new Object[]{value, "<max-sessions>"}, nme);
                    }
                    if (number > -1) {
                        descr.setMaxSessions(number);
                    } else {
                        descr.setMaxSessions(-1);
                    }
                }
                if (tag.equals("cookie-config")) {
                    descr.setCookieConfig(this.initCookieConfig(element));
                }
            }
            ++i;
        }
        return descr;
    }

    private void processResourceRef(Element resRefEl, ResourceReference[] resRefs) throws IllegalArgumentException, WrongStructureException {
        if (resRefs == null || resRefs.length == 0) {
            return;
        }
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = resRefEl.getChildNodes();
        ResourceReference resReference = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("res-ref-name")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<res-ref-name>", "<resource-ref>"});
                    }
                    resReference = this.findResReference(value, resRefs);
                    if (resReference == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0237", new Object[]{"<resource-ref>", value});
                    }
                }
                if (resReference == null) {
                    throw new WebWrongStructureException(WebWrongStructureException.TAG_IN_TAG_IS_NOT_FOUND_AT_ITS_CORRECT_POSSITION, new Object[]{"<res-ref-name>", "<resource-ref>"});
                }
                if (tag.equals("res-link")) {
                    resReference.setResourceLink(this.getTextValue(element));
                } else if (tag.equals("non-transactional")) {
                    resReference.setTransactional(false);
                }
            }
            ++i;
        }
    }

    private void processResourceEnvRef(Element resRefEl, ResourceEnvReference[] resRefs) throws IllegalArgumentException, WrongStructureException {
        if (resRefs == null || resRefs.length == 0) {
            return;
        }
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = resRefEl.getChildNodes();
        ResourceEnvReference resReference = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("res-env-ref-name")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<res-env-ref-name>", "<resource-env-ref>"});
                    }
                    resReference = this.findResEnvReference(value, resRefs);
                    if (resReference == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0237", new Object[]{"<res-env-ref-name>", value});
                    }
                }
                if (tag.equals("resource-env-ref-name")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<res-env-ref-name>", "<resource-env-ref>"});
                    }
                    resReference = this.findResEnvReference(value, resRefs);
                    if (resReference == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0237", new Object[]{"<res-env-ref-name>", value});
                    }
                }
                if (resReference == null) {
                    throw new WebWrongStructureException(WebWrongStructureException.TAG_IN_TAG_IS_NOT_FOUND_AT_ITS_CORRECT_POSSITION, new Object[]{"<res-env-ref-name>", "<resource-env-ref>"});
                }
                if (tag.equals("res-link")) {
                    resReference.setJndiName(this.getTextValue(element));
                } else if (tag.equals("jndi-name")) {
                    resReference.setJndiName(this.getTextValue(element));
                }
            }
            ++i;
        }
    }

    private void processEJBRef(Element ejbRefEl, EJBeanReference[] ejbRefs) throws IllegalArgumentException, WrongStructureException {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = ejbRefEl.getChildNodes();
        EJBeanReference ejbReference = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("ejb-ref-name")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<ejb-ref-name>", "<ejb-ref>"});
                    }
                    ejbReference = this.findEJBReference(value, ejbRefs);
                    if (ejbReference == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0237", new Object[]{"<ejb-ref>", value});
                    }
                }
                if (ejbReference == null) {
                    throw new WebWrongStructureException(WebWrongStructureException.TAG_IN_TAG_IS_NOT_FOUND_AT_ITS_CORRECT_POSSITION, new Object[]{"<ejb-ref-name>", "<ejb-ref>"});
                }
                if (tag.equals("ejb-link")) {
                    ejbReference.setReferenceJndiLink(this.getTextValue(element));
                } else if (tag.equals("jndi-name")) {
                    ejbReference.setReferenceJndiLink(this.getTextValue(element));
                }
            }
            ++i;
        }
    }

    private void processEJBLocalRef(Element ejbRefEl, EJBeanLocalReference[] ejbRefs) throws IllegalArgumentException, WrongStructureException {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = ejbRefEl.getChildNodes();
        EJBeanLocalReference ejbReference = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("ejb-ref-name")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<ejb-ref-name>", "<ejb-local-ref>"});
                    }
                    ejbReference = this.findEJBLocalReference(value, ejbRefs);
                    if (ejbReference == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0237", new Object[]{"<ejb-local-ref>", value});
                    }
                }
                if (ejbReference == null) {
                    throw new WebWrongStructureException(WebWrongStructureException.TAG_IN_TAG_IS_NOT_FOUND_AT_ITS_CORRECT_POSSITION, new Object[]{"<ejb-ref-name>", "<ejb-local-ref>"});
                }
                if (tag.equals("ejb-link")) {
                    ejbReference.setReferenceJndiLink(this.getTextValue(element));
                } else if (tag.equals("jndi-name")) {
                    ejbReference.setReferenceJndiLink(this.getTextValue(element));
                }
            }
            ++i;
        }
    }

    private void processComponentRef(Element compRefEl, WebDeploymentDescriptor wdd) throws IllegalArgumentException {
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = compRefEl.getChildNodes();
        ComponentReference compReference = null;
        int type = 0;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("name")) {
                    value = this.getTextValue(element);
                    if (value == null || value.equals("")) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<name>", "<server-component-ref>"});
                    }
                    if (compReference == null) {
                        compReference = new ComponentReference();
                    }
                    compReference.setName(value);
                } else if (tag.equals("type")) {
                    type = 0;
                    if (this.getTextValue(element).equalsIgnoreCase("Interface")) {
                        type = 1;
                    }
                    compReference.setType(type);
                } else if (tag.equals("jndi-name")) {
                    compReference.setJndiName(this.getTextValue(element));
                } else if (tag.equals("description")) {
                    value = this.getTextValue(element);
                    if (compReference == null) {
                        compReference = new ComponentReference();
                    }
                    compReference.setDescription(this.getTextValue(element));
                }
            }
            ++i;
        }
        if (compReference != null) {
            wdd.addServerComponentReference(compReference);
        }
    }

    private ResourceReference findResReference(String name, ResourceReference[] resRefs) {
        String resRefName = null;
        int i = 0;
        while (i < resRefs.length) {
            if (resRefs[i] != null && name.equals(resRefName = resRefs[i].getResourceName())) {
                return resRefs[i];
            }
            ++i;
        }
        return null;
    }

    private ResourceEnvReference findResEnvReference(String name, ResourceEnvReference[] resRefs) {
        String resRefName = null;
        int i = 0;
        while (i < resRefs.length) {
            if (resRefs[i] != null && name.equals(resRefName = resRefs[i].getName())) {
                return resRefs[i];
            }
            ++i;
        }
        return null;
    }

    private EJBeanReference findEJBReference(String name, EJBeanReference[] ejbRefs) {
        String ejbRefName = null;
        int i = 0;
        while (i < ejbRefs.length) {
            if (ejbRefs[i] != null && name.equals(ejbRefName = ejbRefs[i].getReferenceName())) {
                return ejbRefs[i];
            }
            ++i;
        }
        return null;
    }

    private EJBeanLocalReference findEJBLocalReference(String name, EJBeanLocalReference[] ejbRefs) {
        String ejbRefName = null;
        int i = 0;
        while (i < ejbRefs.length) {
            if (ejbRefs[i] != null && name.equals(ejbRefName = ejbRefs[i].getReferenceName())) {
                return ejbRefs[i];
            }
            ++i;
        }
        return null;
    }

    private void processSecurityRole(Element secRoleEl, SecurityRoles[] secRoles) throws IllegalArgumentException, WrongStructureException {
        if (secRoles == null || secRoles.length == 0) {
            return;
        }
        Element element = null;
        String tag = null;
        String value = null;
        NodeList list = secRoleEl.getChildNodes();
        SecurityRoles securityRole = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("role-name")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<role-name>", "<security-role-map>"});
                    }
                    securityRole = this.findSecRole(value, secRoles);
                    if (securityRole == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0239", new Object[]{value});
                    }
                }
                if (securityRole == null) {
                    throw new WebWrongStructureException(WebWrongStructureException.TAG_IN_TAG_IS_NOT_FOUND_AT_ITS_CORRECT_POSSITION, new Object[]{"<role-name>", "<security-role-map>"});
                }
                if (tag.equals("group-id")) {
                    // empty if block
                }
                if (tag.equals("user-id")) {
                    // empty if block
                }
                if (tag.equals("group-name")) {
                    securityRole.setUserGroup(this.getTextValue(element));
                }
                if (tag.equals("user-name")) {
                    securityRole.setUserName(this.getTextValue(element));
                }
                if (tag.equals("server-role-name")) {
                    securityRole.setServerRoleName(this.getTextValue(element));
                }
            }
            ++i;
        }
    }

    private SecurityRoles findSecRole(String name, SecurityRoles[] secRoles) {
        String secRoleName = null;
        int i = 0;
        while (i < secRoles.length) {
            if (secRoles[i] != null && name.equals(secRoleName = secRoles[i].getRoleName())) {
                return secRoles[i];
            }
            ++i;
        }
        return null;
    }

    private void processResponseStatus(Element respStatusEl, WebDeploymentDescriptor descr) throws IllegalArgumentException {
        Element element = null;
        String tag = null;
        String value = null;
        int code = -1;
        String description = null;
        NodeList list = respStatusEl.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("code")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<code>", "<response-status>"});
                    }
                    try {
                        code = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nme) {
                        throw new WebIllegalArgumentException("servlet_jsp_0240", new Object[]{value}, nme);
                    }
                    this.verifyCode(code);
                }
                if (tag.equals("description")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<description>", "<response-status>"});
                    }
                    description = value;
                }
                if (code != -1 && description != null) {
                    descr.addResponseStatus(code, description);
                }
            }
            ++i;
        }
    }

    private void verifyCode(int code) throws IllegalArgumentException {
        if (code < 1 || code > 999) {
            throw new WebIllegalArgumentException("servlet_jsp_0241", new Object[]{code + ""});
        }
    }

    private void processGetRequestUrlMode(Element element, WebDeploymentDescriptor descr) throws IllegalArgumentException {
        String value = this.getTextValue(element);
        if (value == null) {
            return;
        }
        descr.setGetRequestURLMode(value);
    }

    private void processFailOverAlert(Element respStatusEl, WebDeploymentDescriptor descr) throws IllegalArgumentException {
        Element element = null;
        String tag = null;
        String value = null;
        int timeout = -1;
        NodeList list = respStatusEl.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("message-timeout")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<message-timeout>", "<fail-over-alert>"});
                    }
                    try {
                        timeout = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nme) {
                        throw new WebIllegalArgumentException("servlet_jsp_0235", new Object[]{value, "<message-timeout>"}, nme);
                    }
                    if (timeout < 0) {
                        throw new WebIllegalArgumentException("servlet_jsp_0242", new Object[]{value});
                    }
                    descr.setFailOverMessageTimeout(timeout);
                }
                if (tag.equals("message")) {
                    value = this.getTextValue(element);
                    if (value == null) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<message>", "<fail-over-alert>"});
                    }
                    if ("".equals(value.trim())) {
                        throw new WebIllegalArgumentException("servlet_jsp_0236", new Object[]{"<message>", "<fail-over-alert>"});
                    }
                    descr.setFailOverMessage(value);
                }
            }
            ++i;
        }
    }

    private String[] processDomains(Element el) throws WrongStructureException {
        NodeList paramsList = el.getElementsByTagName("domain-name");
        if (paramsList.getLength() == 0) {
            throw new WebWrongStructureException(WebWrongStructureException.AT_LEAST_ONE_ELEMENT_MUST_BE_PRESENT_IN_ELEMENT, new Object[]{"<domain-name>", "<security-policy-domains>"});
        }
        Vector<String> domains = new Vector<String>();
        Object[] domains_list = null;
        Element nextEl = null;
        String value = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1 && (value = this.getTextValue(nextEl = (Element)paramsList.item(i))) != null && !value.equals("")) {
                domains.addElement(this.normalizeDomain(value));
            }
            ++i;
        }
        if (domains.size() > 0) {
            domains_list = new String[domains.size()];
            domains.copyInto(domains_list);
            return domains_list;
        }
        return null;
    }

    private String normalizeDomain(String domain) {
        StringBuffer temp = new StringBuffer();
        temp.append('/');
        int i = 0;
        while (i < domain.length()) {
            if (domain.charAt(i) != '/' || domain.charAt(i) == '/' && (temp.length() == 0 || temp.charAt(temp.length() - 1) != '/')) {
                temp.append(domain.charAt(i));
            }
            ++i;
        }
        domain = new String(temp);
        return domain;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String obj = node.getNodeValue();
            if (obj == null) {
                return null;
            }
            String value = obj;
            if (value.trim().equals("")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    protected void loadCookieConfig(Element cookiesElement, CookieConfig[] cookies) {
        if (cookies != null) {
            Element cookieEl = null;
            Element cookieConfEl = null;
            cookieConfEl = this.mainDocument.createElement("cookie-config");
            int i = 0;
            while (i < cookies.length) {
                cookieEl = this.mainDocument.createElement("cookie");
                if (cookies[i] != null && cookies[i].getType() != null) {
                    this.load(cookieEl, cookies[i].getType(), "type");
                    if (cookies[i].getPath() != null) {
                        this.load(cookieEl, cookies[i].getPath(), "path");
                    }
                    if (cookies[i].getDomain() != null) {
                        this.load(cookieEl, cookies[i].getDomain(), "domain");
                    }
                    this.load(cookieEl, String.valueOf(cookies[i].getMaxAge()), "max-age");
                    cookieConfEl.appendChild(cookieEl);
                }
                ++i;
            }
            cookiesElement.appendChild(cookieConfEl);
        }
    }

    protected CookieConfig[] initCookieConfig(Element baseEl) {
        Vector<CookieConfig> cookies = new Vector<CookieConfig>();
        NodeList cookiesList = null;
        NodeList cookiesConfList = baseEl.getChildNodes();
        Element cookieEl = null;
        CookieConfig cookie = new CookieConfig();
        String nextElTag = null;
        String value = null;
        Element tempEl = null;
        String tempName = "";
        int number = 0;
        int i = 0;
        while (i < cookiesConfList.getLength()) {
            if (cookiesConfList.item(i).getNodeType() == 1) {
                cookie = new CookieConfig();
                cookieEl = (Element)cookiesConfList.item(i);
                nextElTag = cookieEl.getNodeName();
                if (nextElTag != null && nextElTag.equals("cookie")) {
                    cookiesList = cookieEl.getChildNodes();
                    cookie = new CookieConfig();
                    int i1 = 0;
                    while (i1 < cookiesList.getLength()) {
                        if (cookiesList.item(i1).getNodeType() == 1) {
                            tempEl = (Element)cookiesList.item(i1);
                            tempName = tempEl.getNodeName();
                            value = this.getTextValue(tempEl);
                            if (tempName.equals("type")) {
                                cookie.setType(value);
                            } else if (tempName.equals("path")) {
                                cookie.setPath(value);
                            } else if (tempName.equals("domain")) {
                                cookie.setDomain(value);
                            } else if (tempName.equals("max-age") && value != null && value.trim().length() > 0) {
                                try {
                                    number = Integer.parseInt(value);
                                }
                                catch (NumberFormatException nme) {
                                    throw new WebIllegalArgumentException("servlet_jsp_0235", new Object[]{value, "<max-age>"});
                                }
                                if (number > -1) {
                                    cookie.setMaxAge(number);
                                } else {
                                    cookie.setMaxAge(-1);
                                }
                            }
                        }
                        ++i1;
                    }
                    cookies.addElement(cookie);
                }
            }
            ++i;
        }
        Object[] result = new CookieConfig[cookies.size()];
        cookies.copyInto(result);
        return result;
    }
}

