/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.taglib;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibraryInfoImpl;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibraryValidatorDescriptor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWrongDescriptorException;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TagLibDescriptorDocument {
    public final String dtd = "<!DOCTYPE taglib [\n<!ELEMENT taglib (tlibversion, jspversion?, shortname, uri?, info?, tag+) >\n<!ELEMENT tlibversion (#PCDATA) >\n<!ELEMENT jspversion (#PCDATA) >\n<!ELEMENT shortname (#PCDATA) >\n<!ELEMENT uri (#PCDATA) >\n<!ELEMENT info (#PCDATA) >\n<!ELEMENT tag (name, tagclass, teiclass?, bodycontent?, info?, attribute*) >\n<!ELEMENT tagclass (#PCDATA) >\n<!ELEMENT teiclass (#PCDATA) >\n<!ELEMENT bodycontent (#PCDATA) >\n<!ELEMENT attribute (name, required? , rtexprvalue?) >\n<!ELEMENT required (#PCDATA) >\n<!ELEMENT rtexprvalue (#PCDATA) >\n]";
    public final String dtd1_2 = "<!DOCTYPE taglib [\n<!ELEMENT taglib (tlib-version, jsp-version, short-name, uri?, display-name?, small-icon?, large-icon?, description?, validator?, listener*, tag+) >\n<!ELEMENT tli-bversion (#PCDATA) >\n<!ELEMENT jsp-version (#PCDATA) >\n<!ELEMENT shor-tname (#PCDATA) >\n<!ELEMENT uri (#PCDATA) >\n<!ELEMENT description (#PCDATA) >\n<!ELEMENT validator (validator-class, init-param*, description?) >\n<!ELEMENT validator-class (#PCDATA) >\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT listener (listener-class) >\n<!ELEMENT listener-class (#PCDATA) >\n<!ELEMENT tag (name, tag-class, tei-class?, body-content?, display-name?, small-icon?, large-icon?, description?, variable*, attribute*, example?) >\n<!ELEMENT tag-class (#PCDATA) >\n<!ELEMENT tei-class (#PCDATA) >\n<!ELEMENT body-ycontent (#PCDATA) >\n<!ELEMENT display-name (#PCDATA) >\n<!ELEMENT large-icon (#PCDATA) >\n<!ELEMENT small-icon (#PCDATA) >\n<!ELEMENT example (#PCDATA) >\n<!ELEMENT variable ( (name-given | name-from-attribute), variable-class?, declare?, scope?, description?) >\n<!ELEMENT name-given (#PCDATA) >\n<!ELEMENT name-from-attribute (#PCDATA) >\n<!ELEMENT variable-class (#PCDATA) >\n<!ELEMENT declare (#PCDATA) >\n<!ELEMENT scope (#PCDATA) >\n<!ELEMENT attribute (name, required? , rtexprvalue?, type?, description?) >\n<!ELEMENT name  (#PCDATA) >\n<!ELEMENT required (#PCDATA) >\n<!ELEMENT rtexprvalue (#PCDATA) >\n<!ELEMENT type (#PCDATA) >\n]>";
    protected Document mainDocument;
    private ClassLoader appLoader = null;
    protected boolean isOldVersion = false;

    public TagLibDescriptorDocument(ClassLoader appLoader) {
        this.appLoader = appLoader;
    }

    public TagLibDescriptorDocument(TagLibraryInfo descriptor, ClassLoader appLoader) {
        this.appLoader = appLoader;
        this.loadDocumentFromDescriptor(descriptor);
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document doc) {
        this.mainDocument = doc;
    }

    public Document loadDocumentFromDescriptor(TagLibraryInfo descriptor) throws DOMException {
        this.mainDocument = StandardDOMParser.createDocument();
        this.mainDocument.appendChild(this.loadElementFromDescriptor(descriptor, this.mainDocument));
        return this.mainDocument;
    }

    public TagLibraryInfo loadDescriptorFromDocument(Document document) throws WrongStructureException, WebWrongDescriptorException {
        Element elm = document.getDocumentElement();
        return this.loadDescriptorFromElement(elm);
    }

    private Element loadElementFromDescriptor(TagLibraryInfo descriptor, Document document) {
        Element docElement = null;
        Element tempElement = null;
        String tempName = null;
        this.mainDocument = document;
        docElement = document.createElement("taglib");
        tempName = String.valueOf(((TagLibraryInfoImpl)descriptor).getTlibversion());
        if (tempName != null) {
            if (tempName.equals("1.0") || tempName.equals("1.1")) {
                this.isOldVersion = true;
                this.load(docElement, tempName, "tlibversion");
            } else {
                this.isOldVersion = false;
                this.load(docElement, tempName, "tlib-version");
            }
        }
        if ((tempName = String.valueOf(((TagLibraryInfoImpl)descriptor).getJspversion())) != null) {
            if (this.isOldVersion) {
                this.load(docElement, tempName, "jspversion");
            } else {
                this.load(docElement, tempName, "jsp-version");
            }
        }
        if (this.isOldVersion) {
            this.load(docElement, descriptor.getShortName(), "shortname");
        } else {
            this.load(docElement, descriptor.getShortName(), "short-name");
        }
        tempName = descriptor.getURI();
        if (tempName != null) {
            this.load(docElement, tempName, "uri");
        }
        if (descriptor instanceof TagLibraryInfoImpl) {
            tempName = ((TagLibraryInfoImpl)descriptor).getDisplayName();
            if (tempName != null) {
                this.load(docElement, tempName, "display-name");
            }
            if ((tempName = ((TagLibraryInfoImpl)descriptor).getSmallIcon()) != null) {
                this.load(docElement, tempName, "small-icon");
            }
            if ((tempName = ((TagLibraryInfoImpl)descriptor).getLargeIcon()) != null) {
                this.load(docElement, tempName, "large-icon");
            }
        }
        if ((tempName = descriptor.getInfoString()) != null) {
            if (this.isOldVersion) {
                this.load(docElement, tempName, "info");
            } else {
                this.load(docElement, tempName, "description");
            }
        }
        if (descriptor instanceof TagLibraryInfoImpl) {
            String[] listeners;
            if (((TagLibraryInfoImpl)descriptor).getValidator() != null) {
                tempElement = this.mainDocument.createElement("validator");
                this.loadValidator(tempElement, ((TagLibraryInfoImpl)descriptor).getValidator());
            }
            if ((listeners = ((TagLibraryInfoImpl)descriptor).getListeners()) != null && listeners.length > 0) {
                this.loadListeners(docElement, listeners);
            }
        }
        tempElement = this.mainDocument.createElement("tag");
        this.loadTags(tempElement, descriptor.getTags());
        docElement.appendChild(tempElement);
        return docElement;
    }

    public void loadTags(Element element, TagInfo[] tag) {
        if (tag != null) {
            Element tagElement = null;
            String tempName = "";
            int i = 0;
            while (i < tag.length) {
                tagElement = this.mainDocument.createElement("tag");
                if (tag[i] != null) {
                    this.load(tagElement, tag[i].getTagName(), "name");
                    if (this.isOldVersion) {
                        this.load(tagElement, tag[i].getTagClassName(), "tagclass");
                    } else {
                        this.load(tagElement, tag[i].getTagClassName(), "tag-class");
                    }
                    tempName = tag[i].getTagExtraInfo().getClass().getName();
                    if (tempName != null) {
                        if (this.isOldVersion) {
                            this.load(tagElement, tempName, "teiclass");
                        } else {
                            this.load(tagElement, tempName, "tei-class");
                        }
                    }
                    if ((tempName = String.valueOf(tag[i].getBodyContent())) != null) {
                        if (this.isOldVersion) {
                            this.load(tagElement, tempName, "bodycontent");
                        } else {
                            this.load(tagElement, tempName, "body-content");
                        }
                    }
                    if ((tempName = tag[i].getDisplayName()) != null) {
                        this.load(tagElement, tempName, "display-name");
                    }
                    if ((tempName = tag[i].getSmallIcon()) != null) {
                        this.load(tagElement, tempName, "small-icon");
                    }
                    if ((tempName = tag[i].getLargeIcon()) != null) {
                        this.load(tagElement, tempName, "large-icon");
                    }
                    if ((tempName = tag[i].getInfoString()) != null) {
                        if (this.isOldVersion) {
                            this.load(tagElement, tempName, "info");
                        } else {
                            this.load(tagElement, tempName, "description");
                        }
                    }
                    tagElement = this.mainDocument.createElement("variable");
                    this.loadVariables(tagElement, tag[i].getTagVariableInfos());
                    element.appendChild(tagElement);
                    tagElement = this.mainDocument.createElement("attribute");
                    this.loadAttributes(tagElement, tag[i].getAttributes());
                    element.appendChild(tagElement);
                }
                ++i;
            }
        }
    }

    protected void loadVariables(Element el, TagVariableInfo[] var) {
        if (var != null) {
            Element varElement = null;
            String tempName = "";
            int i = 0;
            while (i < var.length) {
                varElement = this.mainDocument.createElement("variable");
                if (var[i] == null) {
                    return;
                }
                tempName = var[i].getNameGiven();
                if (tempName == null) {
                    tempName = var[i].getNameFromAttribute();
                    this.load(varElement, tempName, "name-from-attribute");
                } else {
                    this.load(varElement, tempName, "name-given");
                }
                tempName = var[i].getClassName();
                if (tempName != null) {
                    this.load(varElement, tempName, "variable-class");
                }
                if ((tempName = String.valueOf(var[i].getDeclare())) != null) {
                    this.load(varElement, tempName, "declare");
                }
                if ((tempName = String.valueOf(var[i].getScope())) != null) {
                    this.load(varElement, tempName, "scope");
                }
                el.appendChild(varElement);
                ++i;
            }
        }
    }

    protected void loadAttributes(Element el, TagAttributeInfo[] attr) {
        if (attr != null) {
            Element attrElement = null;
            String tempName = "";
            int i = 0;
            while (i < attr.length) {
                attrElement = this.mainDocument.createElement("attribute");
                if (attr[i] == null) {
                    return;
                }
                this.load(attrElement, attr[i].getName(), "name");
                tempName = String.valueOf(attr[i].isRequired());
                if (tempName != null) {
                    this.load(attrElement, tempName, "required");
                }
                if ((tempName = String.valueOf(attr[i].canBeRequestTime())) != null) {
                    this.load(attrElement, tempName, "rtexprvalue");
                }
                if ((tempName = attr[i].getTypeName()) != null) {
                    this.load(attrElement, tempName, "type");
                }
                el.appendChild(attrElement);
                ++i;
            }
        }
    }

    protected void load(Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    protected void load(String name, String tagName) {
        this.load(this.mainDocument.getDocumentElement(), name, tagName);
    }

    public TagLibraryInfo loadDescriptorFromElement(Element el) throws WrongStructureException, WebWrongDescriptorException {
        NodeList list = el.getChildNodes();
        TagLibraryInfoImpl tagLibraryInfo = new TagLibraryInfoImpl();
        Element element = null;
        String tag = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("tlibversion") || tag.equals("tlib-version")) {
                    String tlversion = this.getTextValue(element);
                    int dotInd = tlversion.indexOf(".");
                    if (dotInd == -1) {
                        tagLibraryInfo.setTlibversion(Float.valueOf(tlversion).floatValue());
                    } else {
                        String majorVersion = tlversion.substring(0, dotInd + 1);
                        tlversion = tlversion.substring(dotInd + 1);
                        while ((dotInd = tlversion.indexOf(".")) > -1) {
                            tlversion = tlversion.substring(0, dotInd) + tlversion.substring(dotInd + 1);
                        }
                        tlversion = majorVersion + tlversion;
                        tagLibraryInfo.setTlibversion(Float.valueOf(tlversion).floatValue());
                    }
                } else if (tag.equals("jspversion") || tag.equals("jsp-version")) {
                    tagLibraryInfo.setJspversion(new Float(this.getTextValue(element)).floatValue());
                } else if (tag.equals("shortname") || tag.equals("short-name")) {
                    tagLibraryInfo.setShortName(this.getTextValue(element));
                } else if (tag.equals("display-name")) {
                    tagLibraryInfo.setDisplayName(this.getTextValue(element));
                } else if (tag.equals("small-icon")) {
                    tagLibraryInfo.setSmallIcon(this.getTextValue(element));
                } else if (tag.equals("large-icon")) {
                    tagLibraryInfo.setLargeIcon(this.getTextValue(element));
                } else if (tag.equals("validator")) {
                    tagLibraryInfo.setValidator(this.getValidator(element));
                } else if (tag.equals("listener")) {
                    tagLibraryInfo.addListener(this.initListener(element));
                } else if (tag.equals("uri")) {
                    tagLibraryInfo.setURI(this.getTextValue(element));
                } else if (tag.equals("info") || tag.equals("description")) {
                    tagLibraryInfo.setInfoString(this.getTextValue(element));
                } else if (tag.equals("tag")) {
                    tagLibraryInfo.addTag(this.getTagInfo(element, tagLibraryInfo));
                }
            }
            ++i;
        }
        return tagLibraryInfo;
    }

    protected TagInfo getTagInfo(Element el, TagLibraryInfo tagLibraryInfo) throws WebWrongDescriptorException {
        NodeList paramsList = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = null;
        String tagName = null;
        String tagClassName = null;
        String teiClassName = null;
        TagExtraInfo tagExtraInfo = null;
        String infoString = null;
        String bodycontent = null;
        String displayName = null;
        String largeIcon = null;
        String smallIcon = null;
        TagAttributeInfo[] attributeInfo = new TagAttributeInfo[]{};
        TagVariableInfo[] variableInfo = new TagVariableInfo[]{};
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                nextEl = (Element)paramsList.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("name")) {
                    tagName = this.getTextValue(nextEl);
                } else if (nextElTag.equals("tagclass") || nextElTag.equals("tag-class")) {
                    tagClassName = this.getTextValue(nextEl);
                } else if (nextElTag.equals("teiclass") || nextElTag.equals("tei-class")) {
                    teiClassName = this.getTextValue(nextEl);
                } else if (nextElTag.equals("info") || nextElTag.equals("description")) {
                    infoString = this.getTextValue(nextEl);
                } else if (nextElTag.equals("bodycontent") || nextElTag.equals("body-content")) {
                    bodycontent = this.getTextValue(nextEl);
                } else if (nextElTag.equals("display-name")) {
                    displayName = this.getTextValue(nextEl);
                } else if (nextElTag.equals("large-icon")) {
                    largeIcon = this.getTextValue(nextEl);
                } else if (nextElTag.equals("small-icon")) {
                    smallIcon = this.getTextValue(nextEl);
                } else if (nextElTag.equals("variable")) {
                    TagVariableInfo tagVariableInfo = this.getVAriableInfo(nextEl);
                    TagVariableInfo[] variableInfo_ = new TagVariableInfo[variableInfo.length + 1];
                    System.arraycopy(variableInfo, 0, variableInfo_, 0, variableInfo.length);
                    variableInfo_[variableInfo.length] = tagVariableInfo;
                    variableInfo = variableInfo_;
                    variableInfo_ = null;
                } else if (nextElTag.equals("attribute")) {
                    TagAttributeInfo tagAttributeInfo = this.getAttributeInfo(nextEl);
                    TagAttributeInfo[] attributeInfo_ = new TagAttributeInfo[attributeInfo.length + 1];
                    System.arraycopy(attributeInfo, 0, attributeInfo_, 0, attributeInfo.length);
                    attributeInfo_[attributeInfo.length] = tagAttributeInfo;
                    attributeInfo = attributeInfo_;
                    attributeInfo_ = null;
                }
            }
            ++i;
        }
        if (teiClassName != null) {
            try {
                Class<?> teiClass = this.appLoader.loadClass(teiClassName);
                tagExtraInfo = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new WebWrongDescriptorException("servlet_jsp_0252", new Object[]{teiClassName}, e);
            }
            catch (InstantiationException e) {
                throw new WebWrongDescriptorException("servlet_jsp_0252", new Object[]{teiClassName}, e);
            }
            catch (IllegalAccessException e) {
                throw new WebWrongDescriptorException("servlet_jsp_0252", new Object[]{teiClassName}, e);
            }
            catch (NoClassDefFoundError e) {
                throw new WebWrongDescriptorException("servlet_jsp_0288", new Object[]{teiClassName}, e);
            }
        }
        return new TagInfo(tagName, tagClassName, bodycontent, infoString, tagLibraryInfo, tagExtraInfo, attributeInfo, displayName, smallIcon, largeIcon, variableInfo);
    }

    protected TagVariableInfo getVAriableInfo(Element el) {
        NodeList paramsList = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = null;
        String nameGiven = null;
        String nameFromAttribute = null;
        String variableClass = null;
        boolean declare = true;
        int scope = 0;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                String str;
                nextEl = (Element)paramsList.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("name-given")) {
                    nameGiven = this.getTextValue(nextEl);
                } else if (nextElTag.equals("name-from-attribute")) {
                    nameFromAttribute = this.getTextValue(nextEl);
                } else if (nextElTag.equals("variable-class")) {
                    variableClass = this.getTextValue(nextEl);
                } else if (nextElTag.equals("declare")) {
                    declare = Boolean.valueOf(this.getTextValue(nextEl));
                } else if (nextElTag.equals("scope") && (str = this.getTextValue(nextEl)) != null) {
                    if ("NESTED".equals(str)) {
                        scope = 0;
                    } else if ("AT_BEGIN".equals(str)) {
                        scope = 1;
                    } else if ("AT_END".equals(str)) {
                        scope = 2;
                    }
                }
            }
            ++i;
        }
        return new TagVariableInfo(nameGiven, nameFromAttribute, variableClass, declare, scope);
    }

    protected TagAttributeInfo getAttributeInfo(Element el) {
        NodeList paramsList = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = null;
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        String type = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                nextEl = (Element)paramsList.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("name")) {
                    name = this.getTextValue(nextEl);
                } else if (nextElTag.equals("required")) {
                    required = Boolean.valueOf(this.getTextValue(nextEl));
                } else if (nextElTag.equals("rtexprvalue")) {
                    rtexprvalue = Boolean.valueOf(this.getTextValue(nextEl));
                } else if (nextElTag.equals("type")) {
                    type = this.getTextValue(nextEl);
                }
            }
            ++i;
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    protected TagAttributeInfo getAttributes(Element el) {
        NodeList paramsList = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = null;
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        String type = null;
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                nextEl = (Element)paramsList.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("name")) {
                    name = this.getTextValue(nextEl);
                } else if (nextElTag.equals("required")) {
                    required = Boolean.valueOf(this.getTextValue(nextEl));
                } else if (nextElTag.equals("rtexprvalue")) {
                    rtexprvalue = Boolean.valueOf(this.getTextValue(nextEl));
                } else if (nextElTag.equals("type")) {
                    type = this.getTextValue(nextEl);
                }
            }
            ++i;
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    protected int getBodyCont(String value) {
        int content_type = -1;
        if (value.equals("TAGDEPENDENT")) {
            content_type = 0;
        } else if (value.equals("JSP")) {
            content_type = 1;
        } else if (value.equals("EMPTY")) {
            content_type = 2;
        }
        return content_type;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            if (value.trim().equals("")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    protected TagLibraryValidatorDescriptor getValidator(Element el) {
        NodeList paramsList = el.getChildNodes();
        Element nextEl = null;
        String nextElTag = null;
        TagLibraryValidatorDescriptor desc = new TagLibraryValidatorDescriptor();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1) {
                nextEl = (Element)paramsList.item(i);
                nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("validator-class")) {
                    desc.setValidatorClass(this.getTextValue(nextEl));
                } else if (nextElTag.equals("description")) {
                    desc.setDescription(this.getTextValue(nextEl));
                } else if (nextElTag.equals("init-param")) {
                    desc.addInitParam(this.getInitParam(nextEl));
                }
            }
            ++i;
        }
        return desc;
    }

    protected ContextParam getInitParam(Element el) {
        NodeList paramsList = el.getChildNodes();
        ContextParam cParam = new ContextParam();
        String nextElTag = null;
        String value = null;
        Element paramEl = null;
        if (paramsList == null) {
            return null;
        }
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i) instanceof Element) {
                paramEl = (Element)paramsList.item(i);
                nextElTag = paramEl.getNodeName();
                if (nextElTag.equals("param-name")) {
                    value = this.getTextValue(paramEl);
                    cParam.setParamName(value);
                } else if (nextElTag.equals("param-value")) {
                    value = this.getTextValue(paramEl);
                    cParam.setParamValue(value);
                } else if (nextElTag.equals("description")) {
                    value = this.getTextValue(paramEl);
                    cParam.setDescription(value);
                }
            }
            ++i;
        }
        if (cParam != null) {
            return cParam;
        }
        return null;
    }

    protected void loadValidator(Element el, TagLibraryValidatorDescriptor validator) {
        Element mappingEl = this.mainDocument.createElement("validator");
        this.load(mappingEl, validator.getValidatorClass(), "validator-class");
        this.loadContextParams(mappingEl, validator.getInitParams(), "init-param");
        if (validator.getDescription() != null) {
            this.load(mappingEl, validator.getDescription(), "description");
        }
        el.appendChild(mappingEl);
    }

    protected void loadContextParams(Element contEl, ContextParam[] params, String elementName) {
        String tempName = "";
        if (params != null) {
            Element paramEl = null;
            int i = 0;
            while (i < params.length) {
                paramEl = this.mainDocument.createElement(elementName);
                if (params[i] != null) {
                    this.load(paramEl, params[i].getParamName(), "param-name");
                    this.load(paramEl, params[i].getParamValue(), "param-value");
                    tempName = params[i].getDescription();
                    if (tempName != null) {
                        this.load(paramEl, tempName, "description");
                    }
                    contEl.appendChild(paramEl);
                }
                ++i;
            }
        }
    }

    protected String initListener(Element el) {
        String nextElTag = null;
        String value = null;
        Element filterEl = null;
        NodeList paramsList = el.getChildNodes();
        int i = 0;
        while (i < paramsList.getLength()) {
            if (paramsList.item(i).getNodeType() == 1 && (nextElTag = (filterEl = (Element)paramsList.item(i)).getNodeName()).equals("listener-class")) {
                value = this.getTextValue(filterEl);
                return value;
            }
            ++i;
        }
        return null;
    }

    protected void loadListeners(Element el, String[] listeners) {
        Element mappingEl = null;
        int i = 0;
        while (i < listeners.length) {
            mappingEl = this.mainDocument.createElement("listener");
            if (listeners[i] != null) {
                this.load(mappingEl, listeners[i], "listener-class");
                el.appendChild(mappingEl);
            }
            ++i;
        }
    }
}

