/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListRenderer;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServletMappingPanel
extends BasicPanelView
implements ActionListener,
DocumentListener,
ListSelectionListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String CLEAR_CMD = "CLEAR_CMD";
    public static final String MODIFY_CMD = "MODIFY_CMD";
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane theSplitPane = new JSplitPane();
    JScrollPane scrollPane = new JScrollPane();
    JPanel inputPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JList theList = new JList();
    TitledBorder titledBorder1;
    JLabel valueLabel = new JLabel(GuiSettings.getResourceString("ServletMap_URL_Pattern", "URL Pattern:"));
    JTextField valueTextField = new JTextField();
    JPanel buttonsPanel = new JPanel();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton clearButton = new JButton();
    JButton modifyButton = new JButton();
    Vector componentsVector = null;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private int madeFrom = 1;
    private ApplicationInformationProvider appProvider;
    private String servletName = null;
    private ServletMapping[] servletMappings = null;
    private Vector s_mappings = new Vector();

    public ServletMappingPanel(Frame frame, int madeFromConstane) {
        this.mainFrame = frame;
        this.madeFrom = madeFromConstane;
        this.init();
    }

    private void init() {
        this.valueTextField.getDocument().addDocumentListener(this);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(), GuiSettings.getResourceString("ServletrMap_Servlet_Mappings", "Servlet Mappings"));
        this.setLayout(this.borderLayout1);
        this.inputPanel.setLayout(this.gridBagLayout1);
        this.scrollPane.setBorder(this.titledBorder1);
        this.addButton.setText("Add");
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.addActionListener(this);
        this.removeButton.setText("Remove");
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.addActionListener(this);
        this.clearButton.setText("Clear");
        this.clearButton.setActionCommand(CLEAR_CMD);
        this.clearButton.addActionListener(this);
        this.modifyButton.setText("Modify");
        this.modifyButton.setActionCommand(MODIFY_CMD);
        this.modifyButton.addActionListener(this);
        this.add((Component)this.theSplitPane, "Center");
        this.theSplitPane.setDividerLocation(200);
        this.theSplitPane.add((Component)this.scrollPane, "left");
        this.scrollPane.getViewport().add((Component)this.theList, null);
        this.theSplitPane.add((Component)this.inputPanel, "right");
        this.inputPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.valueTextField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonsPanel.add((Component)this.addButton, null);
        this.buttonsPanel.add((Component)this.modifyButton, null);
        this.buttonsPanel.add((Component)this.removeButton, null);
        this.buttonsPanel.add((Component)this.clearButton, null);
        this.valueTextField.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.theList.setCellRenderer(new ListRenderer());
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
        this.setEnabledComnoments();
    }

    private void initFields(ServletMapping serv) {
        if (serv != null && this.selectWithMouse) {
            this.setText = true;
            this.valueTextField.setText(serv.getURLPattern());
            this.setText = false;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.setEnabledComnoments();
        if (!this.theList.isSelectionEmpty()) {
            if (this.madeFrom != 3 && this.madeFrom != 5 && this.madeFrom != 4) {
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
        if (!this.selectWithMouse) {
            if (this.theList.getSelectedValue() != null) {
                ListValues value = (ListValues)this.theList.getSelectedValue();
                this.initFields(value.getServletMapping());
            } else {
                this.clear();
            }
            return;
        }
        if (!this.theList.isSelectionEmpty()) {
            ListValues value = (ListValues)this.theList.getSelectedValue();
            this.initFields(value.getServletMapping());
        } else {
            this.clear();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ADD_CMD)) {
            this.addButtonAction();
        } else if (cmd.equals(REMOVE_CMD)) {
            this.removeButtonAction();
        } else if (cmd.equals(CLEAR_CMD)) {
            this.clearButtonAction();
        } else if (cmd.equals(MODIFY_CMD)) {
            this.modifyButtonAction();
        }
        this.clear();
    }

    private boolean nameExists(Vector values, String name) {
        if (values != null && values.size() > 0) {
            int i = 0;
            while (i < values.size()) {
                if (name.equals(((ListValues)values.elementAt(i)).getName())) {
                    return true;
                }
                ++i;
            }
        } else {
            return false;
        }
        return false;
    }

    private void modifyButtonAction() {
        this.addButtonAction();
    }

    private void clearButtonAction() {
        this.clear();
    }

    private void addButtonAction() {
        ListValues newValue = null;
        ListValues value = null;
        String component = this.servletName;
        String other = this.valueTextField.getText().trim();
        if (other == null || other.equals("")) {
            return;
        }
        if (this.componentsVector == null) {
            this.componentsVector = new Vector();
        }
        if (!this.theList.isSelectionEmpty() && other.equals(((ListValues)this.theList.getSelectedValue()).getName())) {
            value = (ListValues)this.theList.getSelectedValue();
            ServletMapping servletMap = value.getServletMapping();
            servletMap.setServletName(component);
            servletMap.setURLPattern(other);
            value.setServletMapping(servletMap);
            this.theList.setListData(this.componentsVector);
            return;
        }
        if (!this.nameExists(this.componentsVector, other)) {
            ServletMapping servletMap = new ServletMapping();
            servletMap.setServletName(component);
            servletMap.setURLPattern(other);
            newValue = new ListValues(servletMap, 11);
            newValue.setServletMapping(servletMap);
            newValue.setName(servletMap.getURLPattern());
            this.componentsVector.addElement(newValue);
            this.theList.setListData(this.componentsVector);
            this.clear();
        } else {
            int answer = JOptionPane.showConfirmDialog(this.mainFrame, " This entry already exists  \nDo you want to replace it ?", " Warning ", 0);
            if (answer == 0) {
                int i = 0;
                while (i < this.componentsVector.size()) {
                    value = (ListValues)this.componentsVector.elementAt(i);
                    if (value.getName().equals(other)) {
                        ServletMapping servletMap = value.getServletMapping();
                        servletMap.setURLPattern(other);
                        value.setServletMapping(servletMap);
                        this.theList.setListData(this.componentsVector);
                    }
                    ++i;
                }
            } else {
                this.clear();
                return;
            }
        }
    }

    private void removeButtonAction() {
        ListValues serv = null;
        if (!this.theList.isSelectionEmpty()) {
            serv = (ListValues)this.theList.getSelectedValue();
            this.componentsVector.removeElement(serv);
            this.theList.setListData(this.componentsVector);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        if (this.selectWithMouse) {
            this.setText = true;
            this.valueTextField.setText("");
            this.setText = false;
        }
        if (!this.theList.isSelectionEmpty()) {
            this.theList.clearSelection();
        }
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
    }

    public void setLoader(ClassLoader loader) {
    }

    public Vector getListData() {
        return this.componentsVector;
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    private void checkDisabled() {
        String refName = this.valueTextField.getText().trim();
        if (refName.equals("")) {
            this.clear();
            this.setEnabledComnoments();
            return;
        }
        this.setEnabledComnoments();
        this.selectWithMouse = false;
        Vector currentValues = new Vector();
        ListModel model = this.theList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (refName.equals(((ListValues)currentValues.elementAt(i2)).getServletMapping().getURLPattern())) {
                toAdd = false;
                this.selectElementByName(i2, currentValues);
                break;
            }
            ++i2;
        }
        if (toAdd && !this.theList.isSelectionEmpty()) {
            this.theList.clearSelection();
        }
        this.setButtonsEnabled(toAdd);
        this.selectWithMouse = true;
    }

    private void selectElementByName(int i, Vector currentValues) {
        this.theList.setSelectedValue(currentValues.elementAt(i), true);
    }

    private void setButtonsEnabled(boolean toAdd) {
        if (this.valueTextField.getText() != null && this.valueTextField.getText().trim().length() != 0) {
            if (toAdd) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setDescriptor(ServletMapping[] sm) {
        this.clear();
        this.servletMappings = sm;
        this.initList();
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
        this.initList();
    }

    private void initList() {
        ListValues value = null;
        this.s_mappings.removeAllElements();
        if (this.servletMappings != null) {
            ServletMapping map1 = null;
            int i = 0;
            while (i < this.servletMappings.length) {
                if (this.servletName != null && this.servletName.equals(this.servletMappings[i].getServletName())) {
                    map1 = new ServletMapping(this.servletName, this.servletMappings[i].getURLPattern());
                    value = new ListValues(map1, 2);
                    value.setName(this.servletMappings[i].getURLPattern());
                    this.s_mappings.addElement(value);
                }
                ++i;
            }
        }
        this.componentsVector = this.s_mappings;
        this.theList.setListData(this.componentsVector);
    }

    public ServletMapping[] getServletMappings() {
        Vector mappings = this.getListData();
        ServletMapping[] newValues = null;
        if (mappings != null && mappings.size() > 0) {
            newValues = new ServletMapping[mappings.size()];
            int i = 0;
            while (i < mappings.size()) {
                newValues[i] = ((ListValues)mappings.elementAt(i)).getServletMapping();
                ++i;
            }
        }
        return newValues;
    }

    public void setEnabledComnoments() {
        if (this.madeFrom == 1 || this.madeFrom == 2) {
            this.valueTextField.setEnabled(true);
        } else if (this.madeFrom == 3 || this.madeFrom == 5) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean flag) {
        this.valueTextField.setEnabled(flag);
    }
}

