/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class FailOverPanel
extends BasicPanelView {
    private JLabel timeoutLabel = new JLabel();
    private JTextField timeoutTextField = new JTextField();
    private DescriptionPanel messagePanel = new DescriptionPanel();
    private WebDeploymentDescriptor descriptor = null;
    private ApplicationInformationProvider appProvider;
    private static Category category = EditorViewManager.category;
    private static Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$descriptor$gui$FailOverPanel == null ? (class$com$sap$engine$services$servlets_jsp$descriptor$gui$FailOverPanel = FailOverPanel.class$("com.sap.engine.services.servlets_jsp.descriptor.gui.FailOverPanel")) : class$com$sap$engine$services$servlets_jsp$descriptor$gui$FailOverPanel));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$descriptor$gui$FailOverPanel;

    public FailOverPanel() {
        this(null, null, 0);
    }

    public FailOverPanel(Frame mainFrame, WebDeploymentDescriptor descr, int madeFrom) {
        LookAndFeelHandler.add(this);
        this.init();
        this.setFrame(mainFrame);
        this.init(madeFrom);
        this.setDescriptor(descr);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.timeoutLabel.setText("Message Timeout:");
        this.messagePanel.setNewBorder("Message");
        this.add((Component)this.timeoutLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.timeoutTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.messagePanel, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.1, 10, 1, new Insets(25, 5, 25, 5), 0, 0));
    }

    private void initFields() {
        if (this.descriptor == null) {
            return;
        }
        if (this.descriptor.getFailOverMessageTimeout() > -1) {
            this.timeoutTextField.setText(String.valueOf(this.descriptor.getFailOverMessageTimeout()));
        }
        if (this.descriptor.getFailOverMessage() != null) {
            this.messagePanel.setText(this.descriptor.getFailOverMessage());
        }
    }

    public void setDescriptor(WebDeploymentDescriptor descr) {
        this.descriptor = descr;
        this.clear();
        this.initFields();
    }

    public WebDeploymentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void commitChange() {
        int timeout = -1;
        if (!this.timeoutTextField.getText().trim().equals("")) {
            try {
                timeout = Integer.parseInt(this.timeoutTextField.getText());
            }
            catch (NumberFormatException nfe) {
                category.logThrowableT(400, currentLocation, "Value for Message Timeout is not correct!", (Throwable)nfe);
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Message Timeout is not correct!\nPlease, specify an integer value.", "Warning", 2);
            }
            if (timeout < 0) {
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Message Timeout should be at least 0.", "Warning", 2);
                timeout = -1;
            }
        }
        this.descriptor.setFailOverMessageTimeout(timeout);
        if (!this.messagePanel.getText().trim().equals("")) {
            this.descriptor.setFailOverMessage(this.messagePanel.getText());
        } else {
            this.descriptor.setFailOverMessage(null);
        }
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.timeoutTextField.setText("");
        this.messagePanel.setText("");
    }

    public int isCorrect() {
        if (!this.timeoutTextField.getText().trim().equals("")) {
            try {
                if (Integer.parseInt(this.timeoutTextField.getText()) < 0) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Value for Message Timeout should be at least 0.", "Warning", 2);
                    return 2;
                }
            }
            catch (NumberFormatException nfe) {
                category.logThrowableT(400, currentLocation, "Value for Message Timeout is not correct!", (Throwable)nfe);
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Message Timeout is not correct!\nPlease, specify an integer value.", "Warning", 2);
                return 2;
            }
        }
        return 0;
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

