/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;

public class AppConfigurationEntryWrapper {
    private String name = null;
    private byte flag = (byte)-1;
    private Properties options = null;

    public AppConfigurationEntryWrapper() {
    }

    public AppConfigurationEntryWrapper(String _name, byte _flag, Map props) {
        this.setName(_name);
        this.setFlag(_flag);
        this.setOptions(props);
    }

    public AppConfigurationEntryWrapper(AppConfigurationEntry entry) {
        this.setEntry(entry);
    }

    public void setEntry(AppConfigurationEntry _entry) {
        this.setName(_entry.getLoginModuleName());
        this.setControlFlag(_entry.getControlFlag());
        this.setOptions(_entry.getOptions());
    }

    public AppConfigurationEntry getEntry() {
        if (this.name == null || this.name.equals("")) {
            return null;
        }
        if (this.flag < 0 || this.flag > 3) {
            return null;
        }
        return new AppConfigurationEntry(this.name, this.getControlFlag(), this.options);
    }

    public void setName(String entryName) {
        this.name = entryName;
    }

    public String getName() {
        return this.name;
    }

    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        switch (this.flag) {
            case 0: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            case 1: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            }
            case 2: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            case 3: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
        }
        return null;
    }

    public void setControlFlag(AppConfigurationEntry.LoginModuleControlFlag _flag) {
        this.flag = _flag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL ? (byte)0 : (_flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED ? (byte)1 : (_flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE ? (byte)2 : (_flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT ? (byte)3 : (byte)-1)));
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setFlag(byte _flag) {
        this.flag = _flag < 0 || _flag > 3 ? (byte)-1 : _flag;
    }

    public void setOptions(Map props) {
        if (props == null) {
            this.options = null;
        } else {
            this.options = new Properties();
            ((Hashtable)this.options).putAll(props);
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public void addOption(String key, String value) {
        if (key == null || key.equals("") || value == null || value.equals("")) {
            return;
        }
        this.options.setProperty(key, value);
    }

    public Object clone() {
        AppConfigurationEntryWrapper cloning = new AppConfigurationEntryWrapper();
        cloning.name = this.name == null ? null : new String(this.name);
        cloning.flag = this.flag;
        if (this.options == null) {
            cloning.options = null;
        } else {
            Properties newProps = new Properties();
            Enumeration enumeration = ((Hashtable)this.options).keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = (String)((Hashtable)this.options).get(key);
                newProps.setProperty(new String(key), new String(value));
            }
            cloning.options = newProps;
        }
        return cloning;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AppConfigurationEntryWrapper)) {
            return false;
        }
        AppConfigurationEntryWrapper entry = (AppConfigurationEntryWrapper)obj;
        if (this.name != null ? !this.name.equals(entry.name) : entry.name != null) {
            return false;
        }
        if (this.flag != entry.flag) {
            return false;
        }
        return EqualUtils.equalObjects(this.options, entry.options);
    }
}

