/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import java.io.Serializable;

public class WebResourceCollection
implements Serializable {
    static final long serialVersionUID = -3138328817265848775L;
    protected String webResourceName = "";
    protected String description = null;
    protected String[] urlPattern = null;
    protected String[] httpMethod = null;

    public WebResourceCollection() {
    }

    public WebResourceCollection(String name) {
        this.webResourceName = name;
    }

    public WebResourceCollection(String name, String[] httpMethods, String[] urlPatterns) {
        this.webResourceName = name;
        this.httpMethod = httpMethods;
        this.urlPattern = urlPatterns;
    }

    public String getWebResourceName() {
        return this.webResourceName;
    }

    public void setWebResourceName(String _webResourceName) {
        this.webResourceName = _webResourceName;
    }

    public String[] getHttpMethod() {
        return this.httpMethod;
    }

    public void addHttpMethod(String method) {
        if (method == null) {
            return;
        }
        if (this.httpMethod == null || this.httpMethod.length == 0) {
            this.httpMethod = new String[1];
            this.httpMethod[0] = method;
        } else {
            int i = 0;
            while (i < this.httpMethod.length) {
                if (method.equals(this.httpMethod[i])) {
                    return;
                }
                ++i;
            }
            String[] methods = new String[this.httpMethod.length + 1];
            System.arraycopy(this.httpMethod, 0, methods, 0, this.httpMethod.length);
            methods[this.httpMethod.length] = method;
            this.httpMethod = methods;
        }
    }

    public void removeHttpMethod(String method) {
        if (method == null) {
            return;
        }
        if (this.httpMethod == null || this.httpMethod.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.httpMethod.length) {
            if (method.equals(this.httpMethod[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            String[] newHTTPMethods = new String[this.httpMethod.length - 1];
            System.arraycopy(this.httpMethod, 0, newHTTPMethods, 0, index);
            System.arraycopy(this.httpMethod, index + 1, newHTTPMethods, index, this.httpMethod.length - 1 - index);
            this.httpMethod = newHTTPMethods;
        }
    }

    public void setHttpMethod(String[] _httpMethod) {
        this.httpMethod = _httpMethod;
    }

    public String[] getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String[] _urlPattern) {
        this.urlPattern = _urlPattern;
    }

    public void addUrlPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        if (this.urlPattern == null || this.urlPattern.length == 0) {
            this.urlPattern = new String[1];
            this.urlPattern[0] = pattern;
        } else {
            int i = 0;
            while (i < this.urlPattern.length) {
                if (pattern.equals(this.urlPattern[i])) {
                    return;
                }
                ++i;
            }
            String[] patterns = new String[this.urlPattern.length + 1];
            System.arraycopy(this.urlPattern, 0, patterns, 0, this.urlPattern.length);
            patterns[this.urlPattern.length] = pattern;
            this.urlPattern = patterns;
        }
    }

    public void removeUrlPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        if (this.urlPattern == null || this.urlPattern.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.urlPattern.length) {
            if (pattern.equals(this.urlPattern[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            String[] newURLPatterns = new String[this.urlPattern.length - 1];
            System.arraycopy(this.urlPattern, 0, newURLPatterns, 0, index);
            System.arraycopy(this.urlPattern, index + 1, newURLPatterns, index, this.urlPattern.length - 1 - index);
            this.urlPattern = newURLPatterns;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof WebResourceCollection)) return false;
        if (this.webResourceName != null ? !this.webResourceName.equals(((WebResourceCollection)obj).getWebResourceName()) : ((WebResourceCollection)obj).getWebResourceName() != null) {
            return false;
        }
        String[] patterns = ((WebResourceCollection)obj).getUrlPattern();
        if (this.urlPattern != null) {
            if (patterns == null) return false;
            if (this.urlPattern.length != patterns.length) return false;
            int index = -1;
            int i = 0;
            while (i < this.urlPattern.length) {
                index = -1;
                int j = 0;
                while (j < patterns.length) {
                    if (this.urlPattern[i] != null) {
                        if (this.urlPattern[i].equals(patterns[j])) {
                            index = j;
                            break;
                        }
                    } else if (this.urlPattern[i] == patterns[j]) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (patterns != null) {
            return false;
        }
        String[] methods = ((WebResourceCollection)obj).getHttpMethod();
        if (this.httpMethod != null) {
            if (methods == null) return false;
            if (this.httpMethod.length != methods.length) return false;
            int index = -1;
            int i = 0;
            while (i < this.httpMethod.length) {
                index = -1;
                int j = 0;
                while (j < methods.length) {
                    if (this.httpMethod[i] != null) {
                        if (this.httpMethod[i].equals(methods[j])) {
                            index = j;
                            break;
                        }
                    } else if (this.httpMethod[i] == methods[j]) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
            return !(this.description != null ? !this.description.equals(((WebResourceCollection)obj).getDescription()) : ((WebResourceCollection)obj).description != null);
        } else {
            if (methods == null) return !(this.description != null ? !this.description.equals(((WebResourceCollection)obj).getDescription()) : ((WebResourceCollection)obj).description != null);
            return false;
        }
    }
}

