/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.servlets_jsp.descriptor.WebComponentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWrongDescriptorException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ServletDescriptor
extends WebComponentDescriptor
implements Serializable {
    static final long serialVersionUID = -6018392525410460985L;
    private String servletName = null;
    private String servletClass = null;
    private String jspFile = null;
    private int loadOnStartup = -1;
    private RunAsIdentity runAs = null;
    private SecurityRoleReference[] roleReferences = null;
    protected SecurityRoles[] secRole = null;

    public void setServletName(String name) {
        this.servletName = name;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletClass(String clName) {
        this.servletClass = clName;
    }

    public void setJspFile(String jsp) {
        this.jspFile = jsp;
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setLoadOnStartUp(int load) {
        this.loadOnStartup = load;
    }

    public int getLoadOnStartUp() {
        return this.loadOnStartup;
    }

    public RunAsIdentity getRunAs() {
        return this.runAs;
    }

    public void setRunAs(RunAsIdentity run_as) {
        this.runAs = run_as;
    }

    public void setSecRoleRef(SecurityRoles[] secRoles) {
        this.secRole = secRoles;
    }

    public SecurityRoles[] getSecRoleRef() {
        return this.secRole;
    }

    public SecurityRoleReference[] getRoleReferences() {
        return this.roleReferences;
    }

    public void setRoleReferences(SecurityRoleReference[] roleRef) {
        this.roleReferences = roleRef;
    }

    public void setRoleReference(SecurityRoleReference roleRef) {
        if (roleRef == null) {
            return;
        }
        if (this.roleReferences == null || this.roleReferences.length == 0) {
            this.roleReferences = new SecurityRoleReference[1];
            this.roleReferences[0] = roleRef;
        } else {
            int index = -1;
            int i = 0;
            while (i < this.roleReferences.length) {
                if (roleRef.getRoleName().equals(this.roleReferences[i].getRoleName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            SecurityRoleReference[] newRoles = null;
            if (index == -1) {
                newRoles = new SecurityRoleReference[this.roleReferences.length + 1];
                System.arraycopy(this.roleReferences, 0, newRoles, 0, this.roleReferences.length);
                newRoles[this.roleReferences.length] = roleRef;
            } else {
                newRoles = new SecurityRoleReference[this.roleReferences.length];
                System.arraycopy(this.roleReferences, 0, newRoles, 0, index);
                newRoles[index] = roleRef;
                System.arraycopy(this.roleReferences, index + 1, newRoles, index + 1, this.roleReferences.length - index - 1);
            }
            this.roleReferences = newRoles;
        }
    }

    public void addRoleReference(SecurityRoleReference roleRef) {
        if (roleRef == null) {
            return;
        }
        if (this.roleReferences == null || this.roleReferences.length == 0) {
            this.roleReferences = new SecurityRoleReference[1];
            this.roleReferences[0] = roleRef;
        } else {
            int index = -1;
            int i = 0;
            while (i < this.roleReferences.length) {
                if (roleRef.getRoleName().equals(this.roleReferences[i].getRoleName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            SecurityRoleReference[] newRoles = null;
            if (index == -1) {
                newRoles = new SecurityRoleReference[this.roleReferences.length + 1];
                System.arraycopy(this.roleReferences, 0, newRoles, 0, this.roleReferences.length);
                newRoles[this.roleReferences.length] = roleRef;
            } else {
                newRoles = new SecurityRoleReference[this.roleReferences.length];
                System.arraycopy(this.roleReferences, 0, newRoles, 0, index);
                newRoles[index] = roleRef;
                System.arraycopy(this.roleReferences, index + 1, newRoles, index + 1, this.roleReferences.length - index - 1);
            }
            this.roleReferences = newRoles;
        }
    }

    public SecurityRoleReference getSecurityRoleReference(int i) {
        if (this.roleReferences != null && i < this.roleReferences.length && i > -1) {
            return this.roleReferences[i];
        }
        return null;
    }

    public void setName(String name) {
        this.servletName = name;
        if (this.displayName == null) {
            this.displayName = name;
        }
    }

    public String getName() {
        if (this.servletName != null) {
            return this.servletName;
        }
        return this.displayName;
    }

    public void saveToFile(String xmlFileName) {
        StandardDOMWriter writer = new StandardDOMWriter();
        WebDescriptorDocument doc = new WebDescriptorDocument();
        WebDeploymentDescriptor wdd = new WebDeploymentDescriptor();
        ServletDescriptor[] servlets = new ServletDescriptor[]{this};
        wdd.setServlets(servlets);
        Document document = doc.loadSimpleDocumentFromDescriptor(wdd);
        try {
            writer.write(document, xmlFileName, "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>", "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Document getAsDocument() {
        WebDescriptorDocument doc = new WebDescriptorDocument();
        WebDeploymentDescriptor web = new WebDeploymentDescriptor();
        ServletDescriptor[] servlets = new ServletDescriptor[]{this};
        web.setServlets(servlets);
        Document document = doc.loadDocumentFromDescriptor(web);
        return document;
    }

    public void loadFromDocument(Document doc, String elName) {
        WebDescriptorDocument webDoc = new WebDescriptorDocument();
        try {
            WebDeploymentDescriptor webDescriptor = null;
            try {
                webDescriptor = webDoc.loadDescriptorFromDocument(doc);
            }
            catch (WebWrongDescriptorException e) {
                throw new WebIllegalArgumentException("servlet_jsp_0254", e);
            }
            ServletDescriptor[] servlets = webDescriptor.getServlets();
            if (servlets != null) {
                int i = 0;
                while (i < servlets.length) {
                    if (servlets[i].getName().equals(elName)) {
                        this.replaceServletDescriptor(servlets[i]);
                    }
                    ++i;
                }
            }
        }
        catch (WrongStructureException we) {
            we.printStackTrace();
        }
    }

    public void loadFromFile(String xmlFileName, String elName) {
        BufferedInputStream xmlStream = null;
        Document document = null;
        StandardDOMParser parser = new StandardDOMParser();
        WebDescriptorDocument doc = new WebDescriptorDocument();
        try {
            FileInputStream fis = new FileInputStream(xmlFileName);
            xmlStream = new BufferedInputStream(fis);
            parser.setSystemId(xmlFileName);
            document = parser.parse((InputStream)xmlStream);
            WebDeploymentDescriptor webDescriptor = doc.loadDescriptorFromDocument(document);
            ServletDescriptor[] servlets = webDescriptor.getServlets();
            if (servlets != null) {
                int i = 0;
                while (i < servlets.length) {
                    if (servlets[i].getName().equals(elName)) {
                        this.replaceServletDescriptor(servlets[i]);
                    }
                    ++i;
                }
            }
        }
        catch (WrongStructureException we) {
            we.printStackTrace();
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        catch (SAXException exc) {
            exc.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServletDescriptor)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ServletDescriptor descr = (ServletDescriptor)obj;
        if (descr.servletName != null ? !descr.servletName.equals(this.servletName) : this.servletName != null) {
            return false;
        }
        if (descr.servletClass != null ? !descr.servletClass.equals(this.servletClass) : this.servletClass != null) {
            return false;
        }
        if (descr.jspFile != null ? !descr.jspFile.equals(this.jspFile) : this.jspFile != null) {
            return false;
        }
        if (this.loadOnStartup != descr.loadOnStartup) {
            return false;
        }
        if (this.runAs != null ? !this.runAs.equals(descr.runAs) : descr.runAs != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(descr.roleReferences, this.roleReferences)) {
            return false;
        }
        return EqualUtils.equalUnOrderedArrays(descr.secRole, this.secRole);
    }

    public Object clone() {
        int i;
        ServletDescriptor cloning = null;
        try {
            cloning = (ServletDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WebIllegalArgumentException("servlet_jsp_0255", e);
        }
        cloning.setServletName(this.servletName == null ? null : new String(this.servletName));
        cloning.setServletClass(this.servletClass == null ? null : new String(this.servletClass));
        cloning.setJspFile(this.jspFile == null ? null : new String(this.jspFile));
        cloning.setLoadOnStartUp(this.loadOnStartup);
        if (this.runAs != null) {
            cloning.runAs = (RunAsIdentity)this.runAs.clone();
        }
        if (this.roleReferences == null) {
            cloning.roleReferences = null;
        } else {
            cloning.roleReferences = new SecurityRoleReference[this.roleReferences.length];
            i = 0;
            while (i < this.roleReferences.length) {
                try {
                    cloning.roleReferences[i] = this.roleReferences[i] == null ? null : (SecurityRoleReference)this.roleReferences[i].clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new WebIllegalArgumentException("servlet_jsp_0255", e);
                }
                ++i;
            }
        }
        if (this.secRole == null) {
            cloning.secRole = null;
        } else {
            cloning.secRole = new SecurityRoles[this.secRole.length];
            i = 0;
            while (i < this.secRole.length) {
                cloning.secRole[i] = this.secRole[i] == null ? null : (SecurityRoles)this.secRole[i].clone();
                ++i;
            }
        }
        return cloning;
    }

    public void replaceServletDescriptor(ServletDescriptor servletD) {
        if (servletD != null) {
            this.description = servletD.getDescription();
            this.displayName = servletD.getDisplayName();
            this.initParams = servletD.getInitParams();
            this.jspFile = servletD.getJspFile();
            this.loadOnStartup = servletD.getLoadOnStartUp();
            this.secRole = servletD.getSecRoleRef();
            this.roleReferences = servletD.getRoleReferences();
            this.servletClass = servletD.getServletClass();
            this.servletName = servletD.getServletName();
            this.runAs = servletD.getRunAs();
        }
    }
}

