/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import java.io.Serializable;

public class CookieConfig
implements Serializable {
    static final long serialVersionUID = 6540468821601409618L;
    public static final String APPLICATION_PATH = "APPLICATION";
    public static final String SERVER_PATH = "SERVER";
    public static final String NONE_PATH = "NONE";
    public static final String SERVER_DOMAIN = "SERVER";
    public static final String NONE_DOMAIN = "NONE";
    public static final String APPLICATION_TYPE = "APPLICATION";
    public static final String SESSION_TYPE = "SESSION";
    private static final String NOT_SET = "NOT_SET";
    public static final int APPLICATION_INT = 1;
    public static final int SESSION_INT = 0;
    String type = "SESSION";
    String path = "SERVER";
    String domain = "NOT_SET";
    int maxAge = -1;

    public CookieConfig() {
    }

    public CookieConfig(String type) {
        this.type = type;
    }

    public CookieConfig(String type, String path, String domain, int maxAge) {
        this.type = type;
        this.path = path;
        this.domain = domain;
        this.maxAge = maxAge;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null || type.trim().equals("")) {
            this.type = SESSION_TYPE;
            return;
        }
        if (!(type = type.trim()).equals(SESSION_TYPE) && !type.equals("APPLICATION")) {
            throw new WebIllegalArgumentException("servlet_jsp_0300", new Object[]{type, SESSION_TYPE, "APPLICATION"});
        }
        this.type = type;
    }

    public void setType(int itype) {
        if (itype == 0) {
            this.type = SESSION_TYPE;
        } else if (itype == 1) {
            this.type = "APPLICATION";
        }
    }

    public int getIntType() {
        int result = -1;
        if (this.type.equals(SESSION_TYPE)) {
            result = 0;
        } else if (this.type.equals("APPLICATION")) {
            result = 1;
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        if (NOT_SET.equals(this.domain)) {
            if ("APPLICATION".equals(this.type)) {
                return "NONE";
            }
            if (SESSION_TYPE.equals(this.type)) {
                return "SERVER";
            }
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

