/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.policy;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.AuthorizationContext;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.userstore.config.AuthenticationDescriptor;
import com.sap.engine.interfaces.security.userstore.config.AuthorizationDescriptor;
import com.sap.engine.interfaces.security.userstore.config.PolicyDescriptor;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.StorageLockedException;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import com.sap.engine.services.security.server.AuthorizationContextImpl;
import com.sap.engine.services.security.userstore.policy.DefaultPolicyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyInitializer {
    private SecurityContext root = null;

    public void initialize(SecurityContext root) throws ServiceException {
        try {
            this.root = root;
            ByteArrayInputStream in = new ByteArrayInputStream(SecurityServerFrame.getServiceProperties().getProperty("policy.xml").getBytes());
            this.parse(in);
            ((InputStream)in).close();
        }
        catch (ServiceException se) {
            se.printStackTrace();
            throw se;
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().log((byte)4, "Cannot initialize PolicyInitializer.");
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
    }

    public void parse(InputStream in) throws Exception {
        SystemProperties.setProperty("server.parser.inqmy", "yes");
        StandardDOMParser parser = new StandardDOMParser();
        Document document = parser.parse(in);
        Node descriptor = null;
        NodeList descriptorList = document.getChildNodes();
        int i = 0;
        while (i < descriptorList.getLength()) {
            descriptor = descriptorList.item(i);
            if (descriptor.getNodeType() == 1) break;
            ++i;
        }
        if (descriptor != null) {
            NodeList storesList = descriptor.getChildNodes();
            int i2 = 0;
            while (i2 < storesList.getLength()) {
                Node userstoreElement = storesList.item(i2);
                if (userstoreElement.getNodeType() == 1) {
                    try {
                        DefaultPolicyDescriptor policy = new DefaultPolicyDescriptor(storesList.item(i2));
                        this.initializeUserStore(this.root, policy);
                    }
                    catch (ServiceException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        SecurityServerFrame.getLogger().log((byte)4, "Cannot parse <policy.xml>.");
                        SecurityServerFrame.getLogger().logThrowable((byte)4, e);
                    }
                }
                ++i2;
            }
        }
    }

    public void initializeUserStore(SecurityContext root, PolicyDescriptor policy) {
        this.root = root;
        Enumeration enumeration = policy.listPolicyConfigurations();
        while (enumeration.hasMoreElements()) {
            String config = (String)enumeration.nextElement();
            this.initializeConfiguration(policy, config);
        }
    }

    private void initializeConfiguration(PolicyDescriptor policy, String configuration) {
        SecurityContext sCtx = this.root.getPolicyConfigurationContext(configuration);
        if (sCtx == null) {
            while (true) {
                try {
                    this.root.registerPolicyConfiguration(configuration);
                    sCtx = this.root.getPolicyConfigurationContext(configuration);
                    break;
                }
                catch (StorageLockedException sle) {
                    PolicyInitializer policyInitializer = this;
                    synchronized (policyInitializer) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
            }
        }
        ModificationContext modifications = sCtx.getModificationContext();
        modifications.beginModifications();
        try {
            String userstore = policy.getUserStore();
            AuthenticationDescriptor authentication = policy.getAuthenticationDescriptor(configuration);
            AuthorizationDescriptor authorization = policy.getAuthorizationDescriptor(configuration);
            if (authentication != null) {
                AuthenticationContext authCtx = sCtx.getAuthenticationContext();
                if (authentication.getTemplate() != null) {
                    authCtx.setLoginModules(authentication.getTemplate());
                } else {
                    authCtx.setLoginModules(userstore, authentication.listAppConfigurationEntries());
                }
            }
            if (authorization != null) {
                AuthorizationContext authzCtx = sCtx.getAuthorizationContext();
                SecurityRoleContext srCtx = authzCtx.getSecurityRoleContext(userstore);
                String[] roles = authorization.listSecurityRoles();
                int i = 0;
                while (i < roles.length) {
                    SecurityRole role = srCtx.getSecurityRole(roles[i]);
                    if (role == null) {
                        role = srCtx.addSecurityRole(roles[i]);
                    }
                    String[] users = authorization.listUsersInRole(roles[i]);
                    int j = 0;
                    while (j < users.length) {
                        role.addUser(users[j]);
                        ++j;
                    }
                    String[] groups = authorization.listGroupsInRole(roles[i]);
                    int j2 = 0;
                    while (j2 < groups.length) {
                        role.addGroup(groups[j2]);
                        ++j2;
                    }
                    ++i;
                }
            }
            modifications.commitModifications();
        }
        catch (Exception e) {
            modifications.rollbackModifications();
            throw new BaseSecurityException("security_5009", new Object[]{configuration}, e);
        }
        try {
            AuthenticationContext authCtx = sCtx.getAuthenticationContext();
            AuthorizationContext authzCtx = sCtx.getAuthorizationContext();
            ((AuthorizationContextImpl)authzCtx).update();
            ((AuthenticationContextImpl)authCtx).update();
        }
        catch (Exception e) {
            throw new BaseSecurityException("security_5010", new Object[]{configuration}, e);
        }
    }
}

