/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.policy;

import com.sap.engine.interfaces.security.userstore.config.AuthenticationDescriptor;
import com.sap.engine.interfaces.security.userstore.config.AuthorizationDescriptor;
import com.sap.engine.services.security.userstore.policy.DefaultAuthenticationDescriptor;
import com.sap.engine.services.security.userstore.policy.DefaultAuthorizationDescriptor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyConfigurationDescriptor {
    AuthenticationDescriptor authentication = null;
    AuthorizationDescriptor authorization = null;

    public PolicyConfigurationDescriptor(Node node) {
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = list.item(i);
            elementName = element.getNodeName();
            if ("authentication".equalsIgnoreCase(elementName)) {
                this.authentication = new DefaultAuthenticationDescriptor(element);
            } else if ("authorization".equalsIgnoreCase(elementName)) {
                this.authorization = new DefaultAuthorizationDescriptor(element);
            } else if (element.getNodeType() == 1) {
                System.out.println(" unknown element '" + elementName + "' in user-store description.");
            }
            ++i;
        }
    }

    public AuthenticationDescriptor getAuthentication() {
        return this.authentication;
    }

    public AuthorizationDescriptor getAuthorization() {
        return this.authorization;
    }

    public String toString() {
        String s = "";
        s = s + "<configuration>\r\n";
        if (this.getAuthentication() != null) {
            s = s + this.getAuthentication().toString() + "\r\n";
        } else {
            s = s + "<authentication>\r\n";
            s = s + "null\r\n";
            s = s + "</authentication>\r\n";
        }
        if (this.getAuthorization() != null) {
            s = s + this.getAuthorization().toString() + "\r\n";
        } else {
            s = s + "<authorization>\r\n";
            s = s + "null\r\n";
            s = s + "</authorization>\r\n";
        }
        s = s + "</configuration>\r\n";
        return s;
    }
}

