/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.policy;

import com.sap.engine.interfaces.security.userstore.config.AuthenticationDescriptor;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultAuthenticationDescriptor
implements AuthenticationDescriptor {
    private Vector entries = new Vector();
    private String template = null;

    public DefaultAuthenticationDescriptor(Node node) {
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = list.item(i);
            elementName = element.getNodeName();
            if ("entry".equalsIgnoreCase(elementName)) {
                this.readAppEntry(element);
            } else if ("template".equalsIgnoreCase(elementName)) {
                this.readTemplate(element);
            } else if (element.getNodeType() == 1) {
                System.out.println(" unknown element '" + elementName + "' in user-store description.");
            }
            ++i;
        }
    }

    public AppConfigurationEntry[] listAppConfigurationEntries() throws SecurityException {
        AppConfigurationEntry[] result = new AppConfigurationEntry[this.entries.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (AppConfigurationEntry)this.entries.elementAt(i);
            ++i;
        }
        return result;
    }

    public String getTemplate() throws SecurityException {
        return this.template;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readAppEntry(Node node) {
        NodeList list = node.getChildNodes();
        AppConfigurationEntry.LoginModuleControlFlag flag = null;
        String className = null;
        Properties options = new Properties();
        Node element = null;
        String elementName = null;
        int i = 0;
        while (i < list.getLength()) {
            block10: {
                block11: {
                    String theflag;
                    block12: {
                        element = list.item(i);
                        elementName = element.getNodeName();
                        if (!elementName.equals("flag")) break block11;
                        theflag = element.getFirstChild().getNodeValue();
                        if (!theflag.equalsIgnoreCase("requisite")) break block12;
                        flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                        break block10;
                    }
                    if (theflag.equalsIgnoreCase("required")) {
                        flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                        break block10;
                    } else if (theflag.equalsIgnoreCase("sufficient")) {
                        flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                        break block10;
                    } else {
                        if (!theflag.equalsIgnoreCase("optional")) {
                            System.out.println("unknown control flag");
                            return;
                        }
                        flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                    }
                    break block10;
                }
                if (elementName.equals("classname")) {
                    className = element.getFirstChild().getNodeValue();
                } else if (elementName.equals("option")) {
                    NamedNodeMap attributes = element.getAttributes();
                    Node current = null;
                    int j = 0;
                    while (j < attributes.getLength()) {
                        current = attributes.item(j);
                        options.setProperty(current.getNodeName(), current.getNodeValue());
                        ++j;
                    }
                }
            }
            ++i;
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(className, flag, options);
        this.entries.addElement(entry);
    }

    private void readTemplate(Node element) {
        this.template = element.getFirstChild().getNodeValue();
    }

    public String toString() {
        String s = "";
        s = s + "<authentication>\r\n";
        AppConfigurationEntry[] entries = this.listAppConfigurationEntries();
        int i = 0;
        while (i < entries.length) {
            s = s + entries[i].getLoginModuleName() + " " + entries[i].getControlFlag().toString().substring(23) + " " + entries[i].getOptions() + "\r\n";
            ++i;
        }
        s = s + "</authentication>\r\n";
        return s;
    }
}

