/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.persistent;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.server.ModificationContextImpl;
import com.sap.engine.services.security.server.SecurityContextImpl;
import com.sap.engine.services.security.userstore.descriptor.LoginModuleConfigurationImpl;
import com.sap.engine.services.security.userstore.descriptor.UserStoreConfigurationImpl;
import com.sap.engine.services.security.userstore.persistent.UserStoreChangedConfigurationListener;
import java.util.Enumeration;
import java.util.Properties;

public class UserStorePersistent {
    private boolean initialized = false;
    private ModificationContextImpl modificationCtx = null;
    public static final String ACTIVE = "active_userstore";

    public UserStorePersistent(ConfigurationChangedListener listener) {
        try {
            this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
            this.modificationCtx.beginModifications();
            Configuration userstoresContainer = this.modificationCtx.getConfiguration("security/userstores", true, true);
            ((UserStoreChangedConfigurationListener)listener).setPersistentStorage(this);
            this.modificationCtx.registerConfigurationListener(listener, "security/userstores");
            String[] userStores = userstoresContainer.getAllSubConfigurationNames();
            boolean bl = this.initialized = userStores != null && userStores.length > 0;
            if (!this.initialized) {
                if (userstoresContainer.existsConfigEntry(ACTIVE)) {
                    userstoresContainer.modifyConfigEntry(ACTIVE, "");
                } else {
                    userstoresContainer.addConfigEntry(ACTIVE, "");
                }
            } else {
                try {
                    String activeUserStore = (String)userstoresContainer.getConfigEntry(ACTIVE);
                    if (activeUserStore == null || activeUserStore.length() == 0) {
                        userstoresContainer.modifyConfigEntry(ACTIVE, userStores[0]);
                    }
                }
                catch (Exception _) {
                    userstoresContainer.addConfigEntry(ACTIVE, userStores[0]);
                }
            }
            this.modificationCtx.commitModifications();
        }
        catch (Exception e) {
            this.modificationCtx.rollbackModifications();
            throw new BaseSecurityException("security_5001", e);
        }
    }

    public void store(UserStoreConfiguration usConfiguration, String classloaderName) {
        this.lock(usConfiguration.getName());
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration usContainer = this.modificationCtx.getConfiguration("security/userstores/" + usConfiguration.getName(), true, true);
                usContainer.addConfigEntry("classloader", classloaderName == null ? "" : classloaderName);
                usContainer.addConfigEntry("description", usConfiguration.getDescription());
                usContainer.addConfigEntry("user-class-name", usConfiguration.getUserSpiClassName());
                String groupClass = usConfiguration.getGroupSpiClassName();
                usContainer.addConfigEntry("group-class-name", groupClass == null ? "" : groupClass);
                String editor = usConfiguration.getConfigurationEditorClassName();
                usContainer.addConfigEntry("configuration-editor", editor == null ? "" : editor);
                Configuration propsContainer = usContainer.createSubConfiguration("configuration");
                Properties usProps = usConfiguration.getUserStoreProperties();
                Enumeration<?> enumeration = usProps.propertyNames();
                String key = null;
                while (enumeration.hasMoreElements()) {
                    key = (String)enumeration.nextElement();
                    propsContainer.addConfigEntry(key, usProps.getProperty(key));
                }
                Configuration loginModulesContainer = usContainer.createSubConfiguration("login-module");
                LoginModuleConfiguration[] loginModules = usConfiguration.getLoginModules();
                if (loginModules != null) {
                    int i = 0;
                    while (i < loginModules.length) {
                        LoginModuleConfigurationImpl.store(loginModulesContainer, loginModules[i]);
                        ++i;
                    }
                }
                this.modificationCtx.commitModifications();
            }
            catch (Exception e) {
                this.modificationCtx.rollbackModifications();
                throw new BaseSecurityException("security_5002", new Object[]{usConfiguration.getName()}, e);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.releaseLock(usConfiguration.getName());
            throw throwable;
        }
        this.releaseLock(usConfiguration.getName());
    }

    public void modify(UserStoreConfiguration usConfiguration, String classloaderName) {
        this.lock(usConfiguration.getName());
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration usContainer = this.modificationCtx.getConfiguration("security/userstores/" + usConfiguration.getName(), true, false);
                usContainer.modifyConfigEntry("classloader", classloaderName == null ? "" : classloaderName);
                usContainer.modifyConfigEntry("description", usConfiguration.getDescription());
                usContainer.modifyConfigEntry("user-class-name", usConfiguration.getUserSpiClassName());
                String groupClass = usConfiguration.getGroupSpiClassName();
                usContainer.modifyConfigEntry("group-class-name", groupClass == null ? "" : groupClass);
                String editor = usConfiguration.getConfigurationEditorClassName();
                usContainer.modifyConfigEntry("configuration-editor", editor == null ? "" : editor);
                Configuration propsContainer = usContainer.getSubConfiguration("configuration");
                propsContainer.deleteAllConfigEntries();
                Properties usProps = usConfiguration.getUserStoreProperties();
                Enumeration<?> enumeration = usProps.propertyNames();
                String key = null;
                while (enumeration.hasMoreElements()) {
                    key = (String)enumeration.nextElement();
                    propsContainer.addConfigEntry(key, usProps.getProperty(key));
                }
                Configuration loginModulesContainer = usContainer.getSubConfiguration("login-module");
                loginModulesContainer.deleteAllSubConfigurations();
                LoginModuleConfiguration[] loginModules = usConfiguration.getLoginModules();
                if (loginModules != null && loginModules.length > 0) {
                    int i = 0;
                    while (i < loginModules.length) {
                        LoginModuleConfigurationImpl.store(loginModulesContainer, loginModules[i]);
                        ++i;
                    }
                }
                this.modificationCtx.commitModifications();
            }
            catch (Exception e) {
                this.modificationCtx.rollbackModifications();
                throw new BaseSecurityException("security_5003", new Object[]{usConfiguration.getName()}, e);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.releaseLock(usConfiguration.getName());
            throw throwable;
        }
        this.releaseLock(usConfiguration.getName());
    }

    public void delete(String userStoreName) {
        this.lock(userStoreName);
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration userstoresContainer = this.modificationCtx.getConfiguration("security/userstores/" + userStoreName, true, false);
                if (userstoresContainer != null) {
                    userstoresContainer.deleteConfiguration();
                }
                this.modificationCtx.commitModifications();
            }
            catch (Exception e) {
                this.modificationCtx.rollbackModifications();
                throw new BaseSecurityException("security_5004", new Object[]{userStoreName}, e);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.releaseLock(userStoreName);
            throw throwable;
        }
        this.releaseLock(userStoreName);
    }

    public void modify(String userStoreName) {
        this.lock("");
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration userstoresContainer = this.modificationCtx.getConfiguration("security/userstores", true, false);
                userstoresContainer.modifyConfigEntry(ACTIVE, userStoreName);
                this.modificationCtx.commitModifications();
            }
            catch (Exception e) {
                this.modificationCtx.rollbackModifications();
                throw new BaseSecurityException("security_5005", e);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.releaseLock("");
            throw throwable;
        }
        this.releaseLock("");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public UserStoreConfiguration[] loadUserStoreConfigurations() {
        UserStoreConfiguration[] configurations = new UserStoreConfiguration[]{};
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration userstoresContainer = this.modificationCtx.getConfiguration("security/userstores", false, false);
                String[] userStores = userstoresContainer.getAllSubConfigurationNames();
                configurations = new UserStoreConfiguration[userStores.length];
                int i = 0;
                while (i < userStores.length) {
                    configurations[i] = new UserStoreConfigurationImpl(userStores[i], userstoresContainer);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BaseSecurityException("security_5006", e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.modificationCtx.forgetModifications();
            throw throwable;
        }
        this.modificationCtx.forgetModifications();
        return configurations;
    }

    public UserStoreConfiguration loadUserStoreConfiguration(String userstoreName) {
        UserStoreConfigurationImpl userstoreConfiguration = null;
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration userstoresContainer = this.modificationCtx.getConfiguration("security/userstores", false, false);
                userstoreConfiguration = new UserStoreConfigurationImpl(userstoreName, userstoresContainer);
            }
            catch (Exception e) {
                throw new BaseSecurityException("security_5007", new Object[]{userstoreName}, e);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.modificationCtx.forgetModifications();
            throw throwable;
        }
        this.modificationCtx.forgetModifications();
        return userstoreConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getActiveUserStore() {
        String string;
        try {
            try {
                this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                this.modificationCtx.beginModifications();
                Configuration userstoresContainer = this.modificationCtx.getConfiguration("security/userstores", false, false);
                string = (String)userstoresContainer.getConfigEntry(ACTIVE);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("security_5008", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.modificationCtx.forgetModifications();
            throw throwable;
        }
        this.modificationCtx.forgetModifications();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidUserStoreConfiguration(UserStoreConfiguration config) {
        boolean bl;
        block6: {
            boolean bl2;
            block5: {
                try {
                    try {
                        this.modificationCtx = (ModificationContextImpl)SecurityContextImpl.getRoot().getModificationContext();
                        this.modificationCtx.beginModifications();
                        Configuration secConfigs = this.modificationCtx.getConfiguration("security/configurations", false, false);
                        String configEntry = config.getUserStoreProperties().getProperty("CONNECTOR");
                        if (!secConfigs.existsConfigEntry(configEntry)) {
                            bl2 = false;
                            Object var7_8 = null;
                            break block5;
                        }
                        String configPath = (String)secConfigs.getConfigEntry(configEntry);
                        bl = this.modificationCtx.getConfiguration(configPath, false, false) != null;
                        break block6;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        boolean bl3 = false;
                        Object var7_10 = null;
                        this.modificationCtx.forgetModifications();
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.modificationCtx.forgetModifications();
                    throw throwable;
                }
            }
            this.modificationCtx.forgetModifications();
            return bl2;
        }
        Object var7_9 = null;
        this.modificationCtx.forgetModifications();
        return bl;
    }

    private void lock(String name) throws SecurityException {
        long beginTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= beginTime + 60000L) {
            try {
                SecurityServerFrame.internalLock.lock("$service.security", "userstore_" + name + "_lock", 'X');
                return;
            }
            catch (Exception e) {
                UserStorePersistent userStorePersistent = this;
                synchronized (userStorePersistent) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException ex) {
                        throw new BaseSecurityException("security_5050", ex);
                    }
                }
            }
        }
        throw new BaseSecurityException("security_5050");
    }

    private void releaseLock(String name) throws SecurityException {
        try {
            SecurityServerFrame.internalLock.unlock("$service.security", "userstore_" + name + "_lock", 'X');
        }
        catch (Exception e) {
            throw new BaseSecurityException("security_5051", new Object[]{"userstore_" + name + "_lock"}, e);
        }
    }
}

