/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.persistent;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.server.UserStoreFactoryCache;
import com.sap.engine.services.security.userstore.descriptor.UserStoreConfigurationImpl;
import com.sap.engine.services.security.userstore.persistent.UserStorePersistent;

public class UserStoreChangedConfigurationListener
implements ConfigurationChangedListener {
    private UserStoreFactoryCache cache = null;
    private UserStorePersistent persistentStorage = null;

    public UserStoreChangedConfigurationListener(UserStoreFactoryCache cache) {
        this.cache = cache;
    }

    public void setPersistentStorage(UserStorePersistent persistent) {
        this.persistentStorage = persistent;
    }

    public void configurationChanged(ChangeEvent e) {
        ChangeEvent[] events = e.getDetailedChangeEvents();
        if (events[0].getPath().equals("security/userstores") && events[0].getAction() == 0) {
            String path;
            if (events.length == 1) {
                try {
                    this.cache.setActiveUserStore(this.persistentStorage.getActiveUserStore());
                }
                catch (SecurityException se) {
                    SecurityServerFrame.getLogger().logThrowable((byte)4, se);
                }
            } else if (events[1].getAction() == 1) {
                String path2 = events[1].getPath();
                if (path2.startsWith("security/userstores/")) {
                    String newUserStoreName = path2.substring(path2.lastIndexOf("/") + 1);
                    UserStoreConfiguration userStoreConfiguration = this.persistentStorage.loadUserStoreConfiguration(newUserStoreName);
                    String loaderName = ((UserStoreConfigurationImpl)userStoreConfiguration).getClassLoaderName();
                    try {
                        this.cache.registerUserStore(userStoreConfiguration, loaderName);
                    }
                    catch (SecurityException se) {
                        SecurityServerFrame.getLogger().logThrowable((byte)4, se);
                    }
                }
            } else if (events[1].getAction() == 2 && (path = events[1].getPath()).startsWith("security/userstores/")) {
                String userStoreName = path.substring(path.lastIndexOf("/") + 1);
                try {
                    this.cache.unregisterUserStore(userStoreName);
                }
                catch (SecurityException se) {
                    SecurityServerFrame.getLogger().logThrowable((byte)4, se);
                }
            }
        } else if (events[0].getPath().startsWith("security/userstores/")) {
            String path = events[0].getPath();
            String userstoreName = path.substring(path.lastIndexOf("/") + 1);
            UserStoreConfiguration userStoreConfiguration = this.persistentStorage.loadUserStoreConfiguration(userstoreName);
            ClassLoader loader = null;
            String loaderName = ((UserStoreConfigurationImpl)userStoreConfiguration).getClassLoaderName();
            loader = loaderName != null && !loaderName.equals("") ? SecurityServerFrame.getServiceContext().getCoreContext().getLoadContext().getClassLoader(loaderName) : this.getClass().getClassLoader();
            try {
                this.cache.updateUserStore(userStoreConfiguration, loader);
            }
            catch (SecurityException se) {
                SecurityServerFrame.getLogger().logThrowable((byte)4, se);
            }
        }
    }
}

