/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.descriptor;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.userstore.descriptor.ConnectorLoginModuleConfiguration;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ExtendedConnectorUserstoreConfiguration
implements UserStoreConfiguration {
    private UserStoreConfiguration baseUserStoreConfig = null;

    public ExtendedConnectorUserstoreConfiguration(UserStoreConfiguration baseUserStoreConfig) {
        this.baseUserStoreConfig = baseUserStoreConfig;
    }

    public void clearStartupConfiguration() {
        try {
            Method method = this.baseUserStoreConfig.getClass().getMethod("clearStartupConfiguration", null);
            if (method != null) {
                method.invoke((Object)this.baseUserStoreConfig, null);
            }
        }
        catch (Throwable e) {
            SecurityServerFrame.getLogger().logThrowable((byte)3, e);
        }
    }

    public String getDescription() {
        return this.baseUserStoreConfig.getDescription();
    }

    public String getAnonymousUser() {
        return "none";
    }

    public String getName() {
        return this.baseUserStoreConfig.getName();
    }

    public LoginModuleConfiguration[] getLoginModules() {
        LoginModuleConfiguration[] allLoginModules = null;
        LoginModuleConfiguration[] basedLoginModulesArray = this.baseUserStoreConfig.getLoginModules();
        LoginModuleConfiguration[] extLoginModulesArray = new LoginModuleConfiguration[]{new ConnectorLoginModuleConfiguration("CallerImpersonationMappingLoginModule"), new ConnectorLoginModuleConfiguration("ConfiguredIdentityMappingLoginModule"), new ConnectorLoginModuleConfiguration("CredentialsMappingLoginModule"), new ConnectorLoginModuleConfiguration("PrincipalMappingLoginModule"), new ConnectorLoginModuleConfiguration("CreateAssertionTicketLoginModule")};
        Hashtable<String, LoginModuleConfiguration> basedLoginModules = new Hashtable<String, LoginModuleConfiguration>();
        if (basedLoginModulesArray != null) {
            int i = 0;
            while (i < basedLoginModulesArray.length) {
                String basedLoginModuleName;
                if (!(basedLoginModulesArray[i] == null || (basedLoginModuleName = basedLoginModulesArray[i].getName()).equals("CallerImpersonationMappingLoginModule") || basedLoginModuleName.equals("CredentialsMappingLoginModule") || basedLoginModuleName.equals("ConfiguredIdentityMappingLoginModule") || basedLoginModuleName.equals("PrincipalMappingLoginModule"))) {
                    if (basedLoginModuleName.equals("CreateAssertionTicketLoginModule")) {
                        extLoginModulesArray[4] = basedLoginModulesArray[i];
                    } else {
                        basedLoginModules.put(basedLoginModuleName, basedLoginModulesArray[i]);
                    }
                }
                ++i;
            }
            basedLoginModulesArray = new LoginModuleConfiguration[basedLoginModules.size()];
            int i2 = 0;
            Enumeration loginModuleNames = basedLoginModules.keys();
            while (loginModuleNames.hasMoreElements()) {
                String loginModuleName = (String)loginModuleNames.nextElement();
                basedLoginModulesArray[i2++] = (LoginModuleConfiguration)basedLoginModules.get(loginModuleName);
            }
            allLoginModules = new LoginModuleConfiguration[basedLoginModulesArray.length + extLoginModulesArray.length];
            System.arraycopy(basedLoginModulesArray, 0, allLoginModules, 0, basedLoginModulesArray.length);
            System.arraycopy(extLoginModulesArray, 0, allLoginModules, basedLoginModulesArray.length, extLoginModulesArray.length);
        } else {
            allLoginModules = extLoginModulesArray;
        }
        return allLoginModules;
    }

    public String getUserSpiClassName() {
        return this.baseUserStoreConfig.getUserSpiClassName();
    }

    public String getGroupSpiClassName() {
        return this.baseUserStoreConfig.getGroupSpiClassName();
    }

    public Properties getUserStoreProperties() {
        return this.baseUserStoreConfig.getUserStoreProperties();
    }

    public String getConfigurationEditorClassName() {
        return this.baseUserStoreConfig.getConfigurationEditorClassName();
    }
}

