/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.descriptor;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultLoginModuleConfiguration
implements LoginModuleConfiguration {
    private String name;
    private String description;
    private String loginModuleClassName;
    private Properties options = new Properties();
    private String[] suitableAuth = new String[0];
    private String[] notSuitableAuth = new String[0];
    private String editor = null;

    public DefaultLoginModuleConfiguration(Node node) {
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = list.item(i);
            elementName = element.getNodeName();
            if ("display-name".equalsIgnoreCase(elementName)) {
                this.readDisplayName(element);
            } else if ("description".equalsIgnoreCase(elementName)) {
                this.readDescription(element);
            } else if ("class-name".equalsIgnoreCase(elementName)) {
                this.readLoginModuleClassName(element);
            } else if ("options".equalsIgnoreCase(elementName)) {
                this.readOption(element);
            } else if ("suitable-mechanism".equalsIgnoreCase(elementName)) {
                this.readSuitableMechanism(element);
            } else if ("not-suitable-mechanism".equalsIgnoreCase(elementName)) {
                this.readNotSuitableMechanism(element);
            } else if ("options-editor".equalsIgnoreCase(elementName)) {
                this.readOptionsEditor(element);
            } else if (element.getNodeType() == 1) {
                System.out.println(" unknown element '" + elementName + "' in login-module description.");
            }
            ++i;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String[] getNotSuitableAuthenticationMechanisms() {
        return this.notSuitableAuth;
    }

    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public Map getOptions() {
        return this.options;
    }

    public String[] getSuitableAuthenticationMechanisms() {
        return this.suitableAuth;
    }

    public String getOptionsEditor() {
        return this.editor;
    }

    private void readOption(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node current = null;
        int i = 0;
        while (i < attributes.getLength()) {
            current = attributes.item(i);
            this.options.setProperty(current.getNodeName(), current.getNodeValue());
            ++i;
        }
    }

    private void readDisplayName(Node node) {
        this.name = node.getFirstChild().getNodeValue();
    }

    private void readDescription(Node node) {
        this.description = node.getFirstChild().getNodeValue();
    }

    private void readLoginModuleClassName(Node node) {
        this.loginModuleClassName = node.getFirstChild().getNodeValue();
    }

    private void readOptionsEditor(Node node) {
        this.editor = node.getFirstChild().getNodeValue();
    }

    private void readSuitableMechanism(Node node) {
        String auth = node.getFirstChild().getNodeValue();
        String[] temp = new String[this.suitableAuth.length + 1];
        System.arraycopy(this.suitableAuth, 0, temp, 0, this.suitableAuth.length);
        temp[this.suitableAuth.length] = auth;
        this.suitableAuth = temp;
    }

    private void readNotSuitableMechanism(Node node) {
        String auth = node.getFirstChild().getNodeValue();
        String[] temp = new String[this.notSuitableAuth.length + 1];
        System.arraycopy(this.notSuitableAuth, 0, temp, 0, this.notSuitableAuth.length);
        temp[this.notSuitableAuth.length] = auth;
        this.notSuitableAuth = temp;
    }
}

