/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.descriptor;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import java.util.Map;
import java.util.Properties;

public class ConnectorLoginModuleConfiguration
implements LoginModuleConfiguration {
    static final String CONFIGURED_IDENTITY_NAME = "ConfiguredIdentityMappingLoginModule";
    static final String CALLER_IMPERSONATION_NAME = "CallerImpersonationMappingLoginModule";
    static final String CREDENTIALS_MAPPING_NAME = "CredentialsMappingLoginModule";
    static final String PRINCIPAL_MAPPING_NAME = "PrincipalMappingLoginModule";
    static final String GENERIC_CREDENTIAL_NAME = "CreateAssertionTicketLoginModule";
    private String name = null;
    private String description = null;
    private String loginModuleClassName = null;
    private Properties options = new Properties();
    private String[] suitableAuth = new String[0];
    private String[] notSuitableAuth = new String[0];

    public ConnectorLoginModuleConfiguration(String authenticationMechanismName) {
        this.name = authenticationMechanismName;
        if (authenticationMechanismName.equals(GENERIC_CREDENTIAL_NAME)) {
            this.description = "Login module to create SAP Authentication Assertion Tickets after successful logon";
            this.loginModuleClassName = "com.sap.security.core.server.jaas.CreateAssertionTicketLoginModule";
        } else if (authenticationMechanismName.equals(CONFIGURED_IDENTITY_NAME)) {
            this.description = "Login module that performs <Configured Identity> authentication mechanism for login to an EIS";
            this.loginModuleClassName = "com.sap.engine.services.security.server.jaas.mapping.ConfiguredIdentityMappingLoginModule";
        } else if (authenticationMechanismName.equals(CALLER_IMPERSONATION_NAME)) {
            this.description = "Login module that performs <Caller Impersonation> authentication mechanism for login to an EIS";
            this.loginModuleClassName = "com.sap.engine.services.security.server.jaas.mapping.CallerImpersonationMappingLoginModule";
        } else if (authenticationMechanismName.equals(CREDENTIALS_MAPPING_NAME)) {
            this.description = "Login module that performs <Credentials Mapping> authentication mechanism for login to an EIS";
            this.loginModuleClassName = "com.sap.engine.services.security.server.jaas.mapping.CredentialsMappingLoginModule";
        } else {
            this.description = "Login module that performs <Principal Mapping> authentication mechanism for login to an EIS";
            this.loginModuleClassName = "com.sap.engine.services.security.server.jaas.mapping.PrincipalMappingLoginModule";
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String[] getNotSuitableAuthenticationMechanisms() {
        return this.notSuitableAuth;
    }

    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public Map getOptions() {
        return this.options;
    }

    public String[] getSuitableAuthenticationMechanisms() {
        return this.suitableAuth;
    }

    public String getOptionsEditor() {
        return null;
    }
}

