/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.interfaces.log.Logger;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.server.UserStoreFactoryCache;
import com.sap.engine.services.security.server.UserStoreFactoryImpl;
import com.sap.engine.services.security.userstore.RemoteUserStoreFactoryImpl;
import com.sap.engine.services.security.userstore.descriptor.DefaultUserStoreConfiguration;
import com.sap.engine.services.security.userstore.policy.PolicyInitializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserStoreService {
    private UserStoreFactoryCache cache;
    private UserStoreFactoryImpl factory;
    private RemoteUserStoreFactory remote;
    private boolean initialized = false;
    private Logger logger = null;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserStoreService(SecurityContext root) throws ServiceException {
        InputStream in = null;
        this.logger = SecurityServerFrame.getLogger();
        this.cache = new UserStoreFactoryCache();
        this.factory = new UserStoreFactoryImpl(this.cache);
        this.initialized = this.factory.isInitialized();
        if (!this.initialized) {
            in = new ByteArrayInputStream(SecurityServerFrame.getServiceProperties().getProperty("userstore.xml").getBytes());
            this.parse(in);
            in.close();
        }
        this.remote = new RemoteUserStoreFactoryImpl((UserStoreFactory)this.factory);
        Object var5_3 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {
            SecurityServerFrame.getLogger().logThrowable((byte)3, e2);
        }
        return;
        {
            catch (Throwable e) {
                SecurityServerFrame.getLogger().log((byte)4, "Cannot initialize UserStoreService.");
                SecurityServerFrame.getLogger().logThrowable((byte)4, e);
                Object var5_4 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {
                    SecurityServerFrame.getLogger().logThrowable((byte)3, e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                SecurityServerFrame.getLogger().logThrowable((byte)3, e2);
            }
            throw throwable;
        }
    }

    public void initializePolicy(SecurityContext sc) throws ServiceException {
        if (!this.initialized) {
            try {
                new PolicyInitializer().initialize(sc);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Throwable e) {
                SecurityServerFrame.getLogger().log((byte)4, "Cannot initialize UserStoreService.");
                SecurityServerFrame.getLogger().logThrowable((byte)4, e);
            }
        }
    }

    public UserStoreFactory getUserStoreFactory() {
        return this.factory;
    }

    public RemoteUserStoreFactory getRemoteUserStoreFactory() {
        return this.remote;
    }

    private void parse(InputStream in) throws Exception {
        SystemProperties.setProperty("server.parser.inqmy", "yes");
        ClassLoader loader = this.getClass().getClassLoader();
        StandardDOMParser parser = new StandardDOMParser();
        Document document = parser.parse(in);
        Node descriptor = null;
        NodeList descriptorList = document.getChildNodes();
        int i = 0;
        while (i < descriptorList.getLength()) {
            descriptor = descriptorList.item(i);
            if (descriptor.getNodeType() == 1) break;
            ++i;
        }
        if (descriptor != null) {
            NodeList storesList = descriptor.getChildNodes();
            int i2 = 0;
            while (i2 < storesList.getLength()) {
                Node userstoreElement = storesList.item(i2);
                if (userstoreElement.getNodeType() == 1) {
                    try {
                        DefaultUserStoreConfiguration config = new DefaultUserStoreConfiguration(storesList.item(i2));
                        this.logUserStoreConfiguration(config);
                        this.factory.registerUserStore((UserStoreConfiguration)config, loader);
                        if (config.isActive()) {
                            this.factory.setActiveUserStore(config.getName());
                        }
                    }
                    catch (Exception e) {
                        SecurityServerFrame.getLogger().log((byte)4, "Cannot parse <userstore.xml>.");
                        SecurityServerFrame.getLogger().logThrowable((byte)4, e);
                    }
                }
                ++i2;
            }
        }
    }

    private void logUserStoreConfiguration(DefaultUserStoreConfiguration config) {
        this.logger.log((byte)2, "UserStoreConfiguration " + config.getName());
        this.logger.log((byte)2, "UserContextSpi " + config.getUserSpiClassName());
        this.logger.log((byte)2, "GroupContextSpi " + config.getGroupSpiClassName());
        this.logger.log((byte)2, "IsActive " + config.isActive());
        LoginModuleConfiguration[] loginModules = config.getLoginModules();
        int i = 0;
        while (i < loginModules.length) {
            this.logger.log((byte)2, "LoginModuleConfiguration " + loginModules[i].getName());
            this.logger.log((byte)2, "LoginModuleClassName " + loginModules[i].getLoginModuleClassName());
            ++i;
        }
    }
}

