/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore;

import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import com.sap.engine.services.security.userstore.RemoteIteratorImpl;
import java.rmi.RemoteException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.rmi.PortableRemoteObject;

public class RemoteUserInfoImpl
extends PortableRemoteObject
implements RemoteUserStoreInfo {
    private UserInfo info = null;

    public RemoteUserInfoImpl(UserInfo info) throws RemoteException {
        this.info = info;
    }

    public Principal getPrincipal() {
        return this.info.getPrincipal();
    }

    public String getName() {
        return this.info.getName();
    }

    public RemoteIterator getParentGroups() throws RemoteException {
        return new RemoteIteratorImpl(this.info.getParentGroups());
    }

    public Object readUserProperty(int userProperty) throws RemoteException {
        return this.info.readUserProperty(userProperty);
    }

    public void writeUserProperty(int userProperty, Object value) throws RemoteException {
        if (userProperty == 9) {
            try {
                this.info.setPassword((char[])value);
            }
            catch (ClassCastException cce) {
                throw new SecurityException("Password must be of type char[].");
            }
        }
        this.info.writeUserProperty(userProperty, value);
    }

    public boolean checkUserProperty(int userProperty, Object value) throws RemoteException {
        if (userProperty == 9) {
            try {
                return this.info.checkPassword((char[])value);
            }
            catch (ClassCastException cce) {
                throw new SecurityException("Password must be of type char[].");
            }
        }
        return this.info.checkUserProperty(userProperty, value);
    }

    public void setPassword(char[] oldPassword, char[] newPassword) throws RemoteException {
        this.info.setPassword(oldPassword, newPassword);
    }

    public X509Certificate[] getCertificates() throws RemoteException {
        return this.info.getCertificates();
    }

    public void setCertificates(X509Certificate[] certificates) throws RemoteException {
        this.info.setCertificates(certificates);
    }
}

