/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore;

import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.services.security.remote.RemoteFilterPassword;
import com.sap.engine.services.security.remote.RemoteFilterUsername;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteUserContext;
import com.sap.engine.services.security.remote.RemoteUserInfo;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import com.sap.engine.services.security.userstore.RemoteFilterPasswordImpl;
import com.sap.engine.services.security.userstore.RemoteFilterUsernameImpl;
import com.sap.engine.services.security.userstore.RemoteIteratorImpl;
import com.sap.engine.services.security.userstore.RemoteUserInfoImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class RemoteUserContextImpl
extends PortableRemoteObject
implements RemoteUserContext {
    private UserContext context = null;

    public RemoteUserContextImpl(UserContext context) throws RemoteException {
        this.context = context;
    }

    public RemoteIterator listUsers() throws RemoteException {
        return new RemoteIteratorImpl(this.context.listUsers());
    }

    public RemoteIterator searchUsers(SearchFilter filter) throws RemoteException {
        return new RemoteIteratorImpl(this.context.searchUsers(filter));
    }

    public RemoteUserStoreInfo getUserInfo(String userName) throws RemoteException {
        return new RemoteUserInfoImpl(this.context.getUserInfo(userName));
    }

    public RemoteUserStoreInfo createUser(String userName) throws RemoteException {
        return new RemoteUserInfoImpl(this.context.createUser(userName));
    }

    public void deleteUser(String userName) throws RemoteException {
        this.context.deleteUser(userName);
    }

    public RemoteFilterUsername getFilterUsername() throws RemoteException {
        return new RemoteFilterUsernameImpl(this.context);
    }

    public void setFilterUsername(FilterUsername filter) throws RemoteException {
        this.context.setFilterUsername(filter);
    }

    public RemoteFilterPassword getFilterPassword() throws RemoteException {
        return new RemoteFilterPasswordImpl(this.context);
    }

    public void setFilterPassword(FilterPassword filter) throws RemoteException {
        this.context.setFilterPassword(filter);
    }

    public boolean isUserPropertySupported(int userProperty, int operation) throws RemoteException {
        return this.context.isUserPropertySupported(userProperty, operation);
    }

    public boolean isSubjectRetrievalSupported() throws RemoteException {
        return this.context.isSubjectRetrievalSupported();
    }

    public long fillSubject(RemoteUserInfo user, Subject subject) throws RemoteException {
        return this.context.fillSubject(this.context.getUserInfo(user.getName()), subject);
    }

    public RemoteIterator listRootUsers() throws RemoteException {
        return new RemoteIteratorImpl(this.context.listRootUsers());
    }

    public int getLockAfterInvalidAttempts() {
        return this.context.getLockAfterInvalidAttempts();
    }

    public SearchFilter getSearchFilter() {
        return this.context.getSearchFilter();
    }

    public boolean isInEmergencyMode() {
        return this.context.isInEmergencyMode();
    }

    public boolean isEmergencyUser(String userName) {
        return this.context.isEmergencyUser(userName);
    }

    public void refresh(String userName) {
        this.context.refresh(userName);
    }
}

