/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl.roles;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.services.security.exceptions.BaseRemoteException;
import com.sap.engine.services.security.remote.roles.RemoteSecurityRoles;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class RemoteSecurityRolesImpl
extends PortableRemoteObject
implements RemoteSecurityRoles {
    private SecurityRoleContext roles = null;

    public RemoteSecurityRolesImpl(SecurityRoleContext roles) throws RemoteException {
        this.roles = roles;
    }

    public SecurityRole addSecurityRole(String securityRole) throws RemoteException, SecurityException {
        try {
            return this.roles.addSecurityRole(securityRole);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6050", new Object[]{securityRole}, e);
        }
    }

    public SecurityRole addSecurityRoleReference(String roleName, String policyConfiguration, String securityRole) throws RemoteException, SecurityException {
        try {
            return this.roles.addSecurityRoleReference(roleName, policyConfiguration, securityRole);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6051", new Object[]{securityRole}, e);
        }
    }

    public SecurityRole getSecurityRole(String securityRole) throws RemoteException, SecurityException {
        try {
            return this.roles.getSecurityRole(securityRole);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6052", new Object[]{securityRole}, e);
        }
    }

    public SecurityRole[] listSecurityRoles() throws RemoteException, SecurityException {
        try {
            return this.roles.listSecurityRoles();
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6053", e);
        }
    }

    public SecurityRole[] listSecurityRolesOfGroup(String groupName) throws RemoteException, SecurityException {
        try {
            return this.roles.listSecurityRolesOfGroup(groupName);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6054", new Object[]{groupName}, e);
        }
    }

    public SecurityRole[] listSecurityRolesOfUser(String userName) throws RemoteException, SecurityException {
        try {
            return this.roles.listSecurityRolesOfUser(userName);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6055", new Object[]{userName}, e);
        }
    }

    public void modifySecurityRole(SecurityRole securityRole) throws RemoteException, SecurityException {
        try {
            SecurityRole role = this.roles.getSecurityRole(securityRole.getName());
            role.setDescription(securityRole.getDescription());
            String[] old_users = role.getUsers();
            String[] old_groups = role.getGroups();
            String[] new_users = securityRole.getUsers();
            String[] new_groups = securityRole.getGroups();
            int i = 0;
            while (i < new_users.length) {
                if (!this.exists(new_users[i], old_users)) {
                    role.addUser(new_users[i]);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < new_groups.length) {
                if (!this.exists(new_groups[i2], old_groups)) {
                    role.addGroup(new_groups[i2]);
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < old_users.length) {
                if (!this.exists(old_users[i3], new_users)) {
                    role.removeUser(old_users[i3]);
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < old_groups.length) {
                if (!this.exists(old_groups[i4], new_groups)) {
                    role.removeGroup(old_groups[i4]);
                }
                ++i4;
            }
            String runAsIdentity = securityRole.getRunAsIdentity(false);
            if (runAsIdentity != null) {
                role.setRunAsIdentity(runAsIdentity);
            }
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6056", new Object[]{securityRole}, e);
        }
    }

    private final boolean exists(String name, String[] names) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeSecurityRole(String securityRole) throws RemoteException, SecurityException {
        try {
            this.roles.removeSecurityRole(securityRole);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6057", new Object[]{securityRole}, e);
        }
    }
}

